<?php defined('SYSPATH') or die('No direct script access.');

//-- Environment setup --------------------------------------------------------

/**
 * Set the default time zone.
 *
 * @see  http://docs.kohanaphp.com/about.configuration
 * @see  http://php.net/timezones
 */
date_default_timezone_set('Europe/Warsaw');

/**
 * Set the default locale.
 *
 * @see  http://docs.kohanaphp.com/about.configuration
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'pl_PL.utf-8');

/**
 * Enable the Kohana auto-loader.
 *
 * @see  http://docs.kohanaphp.com/about.autoloading
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Kohana', 'auto_load'));

/**
 * Enable the Kohana auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

//-- Configuration and initialization -----------------------------------------

/**
 * Set Kohana::$environment if a 'KOHANA_ENV' environment variable has been supplied.
 */
if (isset($_SERVER['KOHANA_ENV']))
{
    Kohana::$environment = $_SERVER['KOHANA_ENV'];
}

/**
 * Initialize Kohana, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */
Kohana::init(array(
    'base_url'   => '/elearning/',
    'index_file' => FALSE,
    'errors'     => TRUE,
    'profile'    => Kohana::$environment === Kohana::DEVELOPMENT,
    'caching'    => Kohana::$environment === Kohana::PRODUCTION
));

/**
 * Attach the file write to logging. Multiple writers are supported.
 */
Kohana::$log->attach(new Kohana_Log_File(APPPATH.'logs'));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Kohana::$config->attach(new Kohana_Config_File);

/**
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Kohana::modules(array(
    'acl'           => MODPATH.'acl',
    'jelly'         => MODPATH.'jelly',
	'jelly-auth'    => MODPATH.'jelly-auth',
    'auth'          => MODPATH.'auth',
	'database'      => MODPATH.'database',
	'image'         => MODPATH.'image',
	'pagination'    => MODPATH.'pagination',
    'smarty'        => MODPATH.'smarty',
    'jelly-mptt'    => MODPATH.'jelly-mptt',
    'email'         => MODPATH.'email',
    'cache'         => MODPATH.'cache',
    'captcha'       => MODPATH.'captcha',
    'tracker'       => MODPATH.'tracker',
    'xgffmpeg'      => MODPATH.'xgffmpeg',
    'imagefly'      => MODPATH.'imagefly',
	'log-email'     => MODPATH.'log-email',
    'minion'        => MODPATH.'minion',
    'breadcrumbs'   => MODPATH.'breadcrumbs',
    'debug-toolbar' => MODPATH.'debug-toolbar',
    'articles'      => APPPATH.'modules/articles',
    'contact'       => APPPATH.'modules/contact',
    'lessons'       => APPPATH.'modules/lessons',
    'tests'         => APPPATH.'modules/tests',
    'exercises'     => APPPATH.'modules/exercises',
    'scorm'         => APPPATH.'modules/scorm',
    'videosync'     => APPPATH.'modules/videosync'
));

if (Kohana::$environment === Kohana::PRODUCTION)
{
    Kohana::$log->attach(new Log_Email, array(Kohana::ERROR, Kohana::CRITICAL, Kohana::ALERT));
}

/**
 * Konfiguracja globalna
 */
if (($cache = Cache::instance()->get('cms_settings')) !== NULL)
{
    $settings = $cache;
}
else
{
    $settings = DB::select()->from('settings')->execute()->as_array();
    
    Cache::instance()->set('cms_settings', $settings, FALSE, array('cms_settings'));
}

foreach($settings as $key => $row) {
    define('CFG_'.$row['key'], $row['value']);
}

/**
 * Set the routes. Each route must have a minimum of a name, a URI and a set of
 * defaults for the URI.
 */
//if (!Route::cache()) {
	Route::set('admin', 'admin(/<controller>(/<action>(/<id>(/<stuff>(/<stuff2>(/<stuff3>))))))', array('id' => '.*?', 'stuff' => '.*?', 'stuff2' => '.*?', 'stuff3' => '.*?'))
		->defaults(array(
			'stuff'      => '',
			'stuff2'     => '',
            'stuff3'     => '',
			'controller' => 'welcome',
			'action'     => 'index',
			'directory'  => 'admin',
		));

	Route::set('downloader', 'pobierz/<id>.html', array('id' => '.*?'))
		->defaults(array(
			'controller' => 'download',
			'action'     => 'index',
			'id'   => NULL
		));

	Route::set('infopages', 'artykul/<slug>', array('slug' => '.*?'))
		->defaults(array(
			'controller' => 'infopages',
			'action' => 'index'
		));

	  
	Route::set('pages', 'pages/<permalink>', array('permalink'=>'.+'))
		->defaults(array(
			'controller' => 'page',
			'action'     => 'index',
			'permalink'  => ''
		));

	Route::set('error', 'error/<action>(/<message>)', array('action' => '[0-9]++', 'message' => '.+'))
		->defaults(array(
			'controller' => 'error_handler'
		));
			
	Route::set('default', '(<controller>(/<action>(/<id>(/<stuff>(/<stuff2>(/<stuff3>(/<stuff4>)))))))')
		->defaults(array(
			'controller' => 'index',
			'action'     => 'index'
		));

	//Route::cache(TRUE);
//}


/**
 * Execute the main request. A source of the URI can be passed, eg: $_SERVER['PATH_INFO'].
 * If no source is specified, the URI will be automatically detected.
 */
if ( ! defined('SUPPRESS_REQUEST'))
{
    $request = Request::instance();
    
    try {
        $request->execute();
    }
    catch (ACL_Exception_401 $e) {
        Kohana::$log->add(Kohana::ERROR, Kohana::exception_text($e));
        
        $request->status = 401;   
        $request->response = View::factory('smarty:errors/401');
    }
    catch (ACL_Exception_403 $e) {
        Kohana::$log->add(Kohana::ERROR, Kohana::exception_text($e));
        
        $request->status = 403;   
        $request->response = View::factory('smarty:errors/403');
    }
    
    if ($request->response)
    {
        $total = array(
            '{memory_usage}'   => number_format((memory_get_peak_usage() - KOHANA_START_MEMORY) / 1024, 2).'KB',
            '{execution_time}' => number_format(microtime(TRUE) - KOHANA_START_TIME, 5).' seconds'
        );
        
        $request->response = strtr((string) $request->response, $total);
    }
    
    /**
     * Display the request response.
     */
    echo $request->send_headers()->response;
}