<?php defined('SYSPATH') or die('No direct script access.');

//-- Environment setup --------------------------------------------------------

/**
 * Set the default time zone.
 *
 * @see  http://docs.kohanaphp.com/about.configuration
 * @see  http://php.net/timezones
 */
date_default_timezone_set('Europe/Warsaw');

/**
 * Set the default locale.
 *
 * @see  http://docs.kohanaphp.com/about.configuration
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'pl_PL.utf-8');

/**
 * Enable the Kohana auto-loader.
 *
 * @see  http://docs.kohanaphp.com/about.autoloading
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Kohana', 'auto_load'));

/**
 * Enable the Kohana auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

//-- Configuration and initialization -----------------------------------------

/**
 * Set Kohana::$environment if a 'KOHANA_ENV' environment variable has been supplied.
 */
if (isset($_SERVER['KOHANA_ENV']))
{
    Kohana::$environment = $_SERVER['KOHANA_ENV'];
}

/**
 * Initialize Kohana, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */
Kohana::init(array(
    'base_url'   => '/elearning/',
    'index_file' => FALSE,
    'errors'     => TRUE,
    'profile'    => Kohana::$environment === Kohana::DEVELOPMENT,
    'caching'    => Kohana::$environment === Kohana::PRODUCTION
));

/**
 * Attach the file write to logging. Multiple writers are supported.
 */
Kohana::$log->attach(new Kohana_Log_File(APPPATH.'logs'));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Kohana::$config->attach(new Kohana_Config_File);

/**
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Kohana::modules(array(
    'acl'           => MODPATH.'acl',
    'jelly'         => MODPATH.'jelly',
	'jelly-auth'    => MODPATH.'jelly-auth',
    'auth'          => MODPATH.'auth',
	'database'      => MODPATH.'database',
	'image'         => MODPATH.'image',
	'pagination'    => MODPATH.'pagination',
    'smarty'        => MODPATH.'smarty',
    'jelly-mptt'    => MODPATH.'jelly-mptt',
    'email'         => MODPATH.'email',
    'cache'         => MODPATH.'cache',
    'captcha'       => MODPATH.'captcha',
    'tracker'       => MODPATH.'tracker',
    'xgffmpeg'      => MODPATH.'xgffmpeg',
    'imagefly'      => MODPATH.'imagefly',
	'log-email'     => MODPATH.'log-email',
    'minion'        => MODPATH.'minion',
    'breadcrumbs'   => MODPATH.'breadcrumbs',
    'debug-toolbar' => MODPATH.'debug-toolbar',
    'articles'      => APPPATH.'modules/articles',
    'contact'       => APPPATH.'modules/contact',
    'lessons'       => APPPATH.'modules/lessons',
    'tests'         => APPPATH.'modules/tests',
    'exercises'     => APPPATH.'modules/exercises',
    'scorm'         => APPPATH.'modules/scorm',
    'videosync'     => APPPATH.'modules/videosync'
));