<?php defined('SYSPATH') or die('No direct access allowed.');

class Arr extends Kohana_Arr {
    public static function kshuffle(&$array)
    {
        if(!is_array($array) || empty($array)) {
            return false;
        }
        $tmp = array();
        foreach($array as $key => $value) {
            $tmp[] = array('k' => $key, 'v' => $value);
        }
        shuffle($tmp);
        $array = array();
        foreach($tmp as $entry) {
            $array[$entry['k']] = $entry['v'];
        }
        return true;
    }
    
    /**
     * @param array Tablica do posortowania
     * @param string Klucz po ktorym chcemy posortowac
     * @param integer Typ sortowania:
     * 1000 - ASC_AZ
     * 1001 - DESC_AZ
     * 1002 - ASC_NUM
     * 1003 - DESC_NUM
     */
    public static function stickysort($arr, $field, $sort_type, $sticky_fields = array())
    {
        define( 'ASC_AZ', 1000 );
        define( 'DESC_AZ', 1001 );
        define( 'ASC_NUM', 1002 );
        define( 'DESC_NUM', 1003 );
        
        $i = 0;
        foreach ($arr as $value)
        {
            $is_contiguous = true;
            if(!empty($grouped_arr))
            {
                $last_value = end($grouped_arr[$i]);
                
                if(!($sticky_fields == array()))
                {
                    foreach ($sticky_fields as $sticky_field) {
                        if ($value[$sticky_field] <> $last_value[$sticky_field])
                        {
                            $is_contiguous = false;
                            break;
                        }
                    }
                }
            }
                
            if ($is_contiguous)
            {
                $grouped_arr[$i][] = $value;
            }
            else
            {
                $grouped_arr[++$i][] = $value;
            }
        }
            
        $code = '';
        switch($sort_type){
            case ASC_AZ:
                $code .= 'return strcasecmp($a["'.$field.'"], $b["'.$field.'"]);';
            break;
            case DESC_AZ:
                $code .= 'return (-1*strcasecmp($a["'.$field.'"], $b["'.$field.'"]));';
            break;
            case ASC_NUM:
                $code .= 'return ($a["'.$field.'"] - $b["'.$field.'"]);';
            break;
            case DESC_NUM:
                $code .= 'return ($b["'.$field.'"] - $a["'.$field.'"]);';
            break;
        }
    		
  		$compare = create_function('$a, $b', $code);
        foreach($grouped_arr as $grouped_arr_key => $grouped_arr_value) {
            usort ( $grouped_arr[$grouped_arr_key], $compare );
        }
    
        $arr = array();
        foreach($grouped_arr as $grouped_arr_key => $grouped_arr_value) {
            foreach($grouped_arr[$grouped_arr_key] as $grouped_arr_arr_key => $grouped_arr_arr_value) {
                $arr[] = $grouped_arr[$grouped_arr_key][$grouped_arr_arr_key];
      		}
       	}
            
        return $arr;
    }
}