<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Course_Categories extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('pages', 'list');
        
        $this->template->content = View::factory('admin/courses/categories/list.tpl')
            ->bind('message', $message)
            ->bind('sections', $sections)
            ->bind('items', $tree);
        
        $message = message::get_once();
            
        $root = Jelly::factory('course_category')->root(1);
        $tree = $root->descendants(false, 'ASC');
    }
    
    public function action_add() {
        parent::$_acl->check('pages', 'add');
        
        $this->template->content = View::factory('admin/courses/categories/add.tpl')
            ->bind('errors', $errors)
            ->bind('tree', $tree);
        
        $root = Jelly::factory('course_category')->root(1);
        $tree = $root->descendants(false, 'ASC');
                
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('category', 'not_empty')
                ->rule('name', 'not_empty');

            if ($post->check()) {
                $item = Jelly::factory('course_category');

                if (input::post('category') == 0) {
                    $root = $item->root(1);
                    $item->parent_id = 0;
                    $item->insert_as_last_child($root);
                }
                else {
                    $item->parent_id = input::post('category');
                    $item->insert_as_last_child(input::post('category'));
                }

                $item->name = Security::xss_clean(input::post('name'));
                $item->save();
                                
                Tracker::track(__('Dodano kategorie szkoleń ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/course_categories');
            }
            else {
                $errors = $post->errors('backend/course/category/form');
            }
        }
    }

    public function action_edit() {
        parent::$_acl->check('pages', 'edit');
    
        $this->template->content = View::factory('admin/courses/categories/edit.tpl')
            ->bind('errors', $errors)
            ->bind('root', $root)
            ->bind('tree', $tree)
            ->bind('item', $item);
        
        $root = Jelly::factory('page')->root(1);
        $tree = $root->descendants(false, 'ASC');
        
        $item = Jelly::select('course_category', $this->request->param('id'));
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('category', 'not_empty')
                ->rule('name', 'not_empty');

            if ($post->check()) {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                if ($item->parent->id != (int)input::post('category')) {
                    $item->parent_id = input::post('category');
                    $item->move_to_first_child(input::post('category'));
                    $item->reload();
                    $item->save();
                }
                
                Tracker::track(__('Edycja kategorii szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/course_categories');
            }
            else {
                $errors = $post->errors('backend/course/categories/form');
            }
        }
    }

    public function action_up() {
        parent::$_acl->check('pages', 'edit');
        
        $item = Jelly::select('course_category', $this->request->param('id'));
        if ($item->loaded()) {
            $item->move_up();
            
            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/course_categories');
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }
     
    public function action_down() {
        parent::$_acl->check('pages', 'edit');
        
        $item = Jelly::select('course_category', $this->request->param('id'));
        if ($item->loaded()) {
            $item->move_down();
            
            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/course_categories');
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }

    public function action_status() {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::query('course_category', $this->request->param('id'))->select();
            if ($item->loaded()) {
                if ($this->request->param('stuff') == '1') {
                    if (!empty($item->parent->id)) {
                        if ($item->parent->active == '0') {
                            message::error(__('Nie możesz opublikować tej kategorii gdyż jej rodzic jest odpublikowany'), 'admin/course_categories');
                        }
                    }
                }
                
                $item->active = $this->request->param('stuff');
                $item->save();
                
                if ($this->request->param('stuff') == '0') {
                    if ($item->has_children()) {
                        foreach($item->children() as $ch) {
                            $ch->active = 0;
                            $ch->save();
                        }
                    }
                }

                Tracker::track(__('Zmiana statusu kategori szkoleń ID: ').$item->id);

                message::good(__('Status został zmieniony pomyślnie'), 'admin/course_categories');
            }
            else {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_delete() {
        parent::$_acl->check('pages', 'delete');
        
        $item = Jelly::select('course_category', $this->request->param('id'));
        
        if ($item->loaded()) {
            Tracker::track(__('Usunięto kategorie szkoleń ID: ').$item->id);
            
            $item->delete_obj();
                       
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/course_categories');
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin/course_categories');
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('pages', 'delete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_category', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto kategorie szkoleń ID: ').$item->id);
                                
                                $item->delete_obj();
                            }
                        }
                    }
                break;
            }
            
            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/course_categories');
        }
    }
}
