<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'OFC/open-flash-chart');
require_once Kohana::find_file('vendor/', 'PHPExcel');
require_once Kohana::find_file('vendor/PHPExcel/Writer/', 'Excel5');
require_once Kohana::find_file('vendor/mpdf', 'mpdf');

class Controller_Admin_Course_Reports_Notpassed extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/courses/reports/notpassed/list.tpl')
            ->bind('chart_uri', $chart_uri);
        
        $range = input::get('range') ? input::get('range') : 'cy';
        
        $group = input::get('group') ? input::get('group') : '3';
        
        $start_on = input::get('start_on') ? input::get('start_on') : date('Y-m-d', strtotime('-7 day'));
        
        $end_on = input::get('end_on') ? input::get('end_on') : date('Y-m-d');
        
        $chart_uri = urlencode(URL::site('admin/course_reports_notpassed/chart').URL::query(array('range' => $range, 'group' => $group, 'start_on' => $start_on, 'end_on' => $end_on)));
    }
    
    public function action_csv()
    {
        $range = input::get('range') ? input::get('range') : 'cy';
        
        $grouped = input::get('group') ? input::get('group') : '3';
        
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setCreator("etdXLSexport");
        $objPHPExcel->getProperties()->setLastModifiedBy("etdXLSexport");
        $objPHPExcel->getProperties()->setTitle("etdXLSexport");
        $objPHPExcel->getProperties()->setSubject("etdXLSexport");
        $objPHPExcel->getProperties()->setDescription("etdXLSexport");
        $objPHPExcel->setActiveSheetIndex(0);
            
        switch($range) {
            case 'cm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), date('d'), date('y')));
            break;
            case 'pm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m')-1, 1, date('y')));
                
                $end_on = date('Y-m-t', strtotime("last month"));
            break;
            case 'cq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q + 3, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 1, date('y')));
            break;
            case 'pq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q - 3, 1, date('y')));
            break;
            case 'cy':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y')));
            break;
            case 'py':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y', strtotime('-1 year'))));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y', strtotime('-1 year'))));
            break;
            case 'custom':
                $start_on = input::get('start_on') ? input::get('start_on') : date('Y-m-d', strtotime('-7 day'));
        
                $end_on = input::get('end_on') ? input::get('end_on') : date('Y-m-d');
            break;
        }
        
        switch($grouped) {
            case '1':
                //dni
                $format = 'Y-m-d';
            break;
            case '2':
                //tygodnie
                $format = 'W-Y';
            break;
            case '3':
                //miesiace
                $format = 'm-Y';
            break;
            case '4':
                //kwartaly
                $format = 'q';
            break;
            case '5':
                //lata
                $format = 'Y';
            break;
        }
        
        $items = Jelly::select('report_daily')
            ->where_open()
            ->where('created_on', '>=', $start_on)
            ->where('created_on', '<=', $end_on)
            ->where_close()
            ->where('percent', '<=', '100')
            ->where('last_on', '!=', NULL)
            ->group_by('course_id')
            ->execute();
            
        
        $data = array();
        foreach($items as $it) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($it->created_on))/3).'-'.date('Y', strtotime($it->created_on)) : date($format, strtotime($it->created_on));

            if ( ! isset($data[$group]['total']))
            {
                $data[$group]['total'] = 0;
            }
            
            $data[$group]['total'] += 1;
        }
        
        $x_labels = array();
        switch($grouped) {
            case '1':
                //dni
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[] = $day;
                }
            break;
            case '2':
                //tygodnie
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('W', strtotime($day)).'-'.date('Y', strtotime($day))] = date('W', strtotime($day))." t.-".date('Y', strtotime($day));
                }
            break;
            case '3':
                //miesiace
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('m', strtotime($day)).'-'.date('Y', strtotime($day))] = date('m', strtotime($day))."-".date('Y', strtotime($day));
                }
            break;
            case '4':
                //kwartaly
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day))] = ceil(date('n', strtotime($day))/3)."-".date('Y', strtotime($day));
                }
            break;
            case '5':
                //lata
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('Y', strtotime($day))] = date('Y', strtotime($day));
                }
            break;
        }
        
        $linear = array();
        $days = Date::get_days($start_on, $end_on);
        foreach($days as $day) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day)) : date($format, strtotime($day));
            
            if (isset($data[$group]['total']))
            {
                $linear[$group] = $data[$group]['total'];
            }
            else
            {
                $linear[$group] = 0;
            }
        }
        
        $int_colCounter = 0;
        foreach($x_labels as $label) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($int_colCounter, 1, $label);
            
            $int_colCounter++;
        }
        
        $int_colCounter = 0;
        $int_rowCounter = 2;
        
        foreach($linear as $key => $val) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($int_colCounter, $int_rowCounter, $val);
            
            $int_colCounter++;
        }
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="raport_niezaliczone_szkolenia_'.date('Y_m_d').'.csv"');
        header('Cache-Control: max-age=0');
        
        $objWriter = new PHPExcel_Writer_CSV($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }
    
    public function action_pdf()
    {
        $range = input::get('range') ? input::get('range') : 'cy';
        
        $grouped = input::get('group') ? input::get('group') : '3';
        
        switch($range) {
            case 'cm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), date('d'), date('y')));
            break;
            case 'pm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m')-1, 1, date('y')));
                
                $end_on = date('Y-m-t', strtotime("last month"));
            break;
            case 'cq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q + 3, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 1, date('y')));
            break;
            case 'pq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q - 3, 1, date('y')));
            break;
            case 'cy':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y')));
            break;
            case 'py':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y', strtotime('-1 year'))));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y', strtotime('-1 year'))));
            break;
            case 'custom':
                $start_on = input::get('start_on') ? input::get('start_on') : date('Y-m-d', strtotime('-7 day'));
        
                $end_on = input::get('end_on') ? input::get('end_on') : date('Y-m-d');
            break;
        }
        
        switch($grouped) {
            case '1':
                //dni
                $format = 'Y-m-d';
            break;
            case '2':
                //tygodnie
                $format = 'W-Y';
            break;
            case '3':
                //miesiace
                $format = 'm-Y';
            break;
            case '4':
                //kwartaly
                $format = 'q';
            break;
            case '5':
                //lata
                $format = 'Y';
            break;
        }
        
        $items = Jelly::select('report_daily')
            ->where_open()
            ->where('created_on', '>=', $start_on)
            ->where('created_on', '<=', $end_on)
            ->where_close()
            ->where('percent', '<=', '100')
            ->where('last_on', '!=', NULL)
            ->group_by('course_id')
            ->execute();
            
        
        $data = array();
        foreach($items as $it) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($it->created_on))/3).'-'.date('Y', strtotime($it->created_on)) : date($format, strtotime($it->created_on));

            if ( ! isset($data[$group]['total']))
            {
                $data[$group]['total'] = 0;
            }
            
            $data[$group]['total'] += 1;
        }
        
        $x_labels = array();
        switch($grouped) {
            case '1':
                //dni
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[] = $day;
                }
            break;
            case '2':
                //tygodnie
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('W', strtotime($day)).'-'.date('Y', strtotime($day))] = date('W', strtotime($day))." t.-".date('Y', strtotime($day));
                }
            break;
            case '3':
                //miesiace
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('m', strtotime($day)).'-'.date('Y', strtotime($day))] = date('m', strtotime($day))."-".date('Y', strtotime($day));
                }
            break;
            case '4':
                //kwartaly
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day))] = ceil(date('n', strtotime($day))/3)."-".date('Y', strtotime($day));
                }
            break;
            case '5':
                //lata
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('Y', strtotime($day))] = date('Y', strtotime($day));
                }
            break;
        }
        
        $linear = array();
        $days = Date::get_days($start_on, $end_on);
        foreach($days as $day) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day)) : date($format, strtotime($day));
            
            if (isset($data[$group]['total']))
            {
                $linear[$group] = $data[$group]['total'];
            }
            else
            {
                $linear[$group] = 0;
            }
        }
        
        $table = '<table style="margin:0 0 33px 19px; border-right: 1px solid #ddd; border-top: 1px solid #ddd; font-size: 12px;" width="100%">'."\n";
        $table .= "\t<tr>";
        foreach($x_labels as $label) {
            $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">' . $label . '</th>';
        }
        $table .= "</tr>\n";
        
        $table .= "\t<tr>" ;
        foreach($linear as $key => $val) {
            $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
            $table .= "\n" . $val . "\n";
            $table .= '</td>';
        }
        $table .= "</tr>\n";
        
        $table .= '</table>';
        
        $parameters = array(
            '%title%' => 'Niezaliczone szkolenia',
            '%content%' => $table
        );
        
        $body = str_replace(array_keys($parameters), array_values($parameters), CFG_PDF_REPORT_TEMPLATE);
        
        $content_html = View::factory('smarty:site/emails/pdf')
            ->set('content', $body)
            ->render();
        
        $mpdf=new mPDF('UTF-8', array(298.89,340.55), 12, 'minyaregular'); 
        $mpdf->mirrorMargins = 1;	// Use different Odd/Even headers and footers and mirror margins
        
        $mpdf->defaultheaderfontsize = 10;	/* in pts */
        $mpdf->defaultheaderfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultheaderline = 1; 	/* 1 to include line below header/above footer */
        
        $mpdf->defaultfooterfontsize = 12;	/* in pts */
        $mpdf->defaultfooterfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultfooterline = 1; 	/* 1 to include line below header/above footer */
        
        $mpdf->SetFooter(array(
           'odd' => array(
               'L' => array(
            		'content' => CFG_PLATFORM_NAME,
            		'font-family' => 'arial',
            		'font-style' => 'B',	/* blank, B, I, or BI */
            		'font-size' => '10',	/* in pts */
    	       ),
               'C' => array(
                    'content' => '{PAGENO}/{nb}',
            		'font-family' => 'arial',
            		'font-style' => 'BI',
            		'font-size' => '10',	/* gives default */
               ),
               'R' => array(
            		'content' => 'Wydrukowano {DATE j-m-Y H:i}',
            		'font-family' => 'arial',
            		'font-style' => '',
            		'font-size' => '10',
               ),
               'line' => 1
           ),
           'even' => array(
               'L' => array(
            		'content' => CFG_PLATFORM_NAME,
            		'font-family' => 'arial',
            		'font-style' => 'B',	/* blank, B, I, or BI */
            		'font-size' => '10',	/* in pts */
    	       ),
               'C' => array(
                    'content' => '{PAGENO}/{nb}',
            		'font-family' => 'arial',
            		'font-style' => 'BI',
            		'font-size' => '10',	/* gives default */
               ),
               'R' => array(
            		'content' => 'Wydrukowano {DATE j-m-Y H:i}',
            		'font-family' => 'arial',
            		'font-style' => '',
            		'font-size' => '10',
               ),
               'line' => 1
           )
        ));
        
        $mpdf->WriteHTML($content_html);
        $mpdf->Output('raport_niezaliczone_szkolenia_'.date('Y_m_d').'.pdf', 'D');
    }
    
    public function action_chart()
    {
        switch(input::get('range')) {
            case 'cm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, date('m'), date('d'), date('y')));
            break;
            case 'pm':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, date('m')-1, 1, date('y')));
                
                $end_on = date('Y-m-t', strtotime("last month"));
            break;
            case 'cq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q + 3, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 1, date('y')));
            break;
            case 'pq':
                $month = date('n')-1;
                $q = $month - ($month % 3) + 1;
                
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, $q, 0, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, $q - 3, 1, date('y')));
            break;
            case 'cy':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y')));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y')));
            break;
            case 'py':
                $start_on = date('Y-m-d', gmmktime(0, 0, 0, 1, 1, date('y', strtotime('-1 year'))));
                
                $end_on = date('Y-m-d', gmmktime(0, 0, 0, 12, 31, date('y', strtotime('-1 year'))));
            break;
            case 'custom':
                $start_on = input::get('start_on') ? input::get('start_on') : date('Y-m-d', strtotime('-7 day'));
        
                $end_on = input::get('end_on') ? input::get('end_on') : date('Y-m-d');
            break;
        }
        
        switch(input::get('group')) {
            case '1':
                //dni
                $format = 'Y-m-d';
            break;
            case '2':
                //tygodnie
                $format = 'W-Y';
            break;
            case '3':
                //miesiace
                $format = 'm-Y';
            break;
            case '4':
                //kwartaly
                $format = 'q';
            break;
            case '5':
                //lata
                $format = 'Y';
            break;
        }
        
        $items = Jelly::select('report_daily')
            ->where_open()
            ->where('created_on', '>=', $start_on)
            ->where('created_on', '<=', $end_on)
            ->where_close()
            ->where('percent', '<=', '100')
            ->where('last_on', '!=', NULL)
            ->group_by('course_id')
            ->execute();
            
        
        $data = array();
        foreach($items as $it) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($it->created_on))/3).'-'.date('Y', strtotime($it->created_on)) : date($format, strtotime($it->created_on));

            if ( ! isset($data[$group]['total']))
            {
                $data[$group]['total'] = 0;
            }
            
            $data[$group]['total'] += 1;
        }
        
        $range_line = array();
        $linear = array();
        
        $days = Date::get_days($start_on, $end_on);
        foreach($days as $day) {
            $group = ($format == 'q') ? ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day)) : date($format, strtotime($day));
            
            if (isset($data[$group]['total']))
            {
                $d = new dot($data[$group]['total']);
                $linear[$group] = $d->colour('#D02020')->tooltip("Data: ".$group."\nIlość: #val#");
            
                $range_line[] = $data[$group]['total'];
            }
            else
            {
                $d = new dot(0);
                $linear[$group] = $d->colour('#D02020')->tooltip("Data: ".$group."\nIlość: #val#");
            }
        }
        
        if (empty($range_line))
        {
            $range_line[] = 0;
        }
        
        $line1 = new area();
        $line1->set_width(3);
        $line1->set_colour('#83BC25');
        $line1->set_values(array_values($linear));
        
                
        $y = new y_axis();
        $y->set_colour('#DADADA');
        $y->set_stroke(2);
        $y->range(0, max($range_line)+20, ceil((max($range_line)+20)/10));
        $y->set_offset(TRUE);
        $y_axis_labels = new y_axis_labels();
        $y_axis_labels->set_colour('#000000');
        $y->set_labels($y_axis_labels);
        
        $x_labels = array();
        switch(input::get('group')) {
            case '1':
                //dni
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[] = $day;
                }
            break;
            case '2':
                //tygodnie
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('W', strtotime($day)).'-'.date('Y', strtotime($day))] = date('W', strtotime($day))." t.\n".date('Y', strtotime($day));
                }
            break;
            case '3':
                //miesiace
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('m', strtotime($day)).'-'.date('Y', strtotime($day))] = date('m', strtotime($day))."\n".date('Y', strtotime($day));
                }
            break;
            case '4':
                //kwartaly
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[ceil(date('n', strtotime($day))/3).'-'.date('Y', strtotime($day))] = ceil(date('n', strtotime($day))/3)."\n".date('Y', strtotime($day));
                }
            break;
            case '5':
                //lata
                $days = Date::get_days($start_on, $end_on);
                foreach($days as $day) {
                    $x_labels[date('Y', strtotime($day))] = date('Y', strtotime($day));
                }
            break;
        }
        
            
        $x = new x_axis();
        $x->set_grid_colour('#DADADA');
        $x->set_colour('#DADADA');
        $x->set_tick_height(0);
        $x_axis_labels = new x_axis_labels();
		$x_axis_labels->set_labels(array_values($x_labels));
        $x_axis_labels->set_colour('#000000');
        $x_axis_labels->set_steps(ceil(count($x_labels)/5));
        $x->set_labels($x_axis_labels);
        
    	$chart = new open_flash_chart();
    	$chart->set_title('');
        $chart->set_bg_colour('#FFFFFF');
        $chart->set_y_axis($y);
        $chart->set_x_axis($x);
        $chart->add_element($line1);
        
        echo $chart->toPrettyString();
        exit;
    }
}