<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Forums extends Relio_Controller_Admin {
    public function action_add()
    {
        $this->template->content = View::factory('admin/forum/forums/add.tpl')
            ->bind('errors', $errors);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $password_encode = input::post('password_raw') ? md5(input::post('password_raw')) : '';
            
                $item = Jelly::factory('forum_forum');
                $item->preparePosy($this->request->param('id'));
                $item->category = $this->request->param('id');
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->password_raw = input::post('password_raw');
                $item->password = $password_encode;
                $item->posy = 1;
                $item->save();
                
                Tracker::track('Dodano forum ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/forum_categories');
            }
            else
            {
                $errors = $post->errors('backend/forum/forums/form');
            }
        }
    }

    public function action_edit()
    {
        $this->template->content = View::factory('admin/forum/forums/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('forum_forum', $this->request->param('id'));
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('title', 'not_empty');
            
            if ($post->check())
            {
                $password_encode = input::post('password_raw') ? md5(input::post('password_raw')) : '';
                
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->password_raw = input::post('password_raw');
                $item->password = $password_encode;
                $item->save();

                Tracker::track('Edycja forum ID: ' . $this->request->param('id'));

                message::good('Edycja przebiegła pomyślnie', 'admin/forum_categories');
            }
            else
            {
                $errors = $post->errors('backend/forum/forums/form');
            }
        }
    }

    public function action_status()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_forum', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu forum ID: '.$this->request->param('id'));

                message::good('Status został zmieniony pomyślnie', 'admin/forum_categories');
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin');
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_locked()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_forum', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->locked = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu forum ID: '.$this->request->param('id'));

                message::good('Status został zmieniony pomyślnie', 'admin/forum_categories');
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin');
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_up()
    {
        $item = Jelly::select('forum_forum', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->positionUp($item->category->id);
            
            Tracker::track('Zmieniono pozycje forum ID: ' . $this->request->param('id'));
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas ustawiania pozycji', 'admin');
        }
    }
     
    public function action_down()
    {
        $item = Jelly::select('forum_forum', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->positionDown($item->category->id);
            
            Tracker::track('Zmieniono pozycje forum ID: '.$this->request->param('id'));
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas ustawiania pozycji', 'admin');
        }
    }

    public function action_delete()
    {
        $item = Jelly::select('forum_forum', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->delete();

            Tracker::track('Usunięto forum ID: '.$this->request->param('id'));

            message::good('Usunięcie przebiegło pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania forum', 'admin');
        }
    }
}