<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Posts extends Relio_Controller_Admin {
    public function action_index()
    {
        ////parent::$_acl->check('courses_groups', 'list');

        $this->template->content = View::factory('admin/forum/posts/list.tpl')
            ->bind('message', $message)
            ->bind('topic', $topic)
            ->bind('items', $post_array)
            ->bind('pagination', $pagination);

        $message = message::get_once();
        
        $topic = Jelly::select('forum_topic', $this->request->param('id'));
        
        $builder = Jelly::select('forum_post')
            ->where('topic_id', '=', $topic->id)
            ->order_by('created_on', 'ASC');
                
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
        
        $post_array = array();
        foreach($items as $it) {
            $postings = DB::select(DB::expr('COUNT(*) AS count'))
                ->from('forum_posts')
                ->where('user_id', '=', $it->user->id)
                ->execute()
                ->get('count');
                    
            $rank = Jelly::select('forum_rank')
                ->where('count', '<=', $postings)
                ->where('active', '=', '1')
                ->order_by('count', 'DESC')
                ->limit(1)
                ->execute();
                    
            $post['id'] = $it->id;
            $post['name'] = $it->name;
            $post['content'] = Forum::initial_message_parse($it->content);
            $post['user'] = $it->user;
            $post['rank'] = $rank->title;
            $post['user_posts'] = $postings;
            $post['created_on'] = $it->created_on;
            $post['opened'] = $it->opened;
                    
            if ($ismodnotadmin || $ismodtopic)
            {
                $post['is_moderator'] = true;
            }
            else
            {
                $post['is_moderator'] = false;
            }
            
            if ($post->use_bbcode)
            {
                $post['content'] = strip_tags($post['content']);
            }
            
            if ($post->use_smilies)
            {
                $post['content'] = Forum::emoticons($post['content']);
            }
            
            if ($post->use_links)
            {
                $post['content'] = Text::auto_link($post['content']);
            }
            
            $post['content'] = Forum::badword($post['content']);
                    
            $post['attachments'] = Jelly::select('attachment')
                ->filter($it->id, 'forum_post')
                ->execute();
                    
            array_push($post_array, $post);
        }
    }

    public function action_add()
    {
        $this->template->content = View::factory('admin/forum/posts/add.tpl')
            ->bind('errors', $errors)
            ->bind('topic', $topic);
        
        $topic = Jelly::select('forum_topic', $this->request->param('id'));        
                
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('content', 'not_empty');
            
            if ($post->check())
            {
                //zapisz post do bazy
                $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                $posting = Jelly::factory('forum_post');
                $posting->user = Auth::instance()->get_user()->id;
                $posting->topic = $topic->id;
                $posting->name = 'Re: '.$topic->name;
                $posting->content = Security::xss_clean(input::post('content'));
                $posting->use_bbcode = $use_bbcode;
                $posting->use_smilies = $use_smilies;
                $posting->use_links = $use_links;
                $posting->opened = $active;
                $posting->save();
                
                /**
                 * Dodaj zalaczniki do posta
                 */
                foreach(input::post('attachments') as $a) {
                    $attachment = Jelly::select('attachment', $a);
                    $attachment->obj_id = $post->id;
                    $attachment->save();
                }
                    
                //zaktualizuj temat
                $topic->post = $posting->id;
                $topic->post_on = date('Y-m-d H:i:s');
                $topic->save();
                    
                //zaktualizuj forum
                $topic->forum->post = $posting->id;
                $topic->forum->post_on = date('Y-m-d H:i:s');
                $topic->forum->save();
                
                $notification_users = explode(';', $topic->notification);
                 
                foreach($notification_users as $nu) {
                    $user = Jelly::select('user', $nu);
                    if ($user->loaded())
                    {
                        $replaceData = array();
                        $replaceData['%firstname%'] = $nu->firstname;
                        $replaceData['%lastname%'] = $nu->lastname;
                        $replaceData['%poster_firstname%'] = Auth::instance()->get_user()->firstname;
                        $replaceData['%poster_lastname%'] = Auth::instance()->get_user()->lastname;
                        $replaceData['%topic_name%'] = $topic->name;
                        $replaceData['%topic_url'] = URL::site('forum/showtopic/'.$topic->id, 'http');
                        $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                        xwContentTemplateWrapper::parameter_email(19, $replaceData, $nu->email, CFG_WEBMASTER_EMAIL);
                    }
                }                

                Tracker::track('Dodano nowy post w wątku ID: '.$topic->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/forum_posts/index/'.$posting->topic->id.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/posts/form');
            }
        }
    }

    public function action_edit()
    {
        $this->template->content = View::factory('admin/forum/posts/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('attachments', $attachments);
            
        $item = Jelly::select('forum_post', $this->request->param('id'));
        
        $attachments = Jelly::select('attachment')
            ->filter($item->id, 'forum_post')
            ->execute();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('content', 'not_empty');
            
            if ($post->check())
            {
                //zapisz post do bazy
                $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                $item->content = Security::xss_clean(input::post('content'));
                $item->use_bbcode = $use_bbcode;
                $item->use_smilies = $use_smilies;
                $item->use_links = $use_links;
                $item->opened = $active;
                $item->save();
                
                /**
                 * Dodaj zalaczniki do posta
                 */
                foreach(input::post('attachments') as $a) {
                    $attachment = Jelly::select('attachment', $a);
                    $attachment->obj_id = $item->id;
                    $attachment->save();
                }
                
                Tracker::track('Edycja postu ID: '.$item->id);

                message::good('Post został zmieniony pomyślnie', 'admin/forum_posts/index/'.$item->topic->id.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/posts/form');
            }
        }
    }

    public function action_status()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_post', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->opened = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu postu ID: '.$item->id.' z wątka ID: '.$item->topic->id);

                message::good('Status został zmieniony pomyślnie', 'admin/forum_posts/index/'.$item->topic->id.URL::query());
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin');
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
        
    public function action_delete() {
        $item = Jelly::select('forum_post', $this->request->param('id'));

        if ($item->loaded())
        {
            Tracker::track('Usunięto post ID: '.$item->id.' z wątka ID: '.$item->topic->id);
            
            $forum_id = $item->topic->forum->id;
            
            $topic_id = $item->topic->id;
            
            $count = Jelly::select('forum_post')
                ->where('topic_id', '=', $topic_id)
                ->count();
                    
            if($count <= 0)
            {
                DB::delete('forum_topics')
                    ->where('id', '=', $topic_id)
                    ->execute();
            }
                    
            DB::update('forum_topics')
                ->set(array(
                    'replies' => 'replies-1'
                ))
                ->where('id', '=', $topic_id)
                ->execute();
                    
            //ustawienie nowego postu jako ostatnio dodany 
            $post = Jelly::select('forum_topic')
                ->where('id', '=', $topic_id)
                ->order_by('post_on', 'DESC')
                ->limit(1)
                ->execute();
                    
            if ($post->loaded())
            {
                DB::update('forum_forums')
                    ->set(array(
                        'post_on' => $post->created_on,
                        'post_id' => $post->id
                    ))
                    ->where('id', '=', $forum_id)
                    ->execute(); 
            }
            else
            {
                DB::update('forum_forums')
                    ->set(array(
                        'post_on' => NULL,
                        'post_id' => NULL
                    ))
                    ->where('id', '=', $forum_id)
                    ->execute(); 
                       
            }

            message::good('Usunięcie przebiegło pomyślnie', 'admin/forum_posts/index/'.$topic_id.URL::query());
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
        }
        
        message::good('Operacja przeprowadzona pomyślnie', 'admin/forum_posts/index/'.$this->request->param('id').URL::query());
    }
      
    /**
     * Checkbox - Aktywuj
     */
    private function _checkbox_publish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_post')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu posta ID: '.$it->id.' w temacie ID: '.$it->topic->id);
                    
                $it->opened = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Deaktywuj
     */
    private function _checkbox_unpublish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_post')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu posta ID: '.$it->id.' w temacie ID: '.$it->topic->id);
                    
                $it->opened = 0;
                $it->save();
            }
        }
    }
}