<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'pclzip/pcltrace.lib');
require_once Kohana::find_file('vendor', 'pclzip/pclzip-trace.lib');

class Controller_Admin_Material_Lesson extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('materials', 'edit');
        
        $this->template->content = View::factory('smarty:admin/materials/lesson/edit')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('popups', $popups)
            ->bind('item', $item)
            ->bind('lesson', $lesson)
            ->bind('parent_id', $parent_id);

        $message = message::get_once();
    
        $item = Jelly::select('material', $this->request->param('id'));
        
        $lesson = Jelly::select('material_lesson')
            ->by_material($item->id)
            ->limit(1)
            ->execute();

        $popups = Jelly::select('material_popup')
            ->by_material($item->id)
            ->execute();
        
        $parent_id = $item->category->first_parent_id;
                
        if ($_POST) {
            try {
                //video
                if (input::post('movie'))
                {
                    $moviefilename = trim(input::post('movie'), '/');
                    
                    if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies')))
                    {
                        $fileid = substr(md5(basename($moviefilename)), 0, 10);
                        $target = $fileid.'.jpg';
                        
                        $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/materials/movie/'.$target, '00:00:10', '640x360');
                        $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);
                        
                        $timer = $vinfo['duration'];
                    }
                }
                
                //prezentacja
                if (input::post('presentation'))
                {
                    $presentationfilename = Text::random('alnum', 24);
                        
                    $zip = new PclZip(trim(input::post('presentation'), '/'));
                    $zip->extract('upload/materials/presentation/'.$presentationfilename);
                    
                }
                
                if (! $lesson->loaded())
                {
                    $lesson = Jelly::factory('material_lesson');
                }
                $lesson->material = $item->id;
                $lesson->icon = trim(input::post('icon'), '/');
                $lesson->movie = trim(input::post('movie'), '/');
                $lesson->movie_duration = input::post('movie') ? $timer : ''; 
                $lesson->presentation = input::post('presentation') ? $presentationfilename : '';                
                $lesson->set($_POST);
                $lesson->save();
                
                /**
                 * Załączniki
                 */
                $attachments = explode(',', input::post('attachments_id'));
                for ($i = 0; $i <= sizeof($attachments); $i++) {
                    if (isset($attachments[$i])) {
                        $attachment = Jelly::select('attachment')->where('slug','=',$attachments[$i])->limit(1)->execute();
                        if ($attachment->loaded()) {
                            $attachment->obj_id = $item->id;
                            $attachment->save();
                        }
                    }
                }
                
                Tracker::track(__('Edycja materiału w bazie szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/base/index/'.$item->category->first_parent_id);
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }
    
    public function action_preview()
    {
        //$item = Jelly::select('material', Request::instance()->param('id'));
        
        //$lesson = Jelly::select('material_lesson')->by_material($item->id)->limit(1)->execute();
        $lesson = Jelly::select('material_lesson', Request::instance()->param('id'));
		
        echo View::factory('smarty:admin/materials/lesson/preview')
            ->bind('lesson', $lesson)
            ->render();
        
        exit;
    }
}