<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Material_Test extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('tests', 'edit');
        
        $this->template->content = View::factory('smarty:admin/materials/test/edit')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('item', $item)
            ->bind('material', $material)
            ->bind('questions', $questions)
            ->bind('category_id', $category_id);

        $message = message::get_once();
        
        $material = Jelly::select('material', $this->request->param('id'));
        
        $category_id = $material->category->first_parent_id;
        
        $item = Jelly::select('material_test')->by_material($material->id)->limit(1)->execute();
        
        $questions = Jelly::select('question')->filter($item->id)->execute();
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('questions', 'not_empty')
                ->rule('questions', 'range', array('1', '99999'))
                ->rule('questions_to_pass', 'not_empty');

            if ($post->check()) {
                if (!$item->loaded()) {
                    $item = Jelly::factory('material_test');
                }
                
                $item->material = $material->id;
                $item->questions = Security::xss_clean(input::post('questions'));
                $item->questions_to_pass = Security::xss_clean(input::post('questions_to_pass'));
                $item->random_questions = Security::xss_clean(input::post('random_questions'));
                $item->total_trials = Security::xss_clean(input::post('total_trials'));
                $item->start_on = Security::xss_clean(input::post('start_on'));
                $item->end_on = Security::xss_clean(input::post('end_on'));
                $item->time_on = Security::xss_clean(input::post('time_on'));
                $item->block_category = Security::xss_clean(input::post('block_category'));
                $item->required_good = Security::xss_clean(input::post('required_good'));
                $item->save();

                Tracker::track(__('Edycja testu dla materiału ID: ').$material->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/material_test/index/'.$material->id);
            }
            else {
                $errors = $post->errors('backend/material/test/form');
            }
        }
    }

    public function action_add_question() {
        parent::$_acl->check('tests', 'qadd');
        
        $type = input::get('type');

        $this->template->content = View::factory('smarty:admin/materials/test/questions/add'.$type)
            ->bind('errors', $errors)
            ->bind('current_test', $current_test);

        $test = Jelly::select('material_test', $this->request->param('id'));
        
        $current_test = $test->material->id;
        
        if ($_POST) {
            try {
                //ikona
                if (input::post('icon')) {
                    $filenameicon = trim(urldecode(input::post('icon')), '/');
                }
                else {
                    $filenameicon = '';
                }
                
                //video
                if (input::post('hidFileID')) {
                    $moviefilename = trim(input::post('hidFileID'), '/');

                    if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies'))) {
                        $fileid = substr(md5(basename($moviefilename)), 0, 10);
                        $target = $fileid.'.jpg';
                        
                        $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/questions/movie/'.$target, '00:00:10', '640x360');
                        $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);
                        
                        $timer = $vinfo['duration'];
                    }
                    else {
                        $timer = null;
                    }
                }
                else {
                    $moviefilename = '';
                    $timer = null;
                }

                /**
                 * Dodaj pytanie
                 */
                $question = Jelly::factory('question');
                $question->set(array(
                    'name'           => input::post('name'),
                    'hide_time'      => input::post('hide_time'),
                    'feedback_good'  => input::post('feedback_good'),
                    'feedback_wrong' => input::post('feedback_wrong'),
                    'help'           => input::post('help'),
                    'icon'           => $filenameicon,
                    'movie'          => $moviefilename,
                    'movie_duration' => $timer,
                    'type'           => input::get('type'),
                    'one_is_good'    => input::post('one_is_good')
                ));
                $question->save();

                /**
                 * Dodawanie do bazy odpowiedzi wedlug danego typu
                 */
                switch (input::get('type')) {
                    case '1':
                        $good = '0000000000';
                        $good[input::post('good') - 1] = '1';

                        $item = Jelly::factory('question_choice');
                        $item->set(array(
                            'answer1'  => input::post('answer1'),
                            'answer2'  => input::post('answer2'),
                            'answer3'  => input::post('answer3'),
                            'answer4'  => input::post('answer4'),
                            'answer5'  => input::post('answer5'),
                            'answer6'  => input::post('answer6'),
                            'answer7'  => input::post('answer7'),
                            'answer8'  => input::post('answer8'),
                            'answer9'  => input::post('answer9'),
                            'answer10' => input::post('answer10'),
                            'good'     => $good,
                            'question' => $question->id
                        ));
                        $item->save();
                    break;
                    case '2':
                        $good = '0000000000';
                        foreach (input::post('good') as $key => $val) {
                            $good[$val - 1] = '1';
                        }

                        $item = Jelly::factory('question_choice');
                        $item->set(array(
                            'answer1'  => input::post('answer1'),
                            'answer2'  => input::post('answer2'),
                            'answer3'  => input::post('answer3'),
                            'answer4'  => input::post('answer4'),
                            'answer5'  => input::post('answer5'),
                            'answer6'  => input::post('answer6'),
                            'answer7'  => input::post('answer7'),
                            'answer8'  => input::post('answer8'),
                            'answer9'  => input::post('answer9'),
                            'answer10' => input::post('answer10'),
                            'good'     => $good,
                            'question' => $question->id
                        ));
                        $item->save();
                    break;
                    case '3':
                        for ($i = 0; $i < count(input::post('field_left')); $i++) {
                            $option_left = input::post('field_left');
                            $option_right = input::post('field_right');

                            $item = Jelly::factory('question_matching');
                            $item->set(array(
                                'option_left'  => $option_left[$i],
                                'option_right' => $option_right[$i],
                                'question'     => $question->id
                            ));
                            $item->save();
                        }
                    break;
                    case '4':
                        $item = Jelly::factory('question_hotspot');
                        $item->set(array(
                            'start_x'  => input::post('start_x'),
                            'start_y'  => input::post('start_y'),
                            'end_x'    => input::post('end_x'),
                            'end_y'    => input::post('end_y'),
                            'width'    => input::post('width'),
                            'height'   => input::post('height'),
                            'icon'     => input::post('icon'),
                            'question' => $question->id
                        ));
                        $item->save();
                    break;
                    case '5':
                        $item = Jelly::factory('question_boolean');
                        $item->set(array(
                            'good'     => input::post('good'),
                            'question' => $question->id
                        ));
                        $item->save();
                    break;
                    case '6':
                        $item = Jelly::factory('question_open');
                        $item->set(array(
                            'question' => $question->id
                        ));
                        $item->save();
                    break;
                    case '7':
                        $item = Jelly::factory('question_list');
                        $item->set(array(
                            'answers'  => input::post('answers'),
                            'question' => $question->id,
                            'good'     => serialize(input::post('field_left'))
                        ));
                        $item->save();
                    break;
                    case '8':
                    
                    break;
                    case '9':
                        $item = Jelly::factory('question_memory');
                        $item->set(array(
                            'answers'  => input::post('answers'),
                            'to_pass' => input::post('to_pass'),
                            'question' => $question->id,
                            'good'     => serialize(input::post('field_left'))
                        ));
                        $item->save();
                    break;
                    case '10':
                        $item = Jelly::factory('question_sort');
                        $item->set(array(
                            'question' => $question->id,
                            'good' => serialize(input::post('answers'))
                        ));
                        $item->save();
                    break;
                }

                /**
                 * Przypisz pytanie do odpowiedniego testu
                 */
                $test->add('question', $question);
                $test->save();

                /**
                 * Załączniki
                 */
                $attachments = explode(',', input::post('attachments_id'));
                for ($i = 0; $i <= sizeof($attachments); $i++) {
                    if (isset($attachments[$i])) {
                        $attachment = Jelly::select('attachment')->where('slug', '=', $attachments[$i])->limit(1)->execute();
                        if ($attachment->loaded()) {
                            $attachment->obj_id = $question->id;
                            $attachment->save();
                        }
                    }
                }

                Tracker::track(__('Dodano nowe pytanie do testu ID: ').$this->request->param('id'));

                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/material_test/index/'.$test->material->id.'#questions');
            }
            catch (Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }

    }

    public function action_edit_question() {
        parent::$_acl->check('tests', 'qedit');
        
        $type = input::get('type');

        $this->template->content = View::factory('smarty:admin/materials/test/questions/edit'.$type)
            ->bind('errors', $errors)
            ->bind('swfjs', $swfjs)
            ->bind('swfuploader', $swfuploader)
            ->bind('swfuploaderimage', $swfuploaderimage)
            ->bind('swfuploadermovie', $swfuploadermovie)
            ->bind('current_test', $current_test)
            ->bind('question', $question)
            ->bind('item', $item);

        $question = Jelly::select('question', $this->request->param('id'));

        $current_test = $question->test->material->id;

        switch ($question->type) {
            case '1':
                $item = Jelly::select('question_choice')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '2':
                $item = Jelly::select('question_choice')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '3':
                $item = Jelly::select('question_matching')->where('question_id', '=', $question->id)->execute();
            break;
            case '4':
                $item = Jelly::select('question_hotspot')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '5':
                $item = Jelly::select('question_boolean')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '6':
                $item = Jelly::select('question_open')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '7':
                $item = Jelly::select('question_list')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '8':
            
            break;
            case '9':
                $item = Jelly::select('question_memory')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
            case '10':
                $item = Jelly::select('question_sort')->where('question_id', '=', $question->id)->limit(1)->execute();
            break;
        }

        if ($_POST) {
            try {
                //ikona
                if (input::post('image_action') == '3') {
                    if (input::post('icon')) {
                        $filenameicon = trim(urldecode(input::post('icon')), '/');
                    }
                    else {
                        $filenameicon = '';
                    }
                }
                elseif (input::post('image_action') == '1') {
                    $filenameicon = input::post('tmpIcon');
                }
                elseif (input::post('image_action') == '2') {
                    $filenameicon = '';
                }
                else {
                    $filenameicon = '';
                }
                
                //video
                if (input::post('movie_action') == '3') {
                    if (input::post('hidFileID')) {
                        $moviefilename = trim(input::post('hidFileID'), '/');

                        if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies'))) {
                            $fileid = substr(md5(basename($moviefilename)), 0, 10);
                            $target = $fileid.'.jpg';
                            
                            $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/courses/movie/'.$target, '00:00:10', '640x360');
                            $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);
                            
                            $timer = $vinfo['duration'];
                        }
                        else {
                            $timer = null;
                        }
                   }
                   else {
                        $moviefilename = '';
                        $timer = null;
                   }
                }
                elseif (input::post('movie_action') == '1') {
                    $moviefilename = input::post('tmpMovie');
                    $timer = $item->timer;
                }
                elseif (input::post('movie_action') == '2') {
                    $moviefilename = '';
                    $timer = null;
                }
                else {
                    $moviefilename = '';
                    $timer = null;
                }

                /**
                 * Dodaj pytanie
                 */
                $question->set(array(
                    'name'           => input::post('name'),
                    'hide_time'      => input::post('hide_time'),
                    'feedback_good'  => input::post('feedback_good'),
                    'feedback_wrong' => input::post('feedback_wrong'),
                    'help'           => input::post('help'),
                    'icon'           => $filenameicon,
                    'movie'          => $moviefilename,
                    'movie_duration' => $timer,
                    'type'           => input::get('type'),
                    'one_is_good'    => input::post('one_is_good')
                ));
                $question->save();

                /**
                 * Dodawanie do bazy odpowiedzi wedlug danego typu
                 */
                switch (input::get('type')) {
                    case '1':
                        $good = '0000000000';
                        $good[input::post('good') - 1] = '1';

                        $item->set(array(
                            'answer1'  => input::post('answer1'),
                            'answer2'  => input::post('answer2'),
                            'answer3'  => input::post('answer3'),
                            'answer4'  => input::post('answer4'),
                            'answer5'  => input::post('answer5'),
                            'answer6'  => input::post('answer6'),
                            'answer7'  => input::post('answer7'),
                            'answer8'  => input::post('answer8'),
                            'answer9'  => input::post('answer9'),
                            'answer10' => input::post('answer10'),
                            'good'     => $good
                        ));
                        $item->save();
                    break;
                    case '2':
                        $good = '0000000000';
                        foreach (input::post('good') as $key => $val) {
                            $good[$val - 1] = '1';
                        }

                        $item->set(array(
                            'answer1'  => input::post('answer1'),
                            'answer2'  => input::post('answer2'),
                            'answer3'  => input::post('answer3'),
                            'answer4'  => input::post('answer4'),
                            'answer5'  => input::post('answer5'), 
                            'answer6'  => input::post('answer6'),
                            'answer7'  => input::post('answer7'),
                            'answer8'  => input::post('answer8'),
                            'answer9'  => input::post('answer9'),
                            'answer10' => input::post('answer10'),
                            'good'     => $good
                        ));
                        $item->save();
                    break;
                    case '3':
                        $items = Jelly::select('question_matching')->where('question_id', '=', $question->id)->execute();
                        foreach ($items as $row) {
                            $row->delete();
                        }

                        for ($i = 0; $i < count(input::post('field_left')); $i++) {
                            $option_left = input::post('field_left');
                            $option_right = input::post('field_right');

                            $item = Jelly::factory('question_matching');
                            $item->set(array(
                                'option_left'  => $option_left[$i],
                                'option_right' => $option_right[$i],
                                'question'     => $question->id
                            ));
                            $item->save();
                        }
                    break;
                    case '4':
                        $item->set(array(
                            'start_x' => input::post('start_x'),
                            'start_y' => input::post('start_y'),
                            'end_x'   => input::post('end_x'),
                            'end_y'   => input::post('end_y'),
                            'width'   => input::post('width'),
                            'height'  => input::post('height'),
                            'icon'    => input::post('icon')
                        ));
                        $item->save();
                    break;
                    case '5':
                        $item->set(array(
                            'good' => input::post('good')
                        ));
                        $item->save();
                    break;
                    case '6':
                        $item->save();
                    break;
                    case '7':
                        $item->set(array(
                            'answers' => input::post('answers'),
                            'good'    => serialize(input::post('field_left'))
                        ));
                        $item->save();
                    break;
                    case '8':
                    
                    break;
                    case '9':
                        $item->set(array(
                            'answers' => input::post('answers'),
                            'to_pass' => input::post('to_pass'),
                            'good'    => serialize(input::post('field_left'))
                        ));
                        $item->save();
                    break;
                    case '10':
                        $item->set(array(
                            'good' => serialize(input::post('answers'))
                        ));
                        $item->save();
                    break;
                }

                Tracker::track(__('Edycja pytania ID: ').$question->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/material_test/index/'.$question->test->material->id.'#questions');
            }
            catch (Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }

    public function action_status_question() {
        parent::$_acl->check('tests', 'qedit');
        
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('question', $this->request->param('id'));
            if ($item->loaded()) {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu pytania ID: ' . $item->id . ' w tescie ID: '.$item->test->material->id);

                message::good('Status został zmieniony pomyślnie', 'admin/material_test/index/'.$item->test->material->id.'#questions');
            }
            else {
                message::error('Status nie został zmieniony', 'admin/material_test/index/'.$item->test->material->id.'#questions');
            }
        }
        else {
            message::error('Status nie został zmieniony', 'admin/material_test/index/'.$item->test->material->id.'#questions');
        }
    }

    public function action_delete_question() {
        parent::$_acl->check('tests', 'qdelete');
        
        $item = Jelly::select('question', $this->request->param('id'));
        if ($item->loaded()) {
            $test_id = $item->test->material->id;
            
            switch ($item->type) {
                case '1':
                    $type = Jelly::select('question_choice')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '2':
                    $type = Jelly::select('question_choice')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '3':
                    $type = Jelly::select('question_matching')->where('question_id', '=', $item->id)->execute();
                    foreach ($type as $row) {
                        $row->delete();
                    }
                break;
                case '4':
                    $type = Jelly::select('question_hotspot')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '5':
                    $type = Jelly::select('question_boolean')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '6':
                    $type = Jelly::select('question_open')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '7':
                    $type = Jelly::select('question_list')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
                case '9':
                    $type = Jelly::select('question_memory')->where('question_id', '=', $item->id)->limit(1)->execute();
                    if ($type->loaded()) {
                        $type->delete();
                    }
                break;
            }
            
            $item->delete();
            
            message::good('Pytanie zostało usunięte pomyslnie', 'admin/material_test/index/'.$test_id.'#questions');          
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('tests', 'qdelete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('question', $value);
                            if ($item->loaded()) {
                                switch ($item->type) {
                                    case '1':
                                        $type = Jelly::select('question_choice')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '2':
                                        $type = Jelly::select('question_choice')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '3':
                                        $type = Jelly::select('question_matching')->where('question_id', '=', $item->id)->execute();
                                        foreach ($type as $row) {
                                            $row->delete();
                                        }
                                    break;
                                    case '4':
                                        $type = Jelly::select('question_hotspot')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '5':
                                        $type = Jelly::select('question_boolean')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '6':
                                        $type = Jelly::select('question_open')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '7':
                                        $type = Jelly::select('question_list')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                    case '9':
                                        $type = Jelly::select('question_memory')->where('question_id', '=', $item->id)->limit(1)->execute();
                                        if ($type->loaded()) {
                                            $type->delete();
                                        }
                                    break;
                                }
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('tests', 'qedit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('question', $value);
                            if ($item->loaded()) {
                                $item->active = 1;
                                $item->save();
                            }
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('tests', 'qedit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('question', $value);
                            if ($item->loaded()) {
                                $item->active = 0;
                                $item->save();
                            }
                        }
                    }
                break;
            }

            message::good('Operacja przeprowadzona pomyślnie', 'admin/material_test/index/'.$this->request->param('id').'#questions');
        }
    }
}
