<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Pages extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('pages', 'list');
        
        $this->template->content = View::factory('smarty:admin/pages/list')
            ->bind('message', $message)
            ->bind('sections', $sections)
            ->bind('items', $tree);
        
        $message = message::get_once();
            
        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);
        $tree = $root->descendants(false, 'ASC');
    }
    
    public function action_add()
    {
        parent::$_acl->check('pages', 'add');
        
        $this->template->content = View::factory('smarty:admin/pages/add')
            ->bind('errors', $errors)
            ->bind('tree', $tree);
        
        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);
        $tree = $root->descendants(false, 'ASC');
                
        if ($_POST) {
            try {
                $page = Jelly::factory('page');
                $content = Jelly::factory('content');
                
                if (input::post('redirect_type') == 0 && input::post('module') == 'page')  {
                    $content->type = 'static';
                }
                elseif (input::post('redirect_type') == 0 && input::post('module') <> 'page') {
                    $content->type = 'module';
                    $content->data = input::post('module');
                }
                elseif (input::post('redirect_type') == 1) {
                    $content->type = 'alias';
                }
                elseif (input::post('redirect_type') == 2) {
                    $content->type = 'internal';
                    $content->data = input::post('internal_redirect');
                }
                elseif (input::post('redirect_type') == 3) {
                    $content->type = 'redirect';
                    $content->data = Url::format(input::post('external_redirect'));
                }
                
                $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
                
                if (input::post('category') == 0) {
                    $root = $page->root($current_root);
                    $page->parent_id = 0;
                    $page->insert_as_last_child($root);
                }
                else {
                    $page->parent_id = input::post('category');
                    $page->insert_as_last_child(input::post('category'));
                }
                
                
                $content->set($_POST);
                $content->template = 'layout_page';
                $content->slug = $content->mod_url(Url::prepare_url(input::post('title')));
                $content->save();
                
                $page->add('content', $content);
                $page->save();
                                
                Tracker::track(__('Dodano kategorie w strukturze strony ID: ').$page->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/pages');
            }
            catch (Validate_Exception $e) {
                $errors = $e->array->errors('shindig/crud');
            }
        }
     }

     public function action_edit()
     {
        parent::$_acl->check('pages', 'edit');
        
        $this->template->content = View::factory('smarty:admin/pages/edit')
            ->bind('errors', $errors)
            ->bind('root', $root)
            ->bind('tree', $tree)
            ->bind('page', $page)
            ->bind('content', $content);
        
        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);
        $tree = $root->descendants(false, 'ASC');
        
        $page = Jelly::select('page', $this->request->param('id'));
		$content = $page->content;
        
        if ($_POST)
        {
            try {
                if (input::post('redirect_type') == 0 && input::post('module') == 'page')  {
                    $content->type = 'static';
                }
                elseif (input::post('redirect_type') == 0 && input::post('module') <> 'page') {
                    $content->type = 'module';
                    $content->data = input::post('module');
                }
                elseif (input::post('redirect_type') == 1) {
                    $content->type = 'alias';
                }
                elseif (input::post('redirect_type') == 2) {
                    $content->type = 'internal';
                    $content->data = input::post('internal_redirect');
                }
                elseif (input::post('redirect_type') == 3) {
                    $content->type = 'redirect';
                    $content->data = Url::format(input::post('external_redirect'));
                }
                
                if ($content->title != input::post('title')) { 
                    $content->slug = $content->mod_url(Url::prepare_url(input::post('title')));
                }
                $content->set($_POST);
                $content->template = 'layout_page';
                $content->save();
                
                if ($page->parent->id != (INT)input::post('category')) {
                    $page->parent_id = input::post('category');
                    $page->move_to_first_child(input::post('category'));
                    $page->reload();
                    $page->save();
                }
                
                Tracker::track(__('Edycja kategorii w stukturze strony ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/pages');
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors('shindig/crud');
            }
        }
     }
     
     public function action_menu()
     {
        parent::$_acl->check('pages', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('page', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->content->menu = $this->request->param('stuff');
                $item->content->save();

                message::good(__('Status został zmieniony pomyślnie'), 'admin/pages');
            }
            else
            {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin/pages');
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin/pages');
        }
    }
     
     public function action_up()
     {
        parent::$_acl->check('pages', 'edit');
        
        $page = Jelly::select('page', $this->request->param('id'));
        if ($page->loaded()) 
        {
            $page->move_up();
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/pages');
        }
        else
        {
            message::error('Wystąpił błąd podczas zmiany pozycji', 'admin');
        }
     }
     
     public function action_down()
     {
        parent::$_acl->check('pages', 'edit');
        
        $page = Jelly::select('page', $this->request->param('id'));
        if ($page->loaded())
        {
            $page->move_down();
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/pages');
        }
        else
        {
            message::error('Wystąpił błąd podczas zmiany pozycji', 'admin');
        }
     }

     public function action_delete()
     {
        parent::$_acl->check('pages', 'delete');
        
        $page = Jelly::select('page', $this->request->param('id'));
        
        if ($page->loaded())
        {
            Tracker::track(__('Usunięto kategorii ze struktury strony ID: ').$page->id);
            
            $page->delete_obj();
            
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/pages');
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
     }

     public function action_checkbox()
     {
        if ($_POST)
        {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('pages', 'delete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('page', $value);
                            if ($item->loaded()) {
                                if ( ! $item->content->system)
                                {
                                    $item->delete_obj();
                                }
                            }
                        }
                    }
                break;
                case 'menu':
                    parent::$_acl->check('pages', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('page', $value);
                            if ($item->loaded())
                            {
                                $item->content->menu = 1;
                                $item->content->save();
                            }
                        }
                    }
                break;
                case 'unmenu':
                    parent::$_acl->check('pages', 'delete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('page', $value);
                            if ($item->loaded())
                            {
                                $item->content->menu = 0;
                                $item->content->save();
                            }
                        }
                    }
                break;
            }
            
            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/pages');
        }
     }
     
     public function action_repair()
     {
        $this->_repair_tree(1, 1);
        
        //message::good('Drzewko zostało naprawione', 'admin/cms/pages/index');
    }
    
    public function _repair_tree($parentNode, $left)
    {
		$right = $left+1;
        
        
        $query = DB::select()->from('pages')->where('parent_id','=',$parentNode)->execute()->as_array();
		foreach ($query as $key => $row) {
			$right = $this->_repair_tree($row['id'], $right);
		}
        
        DB::update('pages')->set(array('lft' => $left, 'rgt' => $right))->where('id','=',$parentNode)->execute();
        
		return $right+1;
    }
}
