<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Settings extends Relio_Controller_Admin {
	public function action_system()
    {
	    parent::$_acl->check('settings', 'list');
       
		$this->template->content = View::factory('smarty:admin/settings/system')
            ->bind('message', $message)
            ->bind('settings', $settings)
            ->bind('errors', $errors);
        
        $message = message::get_once();
        
        $settings = Jelly::select('setting')->execute();
        
        if ($_POST)
        {
            try {
                foreach (input::post('config') AS $key => $value) {
                    $item = Jelly::select('setting', $key);
                    $item->set(array(
                        'value' => $value
                    ))->save();
				}
                
                Cache::instance()->delete('cms_settings');
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/settings/system');
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }
    
    public function action_payment()
    {
        parent::$_acl->check('settings', 'list');
        
        $this->template->content = View::factory('smarty:admin/settings/payment')
            ->bind('message', $message)
            ->bind('errors', $errors);
        
        $message = message::get_once();
        
        if ($_POST)
        {
            try {
                foreach(input::post('config') as $key => $value) {
                    $item = Jelly::select('setting', $key);
                    $item->set(array(
                        'value' => $value
                    ))->save();
                }
                
                Cache::instance()->delete('cms_settings');
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/settings/payment');
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }
}