<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Settings_Messages extends Relio_Controller_Admin {
	public function action_index() {
		$this->template->content = View::factory('smarty:admin/settings/messages/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('current_sort', $current_sort)
            ->bind('sort', $sort);
            
        $message = message::get_once();
        
        $builder = Jelly::select('xwcontenttemplate');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'        => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'title'       => URL::query(array('sort' => 'title', 'how' => $order_direction)),
            'description' => URL::query(array('sort' => 'description', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'title':
                $builder->order_by('title', $order_how);
                $current_sort = array('type' => 'title', 'how' => $order_how);
            break;
            case 'description':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'description', 'how' => $order_how);
            break;
            default:
            break;
        }

        if (input::get('limit')) {
            $limit = input::get('limit');
        }
        else {
            $limit = 10;
        }
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }
    
    public function action_edit() {
        $this->template->content = View::factory('smarty:admin/settings/messages/edit')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('xwcontenttemplate', $this->request->param('id'));        
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('title', 'not_empty')
                ->rule('body', 'not_empty');
            
            if ($post->check()) {
                $item->title = input::post('title');
                $item->body = input::post('body');
                $item->save();
                
                Tracker::track(__('Edycja szablonu wiadomości ID: ').$item->id);
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/settings_messages'.URL::query());
            }
            else {
                $errors = $post->errors('backend/settings/messages/form');
            }
        }
    }
}