<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Ajax extends Controller {
    /**
     * Upload zalacznikow do odpowiedzi / nowego tematu
     */
    public function action_forum_upload()
    {
        if (! empty($_FILES))
        {
            $fileid    = substr(md5($_FILES['Filedata']['name']), 0, 10);
            $filename  = $_FILES['Filedata']['name'];
            $temp_name = $_FILES['Filedata']['tmp_name'];
            $error     = $_FILES['Filedata']['error'];
            $size      = $_FILES['Filedata']['size'];
            $ext       = File::getExt($filename);
            
            copy($temp_name, 'upload/modules/forum/attachments/'.$fileid.'.'.strtolower($ext));
            
            $old = umask(0);
            chmod('upload/modules/forum/attachments/'.$fileid.'.'.strtolower($ext), 0777);
            umask($old);
            
            $attachment = Jelly::factory('attachment');
            $attachment->set(array(
                'obj_id'   => '',
                'obj_type' => 'forum_post',
                'name'     => basename($filename),
                'filename' => 'upload/modules/forum/attachments/'.$fileid.'.'.strtolower($ext),
                'slug'     => $fileid,
                'type'     => 1
            ))->save();
            
            echo $attachment->id;
            exit;
        }
    }
    
    public function action_reposy_material()
    {
        $categories = Jelly::select('category')->execute();
        
        foreach($categories as $category) {
            $items = Jelly::select('material')
                ->where('category_id', '=', $category->id)
                ->order_by('posy', 'DESC')
                ->execute();

            $i = 1;
            foreach($items as $it) {
                $it->posy = $i;
                $it->save();

                $i++;
            }
        }
    }

	public function action_contact()
    {
        $content = View::factory('site/modules/contact/boxy.tpl')
            ->bind('errors', $errors)
            ->bind('details', $details)
            ->bind('captcha', $captcha)
			->bind('message', $message);
   
        $message = message::get_once('frontend');
        
        $details = Jelly::select('modules_contact_detail', 1);
        
        $captcha = Captcha::instance()->render();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('email', 'not_empty')
                ->rule('email', 'email')
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->rule('subject', 'not_empty')
                ->rule('content', 'not_empty');
            
            if ($post->check())
            {
                //echo input::post('token');
                if (Captcha::valid(input::post('captcha')))
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = Security::xss_clean(input::post('firstname'));
                    $replaceData['%lastname%'] = Security::xss_clean(input::post('lastname'));
                    $replaceData['%email%'] = Security::xss_clean(input::post('email'));
                    $replaceData['%message%'] = Security::xss_clean(input::post('content'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    xwContentTemplateWrapper::parameter_email(13, $replaceData, input::post('email'), CFG_WEBMASTER_EMAIL);
                    
					message::good(__('Wiadomość została wysłana pomyślnie'), Request::instance()->uri(), 'frontend', true);
                }
                else
                {
                    $post->error('captcha', 'wrong_token');
                }
            }
            else
            {
                $errors = $post->errors();
            }
        }
        
        echo $content->render();
        exit;
	}
	
    public function action_slides_config()
    {
        header('Content-type: text/xml');
        
        Session::instance()->delete('slideshow_'.input::get('lesson'));
        Session::instance()->delete('next_slideshow_'.input::get('lesson'));
        Session::instance()->set('firstplay_slideshow_'.input::get('lesson'), true);
        
        $output = '<?xml version="1.0" encoding="utf-8"?>';
        $output .= '<config>'."\n";
        $output .= "\t".'<basic>'."\n";
        $output .= "\t\t".'<slidesPlaylistURL>'."\n";
        $output .= "\t\t\t".URL::base('false', 'http').'ajax/slides?material='.input::get('lesson')."\n";
        $output .= "\t\t".'</slidesPlaylistURL>'."\n";
        $output .= "\t\t".'<currentSlideQueryURL>'."\n";
        $output .= "\t\t\t".URL::base('false', 'http').'ajax/slide?material='.input::get('lesson')."\n";
        $output .= "\t\t".'</currentSlideQueryURL>'."\n";
        $output .= "\t\t".'<currentSlideRefreshTime>'."\n";
        $output .= "\t\t\t".'120'."\n";
        $output .= "\t\t".'</currentSlideRefreshTime>'."\n";
        $output .= "\t\t".'<defaultTitle/>'."\n";
        $output .= "\t\t".'<defaultDuration>'."\n";
        $output .= "\t\t\t".'60'."\n";
        $output .= "\t\t".'</defaultDuration>'."\n";
        $output .= "\t\t".'<defaultTransition/>'."\n";
        $output .= "\t\t".'<autoplay>'."\n";
        $output .= "\t\t\t".'true'."\n";
        $output .= "\t\t".'</autoplay>'."\n";
        $output .= "\t\t".'<bufferTime/>'."\n";
        //$output .= "\t\t".'<logo>';
        //$output .= "\t\t\t".'';
        //$output .= "\t\t".'</logo>';
        //$output .= "\t\t".'<dblClickURL>';
        //$output .= "\t\t\t".'';
        //$output .= "\t\t".'</dblClickURL>';
        $output .= "\t".'</basic>'."\n";
        $output .= "\t".'<gui>'."\n";
        $output .= "\t\t".'<skin>'."\n";
        $output .= "\t\t\t".URL::base('false', 'http').'public/flash/slideshow_skin.swf'."\n";
        $output .= "\t\t".'</skin>'."\n";
        $output .= "\t\t".'<themeColor>'."\n";
        $output .= "\t\t\t".Kohana::config('devilcms.player.presentation.themeColor')."\n";
        $output .= "\t\t".'</themeColor>'."\n";
        $output .= "\t\t".'<fixedBarHeight>'."\n";
        $output .= "\t\t\t".'0px'."\n";
        $output .= "\t\t".'</fixedBarHeight>'."\n";
        $output .= "\t\t".'<bgColor>'."\n";
        $output .= "\t\t\t".Kohana::config('devilcms.player.presentation.bgColor')."\n";
        $output .= "\t\t".'</bgColor>'."\n";
        $output .= "\t\t".'<bgBarColor>'."\n";
        $output .= "\t\t\t".Kohana::config('devilcms.player.presentation.bgColor')."\n";
        $output .= "\t\t".'</bgBarColor>'."\n";
        $output .= "\t\t".'<fullscreenBtn>'."\n";
        $output .= "\t\t\t".'true'."\n";
        $output .= "\t\t".'</fullscreenBtn>'."\n";
        $output .= "\t".'</gui>'."\n";
        $output .= "\t".'<lang>'."\n";
        $output .= "\t\t".'<loading_data>'."\n";
        $output .= "\t\t\t".'Pobieranie danych...'."\n";
        $output .= "\t\t".'</loading_data>'."\n";
        $output .= "\t\t".'<hint_pause>'."\n";
        $output .= "\t\t\t".'Pauza'."\n";
        $output .= "\t\t".'</hint_pause>'."\n";
        $output .= "\t\t".'<hint_play>'."\n";
        $output .= "\t\t\t".'Odtwarzaj'."\n";
        $output .= "\t\t".'</hint_play>'."\n";
        $output .= "\t\t".'<hint_stop>'."\n";
        $output .= "\t\t\t".'Zatrzymaj'."\n";
        $output .= "\t\t".'</hint_stop>'."\n";
        $output .= "\t\t".'<hint_turn_on_fullscreen>'."\n";
        $output .= "\t\t\t".'Włącz pełny ekran'."\n";
        $output .= "\t\t".'</hint_turn_on_fullscreen>'."\n";
        $output .= "\t\t".'<hint_turn_off_fullscreen>'."\n";
        $output .= "\t\t\t".'Wyłącz pełny ekran'."\n";
        $output .= "\t\t".'</hint_turn_off_fullscreen>'."\n";
        $output .= "\t".'</lang>'."\n";
        $output .= '</config>';
        
        echo $output;
        
        exit;
    }
    
    public function action_slides()
    {
        header('Content-type: text/xml');
        
        $item = Jelly::select('material', input::get('material'));
        
        switch($item->type) {
            case 'lesson':
                $lesson = Jelly::select('material_lesson')->where('material_id', '=', input::get('material'))->limit(1)->execute();
                
                $files = File::directoryToArray('upload/materials/presentation/'.$lesson->presentation, false);
            break;
        }
        
        $files = Arr::stickysort( $files, 'file', 1002,  array());
        
        $output = '<?xml version="1.0" encoding="utf-8"?>'."\n";
        $output .= '<slides>'."\n";
        foreach($files as $k => $v) {
            $output .= "\t".'<item url="'.URL::base(false, 'http').$v['path'].$v['file'].'" title="" duration="" transition=""/>'."\n";
        }
        $output .= '</slides>';
        
        Session::instance()->set('slideshow_'.input::get('material'), count($files));
        Session::instance()->set('next_slideshow_'.input::get('material'), '0');
        
        echo $output;
        
        exit;
    }
    
    public function action_slide()
    {
        $item = Jelly::select('material', input::get('material'));
        
        $is_first_play = Session::instance()->get('firstplay_slideshow_'.input::get('material'));
        $total = Session::instance()->get('slideshow_'.input::get('material'));
        $next = Session::instance()->get('next_slideshow_'.input::get('material'));
        
        if ($is_first_play)
        {
            echo '1';
            
            Session::instance()->set('next_slideshow_'.input::get('material'), $next+1);
            
            Session::instance()->delete('firstplay_slideshow_'.input::get('material'));
        }
        else
        {
            if ($next == '1')
            {
                Session::instance()->set('next_slideshow_'.input::get('material'), $next+1);
                
                echo '1';
            }
            elseif ($next > $total)
            {
                Session::instance()->set('next_slideshow_'.input::get('material'), '2');
                
                echo '1';
            }
            else
            {
                echo $next;
                
                Session::instance()->set('next_slideshow_'.input::get('material'), $next+1);
            }
        }
        
        exit;
    }
    
    public function action_search_user()
    {
        $q = input::get('term');
        
        $items = Jelly::select('user')->where('id','<>',Auth::instance()->get_user()->id)->execute();
        
        $users = array();
        foreach($items as $it) {
            if ( (strpos(strtolower($it->firstname), strtolower($q)) === 0) || (strpos(strtolower($it->lastname), strtolower($q)) === 0) )
            {
                $users[] = array(
                    'id'    => $it->id,
                    'label' => $it->firstname.' '.$it->lastname,
                    'desc'  => ''
                );
            }
        }
        
        echo json_encode($users);
        exit;
    }
}
