<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Page extends Relio_Controller_Website {
    /*
    public function before() {
        parent::before();
    }
    */
    public function action_index($permalink = NULL)
    {
        /**
         * Jezeli permalink jest pusty to przekierowuje do glownej
         */
        $page = Jelly::factory('page')->permalink($permalink);
        
        if ($page->loaded())
        {
            if (!empty($page->content->template))
            {
                $this->template = View::factory('smarty:site/'.$page->content->template);
            }
            else
            {
                foreach ($page->parents() as $parent) {
                    if ($parent->lvl == 1) {
                        if (!empty($parent_content->template)) {
                            $this->template = View::factory('smarty:site/'.$parent_content->template);
                        }
                    }
                }
            }
            
            $paths = array();
            foreach ($page->path() as $path) {
                $paths[] = $path->id;
            }
            
            View::bind_global('paths', $paths);
            View::set_global('page_id', $page->id);
               
            if ($page->first_child->id)
            {
                $redirect = Jelly::select('page', $page->first_child->id);
                
                Request::instance()->redirect($redirect->uri());
            }
            
            //echo 'module/'.$page->content->data .'/'.$page->id.'/'. implode('/', $page->arguments);
            switch ($page->content->type) {
                case 'redirect':
                    Request::instance()->redirect($page->content->data);
                break;
                case 'internal':
                    $redirect = Jelly::select('page', $page->content->data);
					$redirect->content->load();
                    
                    Request::instance()->redirect($redirect->uri());
                break;
                case 'module':
                    $this->content = Request::factory('module/'.$page->content->data .'/'.$page->id.'/'. implode('/', $page->arguments))->execute()->response;
                break;
                case 'alias':
                    //
                break;
                case 'static':
                    $this->show_page($page);
                break;
                default:
                    $this->request->redirect('/');
                break;
            }
        }
        else
        {
            $this->request->redirect('/');
        }
    }

    private function show_page($page)
    {
        if (count($page->arguments) > 0)
        {
            $this->request->redirect('/');
        }
        
        $this->title = $page->content->title;
        $this->content = View::factory('smarty:site/page/content')
            ->bind('item', $content)
            ->bind('attachments', $attachments);
             
        $content = $page->content;
        
        $attachments = Jelly::select('attachment')
            ->filter($page->id, 'content')
            ->order_by('posy','ASC')
            ->execute();


        View::set_global('in_page', $content->slug);
    }
}
