<?php defined('SYSPATH') or die('No direct script access.');

class Controller_User extends Relio_Controller_Website {    
    public function action_index()
    {
        $this->request->redirect('/');
    }
    
    public function action_login()
    {
        if ($this->auth->logged_in())
        {
			$this->request->redirect('mycourses');
		}
        
        $this->template->content = View::factory('smarty:site/user/login')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('error', $error)
            ->bind('message', $message);
		
        $message = message::get_once('frontend');

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Zaloguj się'), URL::site('user/login'), true)
            ->render();
        
        if ($_POST)
        {
			$remember = isset($_POST['remember']) ? TRUE : FALSE;

			if (!$this->auth->login(Security::xss_clean($_POST['username']), Security::xss_clean($_POST['password']), $remember))
            {
				 message::error(__('Podany login i/lub hasło są błędne'), 'user/login', 'frontend');
			}

			if ($this->auth->logged_in())
            {
			    if (Session::instance()->get('auth_user')->active)
                {
			         $this->request->redirect('courses');
			    }
                else
                {
                    $this->auth->logout();
                    
                    if (CFG_MANUAL_REGISTER_ACCEPT)
                    {
                        message::error(__('Po akceptacji konta przed administratora będziesz mógł się zalogować i brać udział w szkoleniach.'), 'user/login', 'frontend');
                    }
                    else
                    {
                        message::error(__('Musisz potwierdzić założenie konta. Klikając w link w emailu'), 'user/login', 'frontend');
                    }
                }
			}
		}
    }
    
    public function action_register()
    {
        $this->request->redirect('/');
    }
    
    public function action_activate()
    {
        if ($this->auth->logged_in())
        {
			$this->request->redirect('/');
		}
        
        $user = Jelly::select('user')
            ->where(DB::expr('SHA1(email)'), '=', $this->request->param('id'))
            ->limit(1)
            ->execute();
            
        if ($user->loaded())
        {
            $user->active = 1;
            $user->save();
            
            message::good(__('Twoje konto zostało pomyślnie aktywowane możesz się teraz zalogować'), 'user/login', 'frontend');
        }
        else
        {
            message::error(__('Podany kod aktywacyjny jest błędny'), 'user/login', 'frontend');
        }
    }
    
    public function action_logout()
    {
        if ($this->auth->logged_in())
        {
			$this->auth->logout();
		}
        
		$this->request->redirect('/');
    }
    
    public function action_lostpassword()
    {
        if ($this->auth->logged_in())
        {
            $this->request->redirect('/');
        }
        
        $this->template->content = View::factory('smarty:site/user/lostpassword')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('errors', $errors)
            ->bind('message', $message);
        
        $message = message::get_once('frontend');

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Przypomij hasło'), URL::site('user/lostpassword'), true)
            ->render();     
            
        if ($_POST)
        {
            try {
                $item = Jelly::select('user')->where('email','=',input::post('email'))
                    ->limit(1)
                    ->execute();
                    
                if ($item->loaded())
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = $item->firstname;
                    $replaceData['%lastname%'] = $item->lastname;
                    $replaceData['%validation_key%'] = URL::site('user/regenerate/'.SHA1(input::post('email')), 'http');
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    xwContentTemplateWrapper::parameter_email(5, $replaceData, input::post('email'), CFG_WEBMASTER_EMAIL);
                    
                    message::good(__('Instrukcja została wysłana na podany e-mail'), 'user/lostpassword', 'frontend');
                }
                else
                {
                    message::error(__('Błędny adres e-mail'), 'user/lostpassword', 'frontend');
                }
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors('forms/user/lostpassword');
            }
        }
    }
    
    public function action_regenerate()
    {
        if ($this->auth->logged_in())
        {
            $this->request->redirect('/');
        }
        
        $item = Jelly::select('user')
            ->where('SHA1("email")', '=', $this->request->param('id'))
            ->limit(1)
            ->execute();
        
        if ($item->loaded())
        {
            $newPassword = Text::random('alnum', 8);
            
            $item->password = $newPassword;
            $item->password_confirm = $newPassword;
            $item->save();
            
            $replaceData = array();
            $replaceData['%firstname%'] = $item->firstname;
            $replaceData['%lastname%'] = $item->lastname;
            $replaceData['%password%'] = $newPassword;
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
            xwContentTemplateWrapper::parameter_email(6, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
            
            message::good(__('E-mail z nowym hasłe  został wysłany'), 'user/lostpassword', 'frontend');
        }
        else
        {
       	    message::error(__('Błędny kod autoryzacji'), 'user/lostpassword', 'frontend');
        }
    }
    
    public function action_profile()
    {
        View::set_global('in_page', 'profile');
        
        if (!$this->auth->logged_in())
        {
            $this->request->redirect('/');
        }
        
        $this->template->content = View::factory('smarty:site/user/profile')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('provinces', $provinces)
			->bind('item', $item);
            
        $this->template->title = __('Edycja profilu');
        
        $message = message::get_once('frontend');
        
        $provinces = Kohana::config('devilcms.provinces');
        
        $item = Jelly::select('user', Session::instance()->get('auth_user')->id);
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->rule('city', 'not_empty')
                ->rule('address', 'not_empty');
                
            if (input::post('password') || input::post('password_confirm'))
            {
                $post->rule('password', 'not_empty');
                $post->rule('password_confirm', 'not_empty');
                $post->rule('password_confirm', 'matches', array('password'));
            }
            
            if ($post->check())
            { 
                if (input::post('avatar_action') == '3')
                {
                    $validate = Validate::factory($_FILES);
                    $validate->rules('avatar', array(
                        'Upload::valid'     => array(),
                        'Upload::type'      => array('Upload::type' => array('jpg', 'png', 'gif')),
                        //'Upload::dimension' => array('Upload::dimension' => array('180x180')),
                        'Upload::not_empty' => array(), 
                        'Upload::size'      => array('1M')
                    ));  
                    
                    if ($validate->check())
                    {
                        $filename = Upload::save($_FILES['avatar'], null, DOCROOT . 'upload/avatars');
                    }
                    else
                    {
                        $filename = '';
                    }
                }
                elseif (input::post('avatar_action') == '1')
                {
                    $filename = input::post('tmpIcon');
                }
                elseif (input::post('avatar_action') == '2')
                {
                    @unlink('upload/avatars/' . input::post('tmpIcon'));
                        
                    $filename = '';
                }
                else
                {
                    $filename = '';
                }
                
                if (input::post('password') || input::post('password_confirm'))
                {      
                    $item->password = Security::xss_clean(input::post('password'));
                    $item->password_confirm = Security::xss_clean(input::post('password_confirm'));
                }
                
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->icon = (($filename) ? basename($filename) : '');
                $item->save();
                    
                $impersonator = $this->auth->get_user();
                    
                $this->auth->logout();
                $this->auth->force_login($impersonator->username);
                    
                message::good(__('Edycja profilu przebiegła pomyślnie'), 'user/profile', 'frontend');
            }
            else
            {
                $errors = $post->errors('frontend/users/form');
            }
        }
    }
}