<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Zadanie sluzy do zapisania uzytkownikow na wymagane szkolenia
 *
 * @author Michal Mlodzinski <mm@etendard.pl>
 */
class Minion_Task_Course_Subscriberequired extends Minion_Task {
    /**
     * An array of config options that this task can accept
     */
    protected $_config = array();
    
    /**
     * Execute
     */
    public function execute(array $config) {
        $courses = Jelly::select('course')->filter(1, null, null, null, '2')
            ->where(DB::expr('NOW()'), 'BETWEEN', DB::expr('publish_on AND archive_on'))
            ->execute();
            
        foreach($courses as $c) {
            $options = unserialize($c->options);
            
            //zapisz ze statusem oczekuje
            if ($options['required_auto_register'] == '2') { 
                if ($c->required_time) {
                    $required_complete_on = strtotime('+'.$c->required_time.' day');
                }
                else {
                    $required_complete_on = null;
                }
                
                $subscribe = Jelly::factory('course_user');
                $subscribe->user = $item->id;
                $subscribe->course = $c->id;
                $subscribe->required_complete_on = $required_complete_on;
                $subscribe->active = 2;
                $subscribe->save();
                
                $c->updateSubscribers();
            }
            
            //zapisz ze statusem w trakcie
            if ($options['required_auto_register'] == '3') {
                if ($c->required_time) {
                    $required_complete_on = strtotime('+'.$c->required_time.' day');
                }
                else {
                    $required_complete_on = null;
                }
                            
                $subscribe = Jelly::factory('course_user');
                $subscribe->user = $item->id;
                $subscribe->course = $c->id;
                $subscribe->required_complete_on = $required_complete_on;
                $subscribe->active = 1;
                $subscribe->save();
                            
                $c->updateSubscribers();
            }
            
            $replaceData = array();
            $replaceData['%firstname%'] = $user->firstname;
            $replaceData['%lastname%'] = $user->lastname;
            $replaceData['%course%'] = $item->name;
            $replaceData['%day%'] = date('d', time());
            $replaceData['%month%'] = date('m', time());
            $replaceData['%year%'] = date('Y', time());
            $replaceData['%hour%'] = date('H', time());
            $replaceData['%minute%'] = date('i', time());
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;    
            
            if ($options['required_auto_register'] == '2') {                     
                xwContentTemplateWrapper::parameter_email(9, $replaceData, $user->email, CFG_WEBMASTER_EMAIL);
            }
            
            if ($options['required_auto_register'] == '3') {
                xwContentTemplateWrapper::parameter_email(8, $replaceData, $user->email, CFG_WEBMASTER_EMAIL);
            } 
        }
    }
}