<?php

class Model_Attachment extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('id' => 'DESC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'obj_id' => Jelly::field('integer'),
            'obj_type' => Jelly::field('string'),
            'name' => Jelly::field('string'),
            'filename' => Jelly::field('string'),
            'slug' => Jelly::field('string'),
            'type' => Jelly::field('integer', array(
                'default' => 1
            ))
        ));
    }
    
    public function file_extension_icon()
    {
        $extension = File::getExt($this->filename);
        $possible_location = 'public/design/frontend/images/types/'.$extension.'.png';
        
        if ( ! is_file($possible_location))
        {
            return '/public/design/frontend/images/types/default.png';
        }
        else
        {
            return '/public/design/frontend/images/types/'.$extension.'.png';
        }
    }
    
    public function __get($field) {        
        if ($field == 'preview') {
            if (parent::__get('filename')) {
                $file = DOCROOT.parent::__get('filename');
                
                if (file_exists($file)) {
                    $ext = File::getExt(parent::__get('filename'));
                    $mime_type = File::mime(parent::__get('filename'));
                    $start = substr($mime_type, 0, strpos($mime_type, '/'));
                    switch($start) {
                        case 'application':
                            switch($mime_type) {
                                case 'application/x-diskcopy':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/disk-image.png';
                                case 'application/pdf':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-pdf.png';
                                default:
                                    if($ext) {
                                        switch($ext) {
                                            case 'psd':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-psd.png';
                                            case 'ai':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-ai.png';
                                            case 'fla':
                                            case 'flv':
                                            case 'swf':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-fla.png';
                                            case 'doc':
                                            case 'docx':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-doc.png';
                                            case 'xls':
                                            case 'xlsx':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-xls.png';
                                            case 'ppt':
                                            case 'pptx':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-ppt.png';
                                            case 'zip':
                                            case 'gz':
                                            case 'tar':
                                            case 'rar':
                                            case 'ace':
                                            case '7z':
                                            case 'sit':
                                                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/archive.png';
                                        } // switch
                                    } // if
                                    
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/blank.png';
                            } // switch
                        case 'audio':
                            return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/audio.png';
                        case 'image':
                            return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/image.png';
                        case 'text':
                            return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/text.png';
                        case 'video':
                            return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/video.png';
                        default:
                            return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/blank.png';
                   }  // if
                }
            }
        }
        
        return parent::__get($field);
    }
}