<?php
class Model_Builder_Category extends Jelly_Builder {
    public function filter($first_parent = null, $second_parent = null, $is_active = null, $term = null) {

        $query = $this->where('id','>',0);
        
        if (!is_null($first_parent) && is_numeric($first_parent)) {
            $query->where('first_parent_id','=',$first_parent);
        }
        
        if (!is_null($second_parent) && is_numeric($second_parent)) {
            $query->where('second_parent_id','=',$second_parent);
        }
        
        if (!is_null($is_active) && is_numeric($is_active)) {
            $query->where('active','=',$is_active);
        }
        
        if (!is_null($term) && !empty($term)) {
            $query->where_open()
            ->where('name','LIKE','%'.$term.'%')
            ->where_close();
        }
    
    	return $query;  	
    }
}

?>