<?php
class Model_Builder_Course_User extends Jelly_Builder {
    public function filter($user_id = null, $course_id = null, $status = null, $date_start = null, $date_end = null, $term = null, $percent = null, $closed = null) {

        $query = $this->where('courses_users.user_id','>',0);
        
        if (!is_null($user_id) && !empty($user_id)) {
            $query->where('courses_users.user_id','=',$user_id);
        }
        
        if (!is_null($course_id) && !empty($course_id)) {
            $query->where('course_id','=',$course_id);
        }
        
        if (!is_null($status) && is_numeric($status)) {
            $query->where('active','=',$status);
        }
        
        if (!is_null($date_start) && !empty($date_start)) {
            $query->where('signed_on','>=',$date_start);
        }
        
        if (!is_null($date_end) && !empty($date_end)) {
            $query->where('signed_on','<=',$date_end);
        }
        
        if (!is_null($percent) && is_array($percent) && !is_null($closed) && is_array($closed)) {
            if ($closed[0] == 'or') {
                $query->and_where_open();
            }
        }
        
        if (!is_null($percent) && is_array($percent)) {
            $query->where('percent', $percent[0], $percent[1]);
        }
        
        if (!is_null($closed) && is_array($closed)) {
            if ($closed[0] == 'and') {
                $query->where('closed', '=', $closed[1]);
            }
            elseif ($closed[0] == 'or') {
                $query->or_where('closed', '=', $closed[1]);
            }
            
        }
        
        if (!is_null($percent) && is_array($percent) && !is_null($closed) && is_array($closed)) {
            if ($closed[0] == 'or') {
                $query->and_where_close();
            }
        }
        
        if (!is_null($closed) && !is_array($closed) && is_numeric($closed)) {
            $query->where('closed', '=', $closed);
        }
        
        if (!is_null($term) && !empty($term)) {
            $query->join('users', 'LEFT')
            ->on('users.id', '=', 'courses_users.user_id')
            ->where_open()
            ->where('users.email', 'LIKE', '%'.$term.'%')
            ->or_where('users.firstname', 'LIKE', '%'.$term.'%')
            ->or_where('users.lastname', 'LIKE', '%'.$term.'%')
            ->where_close();
        }
        
    	return $query;  	
    }
    
    
}

?>