<?php
class Model_Builder_Modules_Article extends Jelly_Builder {
    public function by_page($category) {
        return $this->where('page_id','=',$category);
    }
    
    public function in_page($category) {
        return $this->where('page_id','IN',array(DB::expr($category)));
    }
    
    public function by_slug($slug) {
        return $this->where('slug','=',$slug);
    }
    
    public function filter($is_active = null, $is_home = null) {
        $query = $this->where('id','>',0);
        
        if (!is_null($is_home) && !empty($is_home)) {
            $query->where('home','=',DB::expr($is_home));
        }
        
        if (!is_null($is_active) && is_numeric($is_active)) {
            $query->where('active','=',DB::expr($is_active));
        }
        
        return $query;
    }
}

?>