<?php defined('SYSPATH') or die('No direct script access.');

class Model_Comment extends Jelly_Model {
    
	public static function initialize(Jelly_Meta $meta) {
	   $meta->fields(array(
			'id' => Jelly::field('primary'),
            'parent_id' => Jelly::field('integer', array(
                'default' => 0
            )),
			'obj_id' => Jelly::field('integer'),
            'obj_type' => Jelly::field('string'),
            'username' => Jelly::field('string'),
			'content' => Jelly::field('text'),
			'created_on' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'ip' => Jelly::field('string', array(
                'default' => $_SERVER['REMOTE_ADDR']
            )),
			'active' => Jelly::field('integer', array(
                'default' => 1
            )),
			'user' => Jelly::field('belongsto')
		));
	}
    
    public function child() {
        $child = Jelly::select('comment')->filter($this->obj_id, $this->obj_type, 1, $this->id)->execute();
        
        return $child;
    }
    
    public function child_count() {
        $child = Jelly::select('comment')->cached(10)->filter($this->obj_id, $this->obj_type, 1, $this->id)->execute()->count();
        
        return $child;
    }
}