<?php

class Model_Course_Category extends Jelly_Model_MPTT {
    public static function initialize(Jelly_Meta $meta) {
        $meta->sorting(array('lft' => 'ASC'))
            ->fields = array(
            'id' => Jelly::field('primary'),
            'parent_id' => Jelly::field('integer'),
            'name' => Jelly::field('string'),
            'active' => Jelly::field('integer', array(
                'default' => '1'
            ))
        );
        
        parent::initialize($meta);
    }
    
    public function move_up() {
        $above = Jelly::select('course_category')
            ->where('scope', '=', $this->scope)
            ->where('lvl', '=', $this->lvl)
            ->where('rgt', '=', $this->lft - 1)
            ->limit(1)
            ->execute();
                
        $this->move_to_prev_sibling($above->id);
    }
    
    public function move_down() {
        $below = Jelly::select('course_category')
            ->where('scope', '=', $this->scope)
            ->where('lvl', '=', $this->lvl)
            ->where('lft', '=', $this->rgt + 1)
            ->limit(1)
            ->execute();
        
        $this->move_to_next_sibling($below->id);
    }
}