<?php

class Model_Course_Group extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'posy' => Jelly::field('integer', array(
                'default' => 1
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
    		'course' => Jelly::field('manytomany', array(
                'foreign' => 'course',
                'through' => array(
                    'model'   => 'course_groups_courses',
                    'columns' => array('course_group_id', 'course_id')
                )
            ))
        ));
    }
    
    public function count_course() {
        $counter = Jelly::select('course')->cached(100)->filter($this->id, 1)->execute()->count();
        
        return $counter;
    }

    public function preparePosy() {
        DB::update('course_groups')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->where('id', '>', 0)
            ->execute();
    }
    
    public function positionUp() {
        $row2 = DB::select()->from('course_groups')
            ->where('posy', '<', $this->posy)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
               
        if ($row2[0]['id']) {
            DB::update('course_groups')
                ->set(array(
                    'posy' => $row2[0]['posy']
                ))
                ->where('id', '=', $this->id)
                ->execute();

            DB::update('course_groups')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
    
    public function positionDown() {
        $row2 = DB::select()->from('course_groups')
            ->where('posy', '>', $this->posy)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
                
        if ($row2[0]['id']) {
            DB::update('course_groups')
                ->set(array(
                    'posy' => $row2[0]['posy']
                ))->where('id', '=', $this->id)
                ->execute();

            DB::update('course_groups')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
}