<?php

class Model_Forum_Forum extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta)
    {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => new Field_Primary,
    		'name' => Jelly::field('string'),
            'statusicon' => new Field_String,
            'content' => Jelly::field('text'),
            'group_id' => new Field_String,
            'password' => new Field_String,
            'password_raw' => new Field_String,
            'moderator' => new Field_Integer,
            'moderated' => Jelly::field('integer', array(
                'default' => 0
            )),
            'moderated_posts' => new Field_Integer,
            'topic_emails' => new Field_Text,
            'post_emails' => new Field_Text,
            'posy' => Jelly::field('integer', array(
                'default' => 0
            )),
            'locked' => Jelly::field('integer', array(
                'default' => 0
            )),
            'post_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'active' => Jelly::field('integer', array(
                'default' => 0
            )),
            'category' => Jelly::field('belongsto', array(
                'foreign' => 'forum_category',
                'column' => 'category_id'
            )),
            'course' => Jelly::field('belongsto', array(
                'allow_null' => TRUE
            )),
            'post' => Jelly::field('belongsto', array(
                'foreign' => 'forum_post',
                'column' => 'post_id'
            ))
        ));
    }
    
    public function preparePosy($category)
    {
        DB::update('forum_forums')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->where('category_id', '=', $category)
            ->execute();
    }
    
    public function positionUp($category)
    {
        $row2 = DB::select()->from('forum_forums')
            ->where('posy', '<', $this->posy)
            ->where('category_id', '=', $category)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
               
        if (isset($row2[0]['id']))
        {
            DB::update('forum_forums')
                ->set(array(
                    'posy' => $row2[0]['posy']                    
                ))
                ->where('id', '=', $this->id)
                ->execute();
                
            DB::update('forum_forums')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
    
    public function positionDown($category)
    {
        $row2 = DB::select()->from('forum_forums')
            ->where('posy', '>', $this->posy)
            ->where('category_id', '=', $category)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
                
        if (isset($row2[0]['id']))
        {
            DB::update('forum_forums')
                ->set(array(
                    'posy' => $row2[0]['posy']
                ))
                ->where('id', '=', $this->id)
                ->execute();
                
            DB::update('forum_forums')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
    
    public function get_icon()
    {
        if (Auth::instance()->logged_in())
        {
            $user_id = Session::instance()->get('auth_user')->id;
        }
        else 
        {
            $user_id = 0;
        }
        
        $count = DB::select(DB::expr('COUNT(*) AS NewPostCount'))
            ->from('forum_topics')
            ->join('forum_topic_reads', 'LEFT')
            ->on('forum_topics.id','=','forum_topic_reads.topic_id')
            ->on('forum_topic_reads.user_id','=',DB::expr($user_id))
            ->where('forum_id','=',$this->id)
            ->where_open()
            ->where('forum_topic_reads.read_on','<',DB::expr('forum_topics.post_on'))
            //->or_where('forum_topic_reads.read_on','is_null')
            ->where_close()
            ->where('forum_topics.post_on','>',date('Y-m-d', strtotime('-2 weeks')))
            ->execute()->get('NewPostCount');
        
        $icon = "forum";
        $icon .= ($count > 0) ? "_new" : "_old";
        $icon .= ($this->status == 1) ? "_lock" : "";
        $icon .= ".png";
        
        return Forum::get_icon($icon, (($count > 0) ? 'Nowe posty' : 'Brak nowych postów'));
    }
    
    public function count_topics() {
        
        $builder = Jelly::select('forum_topic')->where('forum_id','=',$this->id);
        if (!Forum::is_mod($this->id)) {
            $builder->where('opened','=','1');
        }
        
        $topics = $builder->execute();
        
        $ids = '';
        $topic_ids = array();
        
        foreach($topics as $topic) {
            $topic_ids[] = $topic->id;
        }
        
        return count($topic_ids);  
    }
    
    public function admin_count_topics() {
        $builder = Jelly::select('forum_topic')->where('forum_id','=',$this->id);
        $topics = $builder->execute();
        
        $ids = '';
        $topic_ids = array();
        
        foreach($topics as $topic) {
            $topic_ids[] = $topic->id;
        }
        
        return count($topic_ids);
    }
    
    public function count_posts() {
        $builder = Jelly::select('forum_topic')->where('forum_id','=',$this->id);
        if (!Forum::is_mod($this->id)) {
            $builder->where('opened','=','1');
        }
        
        $topics = $builder->execute();
        
        $topic_ids = array();
        
        foreach($topics as $topic) {
            $topic_ids[] = $topic->id;
        }
        
        $sql = ' ('.implode(',', $topic_ids).') ';
        
        if (empty($topic_ids)) {
            return 0;
        }
        else {
            $count = DB::select(DB::expr('COUNT(*) AS PostCount'))
                ->from('forum_posts')
                ->where('topic_id','IN',DB::expr($sql))
                ->execute()->get('PostCount');
            
            return $count;
        }
    }
}