<?php

class Model_Forum_Topic extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta)
    {
    	$meta->sorting(array('id' => 'DESC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),            
            'notification' => Jelly::field('text'),
            'slug' => Jelly::field('string'),  
            'post_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'updated_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => TRUE
            )), 
            'created_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => FALSE
            )),    
            'views' => Jelly::field('integer', array(
                'default' => 0
            )),
            'replies' => Jelly::field('integer', array(
                'default' => 0
            )),
            'type' => Jelly::field('integer', array(
                'default' => 0
            )),
            'opened' => Jelly::field('integer', array(
                'default' => 0
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
            'user' => Jelly::field('belongsto'),
            'forum' => Jelly::field('belongsto', array(
                'foreign' => 'forum_forum',
                'column' => 'forum_id'
            )),
            'post' => Jelly::field('belongsto', array(
                'foreign' => 'forum_post',
                'column' => 'post_id'
            )),
            'icon' => Jelly::field('belongsto', array(
                'foreign' => 'forum_posticon',
                'column' => 'icon_id'
            )),
        ));
    }
}