<?php

class Model_Material_Test extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
            'questions' => Jelly::field('integer', array(
                'default' => 1
            )),
            'questions_to_pass' => Jelly::field('integer', array(
                'default' => 1
            )),
            'random_questions' => Jelly::field('integer', array(
                'default' => 1
            )),
            'total_trials' => Jelly::field('integer', array(
                'default' => 0
            )),
            'start_on' => Jelly::field('string'),
            'end_on' => Jelly::field('string'),
            'time_on' => Jelly::field('string'),
            'block_category' => Jelly::field('integer', array(
                'default' => 2
            )),
            'required_good' => Jelly::field('integer', array(
                'default' => 0
            )),
    		'material' => Jelly::field('belongsto'),
            'question' => Jelly::field('hasmany', array(
                'foreign' => 'question.test_id'
            ))
        ));
    }
    
    public function active_questions() {
        $counter = Jelly::select('question')->where('test_id', '=', $this->id)->cached(3600)->count();
        
        return $counter;
    }
    
    public function allowed_bad() {
        //return ($this->active_questions()-$this->questions_to_pass);
        return ($this->questions-$this->questions_to_pass);
    }
}