<?php defined('SYSPATH') or die('No direct script access.');

class Model_Newsletter_Message extends Jelly_Model {
	public static function initialize(Jelly_Meta $meta) {
	   $meta->sorting(array('id' => 'DESC'))
       ->fields(array(
			'id' => new Field_Primary,
			'name' => new Field_String,
            'content' => new Field_Text,
            'send_action' => new Field_Integer,
            'send_item' => new Field_Integer,
			'updated' => new Field_Text(array(
				'default' => date('Y-m-d H:i:s', time())
			)),
			'sentto' => new Field_Integer(array(
                'default' => 0
            )),
            'pergo' => new Field_Integer(array(
                'default' => 1
            )),
            'send_type' => new Field_Integer(array(
                'default' => 1
            )),
            'send_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
			'active' => new Field_Integer(array(
				'default' => 1
			)),

		));
	}
    
    public function count_address()
    {
        if ($this->send_action == 1)
        {
            $counter = DB::select(DB::expr('COUNT(DISTINCT user_id) AS mycount'))
                ->from('roles_users')
                ->where('role_id', '=', '2')                                
                ->execute()
                ->get('mycount');        
        }
        elseif ($this->send_action == 2)
        {
            $counter = DB::select(DB::expr('COUNT(DISTINCT users.id) AS mycount'))
                ->from('users')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->where('roles_users.role_id', '=', '2')
                ->where('users.active', '=', '1')                
                ->execute()
                ->get('mycount');
        }
        elseif ($this->send_action == 3)
        {
            $counter = DB::select(DB::expr('COUNT(DISTINCT users.id) AS mycount'))
                ->from('users')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->where('roles_users.role_id', '=', '2')
                ->where('users.active', '=', '0')
                ->execute()
                ->get('mycount');
        }
        elseif ($this->send_action == 4)
        {
            $counter = Jelly::select('course_user')->filter(null, $this->course)->count();
        }
        elseif ($this->send_action == 5)
        {
            $counter = 1;
        }
        elseif ($this->send_action == 6)
        {
            $counter = DB::select(DB::expr('COUNT(DISTINCT users.id) AS mycount'))
                ->from('users')
                ->join('user_groups_users', 'LEFT')
                ->on('users.id', '=', DB::expr('user_groups_users.user_id'))
                ->where('user_groups_users.user_group_id', '=', $this->send_item)
                ->execute()
                ->get('mycount');
        }
        
        return $counter;
    }
}