<?php

class Model_Question extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('text'),
            'hide_time' => Jelly::field('integer', array(
                'default' => 0
            )),
            'one_is_good' => Jelly::field('integer', array(
                'default' => 0
            )),
            'feedback_good' => Jelly::field('text', array(
                'default' => 'Gratulujemy, odpowiedź prawidłowa'
            )),
            'feedback_wrong' => Jelly::field('text', array(
                'default' => 'Przykro nam. Spróbuj jeszcze raz'
            )),
            'help' => Jelly::field('text'),
            'icon' => Jelly::field('string'),
            'movie' => Jelly::field('string'),
            'movie_duration' => Jelly::field('string'),
            'type' => Jelly::field('integer'),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
            'test' => Jelly::field('belongsto', array(
                'foreign' => 'material_test.id',
                'column' => 'test_id'
            )),
        ));
    }
    
    public function is_audio()
    {       
        $file = $this->movie;
        
        if (file_exists($file))
        {
            $ext = File::getExt($file);
            $mime_type = File::mime($file);
            
            $start = substr($mime_type, 0, strpos($mime_type, '/'));
            
            switch($start) {
                case 'audio':
                    return TRUE;
                break;
                default:
                    return FALSE;
                break;
            }
        }           
    }
}