<?php

class Model_Report_Test extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
            'score_percent' => Jelly::field('float'),
            'pass_percent' => Jelly::field('float'),
            'pass_question' => Jelly::field('integer'),
            'good' => Jelly::field('integer'),
            'bad' => Jelly::field('integer'),
            'start_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'end_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'created_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => FALSE
            )),
            'duration' => Jelly::field('integer'),
            'status' => Jelly::field('integer', array(
                'default' => 0
            )),
            'material' => Jelly::field('belongsto'),
            'user' => Jelly::field('belongsto'),
            'max_score' => new Field_Float(array(
                'in_db' => false
            )),
            'min_score' => new Field_Float(array(
                'in_db' => false
            )),
            'avg_score' => new Field_Float(array(
                'in_db' => false
            )),
            'max_time' => new Field_Float(array(
                'in_db' => false
            )),
            'min_time' => new Field_Float(array(
                'in_db' => false
            )),
            'avg_time' => new Field_Float(array(
                'in_db' => false
            )),
        ));
    }
}