<?php

class MyAcl extends Acl {
    private $_db;  
    
    public $_getUserRoleName = null;  
    public $_getUserRoleId = null;  
    public $_user = null;  
 
    public function __construct($user) {  
        $this->_user = $user ? $user : 'Guest';  
        
        self::roleResource();
                    
        $getUserRole = DB::select(array('r.id','role_id'), array('r.name', 'role_name'))
                ->from(array('roles_users', 'ru'))
                ->join(array('roles', 'r'), 'LEFT')
                ->on('ru.role_id', '=', DB::expr('r.id'))
				->where('ru.user_id','=',DB::expr($this->_user))
                ->where('ru.role_id','<>',1)
                ->execute()->as_array();
              
        $this->_getUserRoleId = $getUserRole[0]['role_id'] ? $getUserRole[0]['role_id'] : 1;  
        $this->_getUserRoleName = $getUserRole[0]['role_name'] ? $getUserRole[0]['role_name'] : 'User';  
        
        $this->add_role($this->_user, $this->_getUserRoleName);  
 
    }
 
    private function initRoles() {
        $roles = DB::select()->from('roles')->execute()->as_array();
        
        //$this->add_role($roles[0]['name']);  
 
        for ($i = 1; $i < count($roles); $i++) {
            $this->add_role($roles[$i]['name']);  
        }  
    }  
 
    private function initResources() {  
        self::initRoles();  
        
        $resources = DB::select()->from('acl_resources')->execute()->as_array();
 
        foreach ($resources as $key => $value){  
            if (!$this->has_resource($value['resource'])) {  
                $this->add_resource($value['resource']);  
            }  
        }
    }
 
    private function roleResource() {  
        self::initResources();  
         
        $acl = DB::select(array('r.name','role_name'), 'ar.resource', 'ap.permission')
            ->from(array('roles', 'r'))
            ->join(array('acl_permissions', 'ap'), 'LEFT')
            ->on('r.id','=',DB::expr('ap.role_id'))
            ->join(array('acl_resources', 'ar'), 'LEFT')
            ->on('ar.id','=',DB::expr('ap.resource_id'))
            ->execute()->as_array();
            
        foreach ($acl as $key => $value) {  
            $this->allow($value['role_name'], $value['resource'], $value['permission']);  
        }  
    } 
    
    public function addPermission($role, $resource, $permission) {
        DB::insert('acl_permissions', array('role_id','resource_id','permission'))
            ->values(array($role, $resource, $permission))
            ->execute();
    }
    
    public function clearPermissionByGroup($role) {
        DB::delete('acl_permissions')
            ->where('role_id','=',$role)
            ->execute();
    }
 
    public function listRoles() {  
        $roles = DB::select()->from('roles')->execute()->as_array();
        
        return $roles;
    }
    
    public function listResources() {
        $resources = DB::select()->from(array('acl_resources', 'ar'), array('acl_permissions', 'ap'))
            ->where('ap.resource_id','=',DB::expr('ar.id'))
            ->execute()->as_array();
        
        return $resources;
    }
    
    public function listAllResources() {
        $resources = DB::select()->from('acl_resources')->execute()->as_array();
        
        return $resources;
    }
    
    public function listResourcesWithActions() {
        $resources = DB::select()->from('acl_resources')->order_by('id', 'ASC')->execute()->as_array();
        
        foreach($resources as $k => $row) {
    		$resources[$k]['actions'] = $this->listActionsByResource($row['id']);
		}
        
        return $resources;
    }
    
    public function listActionsByResource($group) {
        $actions = DB::select()->from('acl_resource_actions')->where('resource_id','=',$group)->execute()->as_array();
        
        return $actions;
    }
 
    public function listResourcesByGroup($group) {  
        $result = null;
        $group = DB::select()
            ->from(array('acl_resources', 'ar'))
            ->join(array('acl_permissions', 'ap'), 'LEFT')
            ->on('ap.resource_id','=',DB::expr('ar.id'))
            ->where('ap.role_id','=', $group)
            ->execute()->as_array();
             
 
        return $group;  
    }  
 
    public function isUserAllowed($resource, $permission) {  
        return ($this->is_allowed($this->_user, $resource, $permission));  
    }
    
    public function check($resource, $permission) {
		if ($user = Auth::instance()->get_user()) {
			if ($this->is_allowed($this->_user, $resource, $permission) === true) {
	            return true;
			}
            else {
                throw new ACL_Exception_403;
            }
		}
		else {
			throw new ACL_Exception_401;
		}
	}
}