<?php defined('SYSPATH') or die('No direct script access.');

class Relio_Lms {
    public static function get_online_array() {
        $logged_in = array(); 
        $sessions = DB::select()->from('sessions')->execute()->as_array();
        foreach($sessions as $key => $row) {
            //$aRow = unserialize(base64_decode($row['contents']));
            
            if (isset($aRow['auth_user'])) {
             //   $logged_in[$aRow['auth_user']->id] = $aRow['auth_user']->id;
            }
        }
        
        return $logged_in;
    }
    
    public static function time_on_hour($string) {
        if (!empty($string) && !is_null($string)) {
            $timer = '';
            $dni = floor($string/86400);
            
            $godzin = floor(($string-($dni*86400))/3600);
            $timer.= $godzin;            
            
            return $timer;
        }
        else {
            return '0';
        }
    }
    
    public static function time_on($string) {
        if (!empty($string) && !is_null($string)) {
            $timer = '';
            $dni = floor($string/86400);
            if($dni > 0) {
                $timer = $dni.' '.Text::odmiana($dni, 'dzień', 'dni', 'dni').' ';
            }
            
            $godzin = floor(($string-($dni*86400))/3600);
            $timer.= $godzin.' godz ';
            
            $minut = floor(($string-($dni*86400)-($godzin*3600))/60);
            $timer.= $minut.' min';
            
            return $timer;
        }
        else {
            return '0 godz 0 min';
        }
    }
    
    public static function subscribe_compare_groups(Model_Course $item, $user_id) {
        $checked_user_groups = array();
        foreach($item->user_group as $row) {
            $checked_user_groups[] = $row->id;
        }
        //jezeli z relacji nic nie wyszlo to ustawiamy ze kazda grupa ma dostep
        if (empty($checked_user_groups)) {
            return true;
        }
        
        $selected_groups = array();
        $item = Jelly::select('user', $user_id);
        foreach($item->user_groups as $ug) {
            $selected_groups[] = $ug->id;
        }
        
        $diff = array_diff($selected_groups, $checked_user_groups);
        if (count($diff) < 1) {
            return true;
        }

        return false;
    }
    
    public static function get_course_pager($course, $subscribe) {
        $kategorie = array();
		$materialy = array();
		$blocked = 0; 
		$status = 1;
        
        $passed = array();
        $materials_passed = Jelly::select('material_stat')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('course_id', '=', $course->id)
            ->where('material_id', '>', 0)
            ->where('status', '=', 1)
            ->execute();
            
        foreach($materials_passed as $mp) {
            $passed[$mp->material->id] = $mp->status;
        }
        
        if (input::get('module')) {
            $row = Jelly::select('category', input::get('module'));
        }
        else {
            $row = Jelly::select('category')
                ->filter($course->category->id, 0)
                ->limit(1)
                ->cached(3600)
                ->execute();
        }

        //$categories = Jelly::select('category')->filter($course->category->id, 0)->cached(3600)->execute();
        //foreach($categories as $row) {
            $kategoria['tytul'] = $row->name;
            $kategoria['id_kategoria'] = $row->id;
            $kategoria['id'] = $row->id;
                        
            foreach($row->material as $row1) {
                $materials['id_kategoria'] = $row->id;
                $materials['id'] = $row1->id;
                $materials['tytul'] = $row1->name;
                                
                if ($blocked == 0) {
                    $materials['blokada'] = 0;
                    $materials['link'] = 'course/index/'.$course->id.'/'.$row1->id;
                }
                else {
                    $materials['blokada'] = 1;
                    $materials['link'] = 'javascript:;';
                }
                $materials['type'] = $row1->type;
                
                if (isset($passed[$row1->id])) {
                    $materials['status'] = 1;
                }
                else {
                    $materials['status'] = 0;
                }
                $materials['has_image'] = ($row1->icon) ? true : false;
                $materials['has_movie'] = ($row1->movie) ? true : false;
                $materials['has_presentation'] = ($row1->presentation) ? true : false;
                
				if ($row1->type == 'test' || $row1->type == 'exercise') {
					$test = Jelly::select('material_test')->by_material($row1->id)->limit(1)->cached(3600)->execute();
					if ($test->loaded()) {
					    $questions = Jelly::select('question')->where('test_id', '=', $test->id)->cached(3600)->execute();
						if ($questions->count()) {
                            $materials['ilosc_pytan'] = $questions->count();
    						$materials['rodzaj'] = $test->type;
    						$materials['czas'] = $test->time_on;
    						$materials['prob'] = $test->total_trials;
                            
                            if (isset($passed[$row1->id])) {
                                $materials['status_raw'] = Kohana::$config->load('cms.test.status.1');
    						}
                            else {
                                $materials['status_raw'] = Kohana::$config->load('cms.test.status.0');
                            }
                            
                            if ($test->block_category) {
                                if (isset($passed[$row1->id])) {
                                    $blocked = 0;
                                }
                                else {
                                    $blocked = 1;
                                }
                            }
						}
						else {
							unset($materials);
						}
					}
                    else {
                        unset($materials);
                    }
				}
                
                $materialy[] = $materials;
                
                $la++;
            }
            
			$kategoria['blokada'] = $blocked;
						
			$kategorie[] = $kategoria;
		//}
      
         /**
         * Paginacja - czesc 1
         */
        $newPager = array();
        foreach ($kategorie as $k => $ids) {
            foreach ($materialy as $m => $id) {
                if ($ids['id_kategoria'] == $id['id_kategoria']) {
                    switch ($id['type']) {
                        case 'lesson':
                            $newPager[] = array(
                                'id'      => $id['id'],
                                'module'  => $id['id_kategoria'],
                                'blokada' => $id['blokada'],
                                'link'    => $id['link'],
                                'tytul'   => $id['tytul'],
                                'status'  => $id['status']);
                        break;
                        case 'videosync':
                            $newPager[] = array(
                                'id'      => $id['id'],
                                'module'  => $id['id_kategoria'],
                                'blokada' => $id['blokada'],
                                'link'    => $id['link'],
                                'tytul'   => $id['tytul'],
                                'status'  => $id['status']);
                        break;
                        case 'scorm':
                            $newPager[] = array(
                                'id'      => $id['id'],
                                'module'  => $id['id_kategoria'],
                                'blokada' => $id['blokada'],
                                'link'    => $id['link'],
                                'tytul'   => $id['tytul'],
                                'status'  => $id['status']
                            );
                        break;
                        case 'test':
                            $newPager[] = array(
                                'id'      => $id['id'],
                                'module'  => $id['id_kategoria'],
                                'blokada' => $id['blokada'],
                                'test'    => '1',
                                'link'    => $id['link'],
                                'pytan'   => $id['ilosc_pytan'],
                                'czas'    => $id['czas'],
                                'prob'    => $id['prob'],
                                'rodzaj'  => $id['rodzaj'],
                                'status'  => $id['status'],
                                'tytul'   => $id['tytul']
                            );
                        break;
                        case 'exercise':
                            $newPager[] = array(
                                'id'      => $id['id'],
                                'module'  => $id['id_kategoria'],
                                'blokada' => $id['blokada'],
                                'link'    => $id['link'],
                                'tytul'   => $id['tytul'],
                                'status'  => $id['status']
                            );
                        break;
                    }
                }
            }
        }
        
        //print_r($newPager);
        $kk = 1;
        $znewPage = array();
        for ($k = 0; $k < count($newPager); $k++) {
            if (isset($newPager[$k]['test']) && $newPager[$k]['test'] == '1') {
                $znewPager[($k+1)] = array(
                    'pager'   => $kk,
                    'test'    => '1',
                    'id'      => $newPager[$k]['id'],
                    'module'  => $newPager[$k]['module'],
                    'link'    => $newPager[$k]['link'],
                    'tytul'   => $newPager[$k]['tytul'],
                    'pytan'   => $newPager[$k]['pytan'],
                    'czas'    => $newPager[$k]['czas'],
                    'prob'    => $newPager[$k]['prob'],
                    'rodzaj'  => $newPager[$k]['rodzaj'],
                    'status'  => $newPager[$k]['status'],
                    'blokada' => $newPager[$k]['blokada'],
                );

                $kk++;
            }
            else {
                $znewPager[($k+1)] = array(
                    'pager'   => $kk,
                    'id'      => $newPager[$k]['id'],
                    'module'  => $newPager[$k]['module'],
                    'blokada' => $newPager[$k]['blokada'],
                    'link'    => $newPager[$k]['link'],
                    'tytul'   => $newPager[$k]['tytul'],
                    'status'  => $newPager[$k]['status']
                );

                $kk++;
            }
        }
        
        $jj = 1;
        $znewPagerMaterial = array();
        for ($k = 0; $k < count($newPager); $k++) {
            if (isset($newPager[$k]['test']) && $newPager[$k]['test'] == '1') {
                $znewPagerMaterial[$newPager[$k]['id']] = array(
                    'pager'   => $jj,
                    'test'    => '1',
                    'id'      => $newPager[$k]['id'],
                    'module'  => $newPager[$k]['module'],
                    'link'    => $newPager[$k]['link'],
                    'tytul'   => $newPager[$k]['tytul'],
                    'pytan'   => $newPager[$k]['pytan'],
                    'czas'    => $newPager[$k]['czas'],
                    'prob'    => $newPager[$k]['prob'],
                    'rodzaj'  => $newPager[$k]['rodzaj'],
                    'status'  => $newPager[$k]['status'],
                    'blokada' => $newPager[$k]['blokada'],
                );

                $jj++;
            }
            else {
                $znewPagerMaterial[$newPager[$k]['id']] = array(
                    'pager'   => $jj,
                    'id'      => $newPager[$k]['id'],
                    'module'  => $newPager[$k]['module'],
                    'blokada' => $newPager[$k]['blokada'],
                    'link'    => $newPager[$k]['link'],
                    'tytul'   => $newPager[$k]['tytul'],
                    'status'  => $newPager[$k]['status']
                );

                $jj++;
            }
        }

        //print_r($znewPager);

        Session::instance()->set('znewPager', serialize($znewPager));
        Session::instance()->set('znewPagerMaterial', serialize($znewPagerMaterial));
		
        /**
        * Paginacja
        */
        if (!input::get('page')) {
            $current_page = 0;
        }
        else {
            $current_page = (int)input::get('page');
        }

        $total_pages = count($znewPager);

        // Number of page links in the begin and end of whole range
        $count_out = 3;

        // Number of page links on each side of current page
        $count_in = 19;

        // Beginning group of pages: $n1...$n2
        $n1 = 1;
        $n2 = min($count_out, $total_pages);

        // Ending group of pages: $n7...$n8
        $n7 = max(1, $total_pages - $count_out + 1);
        $n8 = $total_pages;

        // Middle group of pages: $n4...$n5
        $n4 = max($n2 + 1, $current_page - $count_in);
        $n5 = min($n7 - 1, $current_page + $count_in);
        $use_middle = ($n5 >= $n4);

        // Point $n3 between $n2 and $n4
        $n3 = (int) (($n2 + $n4) / 2);
        $use_n3 = ($use_middle && (($n4 - $n2) > 1));

        // Point $n6 between $n5 and $n7
        $n6 = (int) (($n5 + $n7) / 2);
        $use_n6 = ($use_middle && (($n7 - $n5) > 1));

        // Links to display as array(page => content)
        $links = array();

        // Generate links data in accordance with calculated numbers
        for ($i = $n1; $i <= $n2; $i++) {
            $links[$i] = $i;
        }

        if ($use_n3) {
            $links[$n3] = '&hellip;';
        }

        for ($i = $n4; $i <= $n5; $i++) {
            $links[$i] = $i;
        }

        if ($use_n6) {
            $links[$n6] = '&hellip;';
        }

        for ($i = $n7; $i <= $n8; $i++) {
            $links[$i] = $i;
        }
		
        $new_pager = '';

        foreach ($links as $number => $content) {
            if (isset($znewPager[$number]['test']))
            {
                $content = 'T';
            }
            
            if ($number === $current_page) {
                if ($znewPager[$number]['status']) {
                    $new_pager .= '<li><a href="'.$znewPager[$number]['link'].'?module='.$znewPager[$number]['module'].'&page='.$number.'&lesson='.$znewPager[$number]['pager'].'" onclick="jPager(this.href, \'#ajax_course_content\'); return false;"  title="'.$content.'" class="active passed">'.$content.'</a></li>';
                }
                else {
                    $new_pager .= '<li><a href="'.$znewPager[$number]['link'].'?module='.$znewPager[$number]['module'].'&page='.$number.'&lesson='.$znewPager[$number]['pager'].'" onclick="jPager(this.href, \'#ajax_course_content\'); return false;" title="'.$content.'" class="active">'.$content.'</a></li>';
                }
            }
            else {
                if ($znewPager[$number]['blokada']) {
                    $new_pager .= '<li><a href="javascript:void(0);" onclick="javascript:display_alert(\'Musisz zaliczyć wcześniejsze lekcje aby przejść do tego materiału\', \'UWAGA\');">'.$content.'</a></li>';
                }
                else {
                    if ($znewPager[$number]['status']) {
                        $new_pager .= '<li><a href="'.$znewPager[$number]['link'].'?module='.$znewPager[$number]['module'].'&page='.$number.'&lesson='.$znewPager[$number]['pager'].'" onclick="jPager(this.href, \'#ajax_course_content\'); return false;" title="'.$content.'" class="passed">'.$content.'</a></li>';
                    }
                    else {
                        $new_pager .= '<li><a href="'.$znewPager[$number]['link'].'?module='.$znewPager[$number]['module'].'&page='.$number.'&lesson='.$znewPager[$number]['pager'].'" onclick="jPager(this.href, \'#ajax_course_content\'); return false;" title="'.$content.'">'.$content.'</a></li>';
                    }
                }
            }
        }

		//$prev_page   = ($current_page > 1) ? (($current_page-1)-1) : FALSE;
		//$next_page   = ($current_page < $total_pages) ? $current_page : FALSE;	
        $prev_page = ($current_page > 1) ? $current_page - 1 : FALSE;
        $next_page     = ($current_page < $total_pages) ? $current_page + 1 : FALSE;	
		
        $pager_prev_page = (isset($znewPager[$prev_page])) ? $znewPager[$prev_page] : '';
        $pager_next_page = ($next_page) ? $znewPager[$next_page] : '';
        
        return array($new_pager, $pager_prev_page, $pager_next_page, $current_page);
    }
}