<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'pclzip/pcltrace.lib');
require_once Kohana::find_file('vendor', 'pclzip/pclzip-trace.lib');

class Relio_Scorm {
    private static $_instance;
    
    public static function instance() {
		if (self::$_instance === NULL) {
			self::$_instance = new self;
		}

		return self::$_instance;
	}
    
    public function delete($scorm_id) {
        $scn_r_cid = Jelly::select('scorm', $scorm_id);
        
        if ($scn_r_cid->loaded()) {
            $scn_cid = array();
            foreach ($scn_r_cid as $irc) {
                $scn_cid[] = $irc->id;
                $sc_cid[] = $irc->scorm_package;
            }
            
            if (count ($scn_cid)) {
                $scn_cids = implode (',', $scn_cid);
                
                DB::delete('jos_lms_n_scorm')->where('id', 'IN', array($scn_cids))->execute();
                
                $objDB->select("SELECT id FROM jos_lms_n_scorm_scoes WHERE scorm IN ('$scn_cids')");
            	$scoes_ids = $objDB->LoadResultArray();
                
                if (count($scoes_ids)) {
                    DB::delete('jos_lms_n_scorm_scoes')->where('scorm', 'IN', array($scn_cids))->execute();
            		            		
            		$sco_cids = implode (',', $scoes_ids);
                    
                    DB::delete('jos_lms_n_scorm_scoes_data')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_scoes_track')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_seq_mapinfo')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_seq_objective')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_seq_rolluprulecond')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_seq_rulecond')->where('scoid', 'IN', array($sco_cids))->execute();
                    DB::delete('jos_lms_n_scorm_seq_ruleconds')->where('scoid', 'IN', array($sco_cids))->execute();
                }
            }
        }
        
        if (count ($sc_cid)) {
            $sc_cids = implode (',', $sc_cid);
            
            $del_scorms = Jelly::select('scorm_package')->where('id', 'IN', array($sc_cids))->execute();
         	
             if (count ($del_scorms)) {
                $scorm_ids = array();
         		
         		$scorm_folder = DOCROOT.'upload/material/scorm/';
                
         		foreach ($del_scorms as $del_scorm) {
         			self::deldir($scorm_folder . $del_scorm->folder_srv_name . '/');
         			unlink($scorm_folder . $del_scorm->package_srv_name);
                    
         			$scorm_ids[] = $del_scorm->id;
     			}
     			
     			$sc_cids = implode (',', $scorm_ids);
                
                DB::delete('jos_lms_scorm_packages')->where('id', 'IN', array($sc_cids))->execute();
                DB::delete('jos_lms_scorm_sco')->where('content_id', 'IN', array($sc_cids))->execute();
 			}
        }
    }
    
    public function upload($filename) {
        $fold_unique_name = str_pad(Auth::instance()->get_user()->id, 4, '0', STR_PAD_LEFT).'_'.md5 (uniqid(rand(), true));
        
        $file_unique_name = $fold_unique_name.'.'.substr(basename($filename), 0 - 3);
        $uploadPath = DOCROOT.'upload/materials/scorm/'.$fold_unique_name;
        
    	$zipFile = new PclZip($filename);
    	$zipContentArray = $zipFile->listContent();
    	$okScorm = false;
    	$okPlantynScorm1 = false;
    	$okPlantynScorm2 = false;
    	$okPlantynScorm3 = false;
    	$okAiccScorm = false;
    	$realFileSize = 0;
    	
    	foreach ($zipContentArray as $thisContent) {
    		if (preg_match ('~.(php.*|phtml)$~i', $thisContent['filename'])) {
    			//Blad pakietu SCORM
			}
			else {
				if (stristr ($thisContent['filename'], 'imsmanifest.xml')) {
					$okScorm = true;
				}
				else {
					if (stristr ($thisContent['filename'], 'LMS')) {
						$okPlantynScorm1 = true;
					} 
					else {
						if (stristr ($thisContent['filename'], 'REF')) {
							$okPlantynScorm2 = true;
						}
						else {
							if (stristr ($thisContent['filename'], 'SCO')) {
								$okPlantynScorm3 = true;
							}
							else {
								if (stristr ($thisContent['filename'], 'AICC')) {
									$okAiccScorm = true;
								}
							}
						}
					}
				}
			}
			
			$realFileSize += $thisContent['size'];
		}
		
		if (((($okPlantynScorm1 == true AND $okPlantynScorm2 == true) AND $okPlantynScorm3 == true) OR $okAiccScorm == true)) {
			$okScorm = true;
		}
		
		if (!$okScorm) {
			//Plik SCORM jest bledny
		}
		
		if (!mkdir ($uploadPath, 493)) {
			//Blad tworzenia folderu
		}
		
		if ($uploadPath[strlen ($uploadPath) - 1] == '/') {
			$uploadPath = substr ($uploadPath, 0, 0 - 1);
		}
		
        $zipFile->extract($uploadPath);
		
		if ($dir = @opendir ($uploadPath)) {
			while ($file = readdir ($dir)) {
				if (($file != '.' AND $file != '..')) {
					$filetype = 'file';
					if (is_dir ($uploadPath . '/' . $file)) {
						$filetype = 'folder';
					}
					
					//$safe_file = replace_dangerous_char ($file, 'strict');
					$safe_file = $file;
					@rename ($uploadPath . '/' . $file, $uploadPath . '/' . $safe_file);
					if ($filetype == 'file') {
						@chmod ($uploadPath . '/' . $safe_file, 420);
						continue;
					}
					else {
						if ($filetype = 'folder') {
							@chmod ($uploadPath . '/' . $safe_file, 493);
							continue;
						}
						continue;
					}
					continue;
				}
			}
			
			closedir ($dir);
		}
        
        $package = Jelly::factory('scorm_package');
        $package->owner_id = Auth::instance()->get_user()->id;
        $package->course_id = 0;
        $package->folder_srv_name = $fold_unique_name;
        //$package->package_srv_name = $file_unique_name;
        $package->package_srv_name = $filename;
        $package->package_user_name = $filename;
        $package->upload_time = date('Y-m-d H:i:s', time());
        $package->save();
        
        return $package->id;
    }
    
    public function deldir( $dir ) {
		$current_dir = opendir( $dir );
		$old_umask = umask(0);
		while ($entryname = readdir( $current_dir )) {
			if ($entryname != '.' and $entryname != '..') {
				if (is_dir( $dir . $entryname )) {
					self::deldir( self::mosPathName( $dir . $entryname ) );
				} else {
	                @chmod($dir . $entryname, 0777);
					unlink( $dir . $entryname );
				}
			}
		}
		umask($old_umask);
		closedir( $current_dir );
		return rmdir( $dir );
	}
    
    public function mosPathName($p_path,$p_addtrailingslash = true) {
    	$retval = "";
    
    	$isWin = (substr(PHP_OS, 0, 3) == 'WIN');
    
    	if ($isWin)	{
    		$retval = str_replace( '/', '\\', $p_path );
    		if ($p_addtrailingslash) {
    			if (substr( $retval, -1 ) != '\\') {
    				$retval .= '\\';
    			}
    		}
    
    		// Check if UNC path
    		$unc = substr($retval,0,2) == '\\\\' ? 1 : 0;
    
    		// Remove double \\
    		$retval = str_replace( '\\\\', '\\', $retval );
    
    		// If UNC path, we have to add one \ in front or everything breaks!
    		if ( $unc == 1 ) {
    			$retval = '\\'.$retval;
    		}
    	} else {
    		$retval = str_replace( '\\', '/', $p_path );
    		if ($p_addtrailingslash) {
    			if (substr( $retval, -1 ) != '/') {
    				$retval .= '/';
    			}
    		}
    
    		// Check if UNC path
    		$unc = substr($retval,0,2) == '//' ? 1 : 0;
    
    		// Remove double //
    		$retval = str_replace('//','/',$retval);
    
    		// If UNC path, we have to add one / in front or everything breaks!
    		if ( $unc == 1 ) {
    			$retval = '/'.$retval;
    		}
    	}
    
    	return $retval;
    }
}