<?php defined('SYSPATH') or die('No direct script access.');
 
class Text extends Kohana_Text {
     
     public static function odmiana($liczba, $jeden, $dwa, $siedem) {
          $liczba = trim($liczba);
          $sl = (int)substr('0' . $liczba, -2);
          
          if ($sl == 1 && $liczba != '0') {
               return $jeden;
          }
          
          if ($sl > 1 && $sl < 5) {
               return $dwa;
          }
          
          if ($sl > 21) {
               $sll = (int)substr($liczba, -1);
               if ($sll > 0 && $sll < 5) {
                    return $dwa;
               }
          }
        
        return $siedem;
     }
     
     public static function clean_name($title, $separator = '-', $ascii_only = false) {
        
        if ($ascii_only === true) {
            // Transliterate non-ASCII characters
            $title = UTF8::transliterate_to_ascii($title);

            // Remove all characters that are not the separator, a-z, 0-9, or whitespace
            $title = preg_replace('![^' . preg_quote($separator) . 'a-z0-9\s]+!', '', strtolower($title));
        }
        else {
            // Remove all characters that are not the separator, letters, numbers, or whitespace
            $title = preg_replace('![^' . preg_quote($separator) . '\pL\pN\s]+!u', '', UTF8::strtolower($title));
        }

        // Replace all separator characters and whitespace by a single separator
        $title = preg_replace('![' . preg_quote($separator) . '\s]+!u', $separator, $title);

        $search = array('ć', 'ś', 'ą', 'ż', 'ó', 'ł', 'ś', 'ź', 'ń', 'ę');
        $replace = array('c', 's', 'a', 'z', 'o', 'l', 's', 'z', 'n', 'e');

        $title = str_replace($search, $replace, $title);

        // Trim separators from the beginning and end
        return trim($title, $separator);
    }
}