<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Exercise extends Relio_Controller_Website {        
    public function action_start($course_id, $material_id) {
        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
        $test = Jelly::select('material_test')->by_material($material->id)->limit(1)->execute();
        $subscribe = Jelly::select('course_user')->filter(Session::instance()->get('auth_user')->id, $course->id)->limit(1)->cached(3600)->execute();
        
        //opcje szkolenia
        $course_options = unserialize($course->options);
        
        //pobierz paginacje
        list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
        
        //pobierz moderatorow
        $moderators = Jelly::select('course_moderator')->where('course_id','=',$course->id)->cached(3600)->execute();
        
        $time_end = mktime(date('G'), date('i')+$test->time_on, date('s'), date('m'), date('d'), date('Y'));
        $time_left = mktime(date('G'), date('i'), date('s'), date('m'), date('d'), date('Y'));
       
        $to_time   = strtotime(date('Y-m-d H:i:s', $time_end));
        $from_time = strtotime(date('Y-m-d H:i:s', $time_left));
        $date_diff_array = Date::datediff($from_time, $to_time);
        
        $minutes = ($date_diff_array['hours']*60)+$date_diff_array['minutes'];
        $seconds = $date_diff_array['seconds']+1;
        
        Session::instance()->set('test', array(
            'current'   => 1,
            'good'      => 0,
            'bad'       => 0,
            'limit'     => $test->questions,
            'questions' => array(),
            'test'      => $test,
            'status'    => ((!$stat->status) ? 0 : $stat->status),
            'trials'    => $stat->total_trials,
            'end'       => $time_end,
            'minutes'   => $minutes,
            'seconds'   => $seconds
        )); 
               
        $quiz = new Quiz($test->id, $course_id, $material_id);
        $quiz->quiz_gen_uid();
        $quiz->quiz_new_start();
        $q_data = $quiz->quiz_get_questionlist();
        
        $total_questions = count($q_data);
        
		$session_test = Session::instance()->get('test');
        
        if ($total_questions > 0) {
            $quest_num = 0;
            
            list($answers, $template, $question) = $quiz->lotto_question($q_data[$quest_num]);
            
            //pobierz załaczniki
            $attachments = Jelly::select('attachment')->order_by('posy','ASC')->filter($question->id, 'questions', 1)->cached(3600)->execute();
        
            //wyswietl odpowiedni szablon
            if (Request::$is_ajax) {
                $content = View::factory('site/modules/exercise/ajax/questions/'.$template.'.tpl');
            }
            else {
                $content = View::factory('site/modules/exercise/questions/'.$template.'.tpl');
            }
            
            $this->content = $content
                ->bind('message', $message)                
                ->bind('session_test', $session_test)
                ->bind('question', $question)
                ->bind('answers', $answers)                    
                ->bind('course', $course)
                ->bind('course_options', $course_options)
                ->bind('material', $material)        
                ->bind('test', $test)
                ->bind('test_variables', $test_variables)
                ->bind('subscribe', $subscribe)
                ->bind('moderators', $moderators)
                ->bind('material_count_bar_files', $material_count_bar_files)
                ->bind('attachments', $attachments)
                ->bind('current_page', $current_page)
                ->bind('new_pager', $new_pager)
                ->bind('prev_page', $pager_prev_page)
          		->bind('next_page', $pager_next_page);
        }
        else {
            
        }
    }
    
    public function action_question($course_id, $material_id, $question_id) {
        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
        $test = Jelly::select('material_test')->by_material($material->id)->limit(1)->execute();
        $subscribe = Jelly::select('course_user')->filter(Session::instance()->get('auth_user')->id, $course->id)->limit(1)->cached(3600)->execute();
        
        //opcje szkolenia
        $course_options = unserialize($course->options);
        
        //pobierz paginacje
        list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
        
        //pobierz moderatorow
        $moderators = Jelly::select('course_moderator')->where('course_id','=',$course->id)->cached(3600)->execute();
        
        //pobierz dane z sesji
        $session_test = Session::instance()->get('test');
                     
        $quiz = new Quiz($test->id, $course_id, $material_id);        
        $q_data = $quiz->quiz_get_questionlist();

		$is_quest_exists = false;
		$qtype = 0;
		
		foreach ($q_data as $qd) {
			if ($qd == $question_id) {
				$question =  Jelly::select('question', $question_id);
				$qtype = $question->type;
				break;
			}
		}
        
		$proc_qtype = $qtype;

		$is_correct = 0;
        
        $current_question_ids = array();
        $current_question_ids[] = $question_id;
        
        /**
         * 1 - jednokrotnego wyboru
         * 2 - wielokrotnego wyboru
         * 3 - Dopasuj pary
         * 4 - Zaznacz obszar
         * 5 - Prawda / falsz
         * 6 - Pytanie otwarte
         * 7 - Wypisz...
         */
        switch ($proc_qtype) {
            case 1:
                $odp = null;
                
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->execute();
                
                if (input::get('odp')) {
                    $odp = input::get('odp');
                }
                else {
                    $odp = '';
                    for($i=1; $i<11; $i++) {
                        if(isset($_POST['odp'.$i]) && !empty($_POST['odp'.$i])) {
                            $odp.= '1';
                        }
                        else {
                            $odp.= '0';
                        }   
                    }
                }
                
                
                if ($odp == $answers->good) {
                    $is_correct = 1;
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '1');
            break;
            case 2:
                $odp = null;
                
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
                    $odp = input::get('odp');
                }
                else {
                    $odp = '';
                    for($i=1; $i<11; $i++) {
                        if(isset($_POST['odp'.$i]) && !empty($_POST['odp'.$i])) {
                            $odp.= '1';
                        }
                        else {
                            $odp.= '0';
                        }   
                    }
                }
                
                if ($question->one_is_good) {
                    $count_good = 0;
                    $count_bad = 0;
                    
                    if ($answers->good[0] == '1' && $odp[0] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[0] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[1] == '1' && $odp[1] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[1] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[2] == '1' && $odp[2] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[2] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[3] == '1' && $odp[3] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[3] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[4] == '1' && $odp[4] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[4] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[5] == '1' && $odp[5] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[5] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[6] == '1' && $odp[6] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[6] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[7] == '1' && $odp[7] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[7] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[8] == '1' && $odp[8] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[8] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[9] == '1' && $odp[9] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[9] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if (!$count_bad) {
                        $is_correct = 1;
                    }
                }
                else {
                    if($odp == $answers->good) {
                        $is_correct = 1;
                    }
                }
                
                
                $quiz->stats_question($question_id, $odp, $is_correct, '2');
            break;
            case 3:
                $odp = null;
                
                $answers = Jelly::select('question_matching')->where('question_id','=',$question->id)->execute()->as_array();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $ans_array_values = array();
                    
                    $is_correct = 1;
                    $rr_num = 0;
                    
                    for ($di = 0, $dn = count($answers); $di < $dn; $di ++) {
                        $answers[$di]['option_right_md5'] = md5($answers[$di]['option_right']);
                    }
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($answers as $right_row) {
                            if ($ans_array_one == $right_row['option_right_md5']) {
                                $ans_array_values[$ans_array_one] = $right_row['option_right'];
                                break;
                            }
                        }
                    }
                    
                    foreach ($answers as $right_row) {
                        if (trim($right_row['option_right_md5']) != trim($ans_array[$rr_num])) {
                            $is_correct = 0;
                        }
                        $rr_num ++;
                    }
                }
                else {
                    $is_correct = 0;
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '3');
            break;
            case 4:
                $odp = null;
                
                $answers = Jelly::select('question_hotspot')->where('question_id','=',$question->id)->limit(1)->execute();
                
                if (input::get('odp')) {
                    $odp = explode(',', input::get('odp'));
                }
                else {
                    $odp = explode(',', input::post('odp'));
                }
                                
				if ((count($odp) == 2) && ($odp[0] >= $answers->start_x) && ($odp[0] <= ($answers->start_x+$answers->width)) && ($odp[1] >= $answers->start_y) && ($odp[1] <= ($answers->start_y+$answers->height)) ) {
				    $is_correct = 1;
				}
                
                $quiz->stats_question($question_id, $odp, $is_correct, '4');
            break;
            case 5:
                $odp = null;
                
                $answers = Jelly::select('question_boolean')->where('question_id','=',$question->id)->limit(1)->execute();
                if (isset($_GET['odp'])) {
                    if ($_GET['odp'] == $answers->good) {
                        $odp = $_GET['odp'];
                        
                        $is_correct = 1;
                    }
                }
                else {
                    if (input::post('odp') == $answers->good) {
                        $odp = input::post('odp');
                        
                        $is_correct = 1;
                    }
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '5');
            break;
            case 6:
                $odp = null;
                
                if (input::post('odp') && input::post('odp') <> 'undefined') {
                    $odp = input::post('odp');
                    
                    $is_correct = 1;
                }
                else {
                    if (input::get('odp') && input::get('odp') <> 'undefined') {
                        $odp = input::get('odp');
                        
                        $is_correct = 1;
                    }
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '6');
            break;
            case 7:
                $odp = null;
                
                $answers = Jelly::select('question_list')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $good_array = unserialize($answers->good);
                    
                    $count_good = 0;
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($good_array as $right_row) {
                            similar_text($ans_array_one, $right_row, $percent);
                            
                            if ($percent >= 50) {
                                $count_good++;
                            }
                        }
                    }
                    
                    if ($count_good >= $answers->answers) {
                        $is_correct = 1;
                    }
                    else {
                        $is_correct = 0;
                    }
                }
                else {
                    $is_correct = 0;
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '7');
            break;
            case 9:
                $odp = null;
                
                $answers = Jelly::select('question_memory')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $good_array = unserialize($answers->good);
                    
                    $count_good = 0;
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($good_array as $right_row) {
                            similar_text($ans_array_one, $right_row, $percent);
                            
                            if ($percent >= 100) {
                                $count_good++;
                            }
                        }
                    }
                    
                    if ($count_good >= $answers->to_pass) {
                        $is_correct = 1;
                    }
                    else {
                        $is_correct = 0;
                    }
                }
                else {
                    $is_correct = 0;
                }
                
                $quiz->stats_question($question_id, $odp, $is_correct, '9', $count_good);
            break;
		}
        
        //oblicz ile czasu pozostalo na rozwiazanie
        $time_end = $session_test['end'];
        $time_left = mktime(date('G'), date('i'), date('s'), date('m'), date('d'), date('Y'));
        
        $to_time   = strtotime(date('Y-m-d H:i:s', $time_end));
        $from_time = strtotime(date('Y-m-d H:i:s', $time_left));
        $date_diff_array = Date::datediff($from_time, $to_time);
        
        $minutes = ($date_diff_array['hours']*60)+$date_diff_array['minutes'];
        $seconds = $date_diff_array['seconds']+1;
        
        $session_test_new = array_merge($session_test, array(
            'current'   => $session_test['current']+1,
            'good'      => ($is_correct == 1) ? $session_test['good']+1 : $session_test['good'],
            'bad'       => ($is_correct != 1) ? $session_test['bad']+1 : $session_test['bad'],
            'questions' => array_merge($session_test['questions'], $current_question_ids),
            'end'       => $time_end,
            'minutes'   => $minutes,
            'seconds'   => $seconds
        ));
        
        Session::instance()->set('test', $session_test_new);
        
        $session_test = Session::instance()->get('test');
        
        
        $j = -1;
		$quest_num = 1;
        
        $q_ids = $session_test['questions'];
		$q_num = 0;
		$q_num_ar = 0;
		$qqn = 0;
        foreach ($q_data as $qd) {
            if ($qd == $question_id) {
                $q_num = $qqn + 1;
                $q_num_ar = $qqn;
                break;
            }
            $qqn ++;
		}
        
        if (!$q_num) {
            return '';
        }
        else {
            $q_num = 0;
            $q_num_ar = 0;
            
            for ($i = $qqn, $n = count($q_data); $i < $n; $i ++ ) {
                if (!in_array($q_data[$i], $q_ids) && $q_data[$i] != $question_id ) {
                    $q_num = $i + 1;
                    $q_num_ar = $i;
                    break;
                }
            }
            
            if (!$q_num) {
                for ($i = 0; $i < $qqn; $i ++ ) {
                    if (!in_array($q_data[$i], $q_ids) && $q_data[$i] != $question_id ) {
                        $q_num = $i + 1;
                        $q_num_ar = $i;
                        break;
                    }
                }
            }
            
            if ($q_num) {
                $quest_num = $q_num;
                $j = $q_num_ar;
            }
        }
        
        if (isset($q_data[$j])) {
            list($answers, $template, $question) = $quiz->lotto_question($q_data[$j]);
            
            //pobierz załaczniki
            $attachments = Jelly::select('attachment')->order_by('posy','ASC')->filter($question->id, 'questions', 1)->cached(3600)->execute();
        
        
            //wyswietl odpowiedni szablon
            if (Request::$is_ajax) {
                $content = View::factory('site/modules/exercise/ajax/questions/'.$template.'.tpl');
            }
            else {
                $content = View::factory('site/modules/exercise/questions/'.$template.'.tpl');
            }
            
            $this->content = $content
                ->bind('message', $message)                
                ->bind('session_test', $session_test)
                ->bind('question', $question)
                ->bind('answers', $answers)                    
                ->bind('course', $course)
                ->bind('course_options', $course_options)
                ->bind('material', $material)        
                ->bind('test', $test)
                ->bind('test_variables', $test_variables)
                ->bind('subscribe', $subscribe)
                ->bind('moderators', $moderators)
                ->bind('material_count_bar_files', $material_count_bar_files)
                ->bind('attachments', $attachments)
                ->bind('current_page', $current_page)
                ->bind('new_pager', $new_pager)
                ->bind('prev_page', $pager_prev_page)
          		->bind('next_page', $pager_next_page);
        }
        else {
            $quiz->finish_exercise($subscribe);

            //przekierowanie
            if ($material->is_module_last()) {
                $next_module = $course->next_module($material->category);

                $next_material = $next_module->first_material();

                Request::instance()->headers['REDIRECT'] = '1';
                    
                echo URL::site('course/index/'.$course->id.'/'.$next_material->id.'?module='.$next_material->category->id.'&page=1&lesson=1');
            }
            else {
                $next_material = $material->next_material();

                $pager_material = unserialize(Session::instance()->get('znewPagerMaterial'));

                Request::instance()->headers['REDIRECT'] = '1';
                
                echo URL::site('course/index/'.$course->id.'/'.$next_material->id.'?module='.$pager_material[$next_material->id]['module'].'&page='.$pager_material[$next_material->id]['pager'].'&lesson='.$pager_material[$next_material->id]['pager']);
            }
        }
    }
    
    public function action_finish($course_id, $material_id) {
        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);

        //zaliczanie
        $subscribe = Jelly::select('course_user')
            ->filter(Auth::instance()->get_user()->id, $course->id)
            ->limit(1)
            ->execute();
        
        $test = Jelly::select('material_test')
            ->by_material($material_id)
            ->limit(1)
            ->execute();
        
        $quiz = new Quiz($test->id, $course_id, $material_id);
        $quiz->finish_test($subscribe);
        
        Session::instance()->delete('test');

        //przekierowanie
        if ($material->is_module_last()) {
            $next_module = $course->next_module($material->category);

            $pager_material = unserialize(Session::instance()->get('znewPagerMaterial'));
            $next_material_id = $next_module->first_material()->id;

            Request::instance()->headers['REDIRECT'] = '1';
                
            echo URL::site('course/index/'.$course->id.'/'.$next_material_id.'?module='.$pager_material[$next_material_id]['module'].'&page=1&lesson=1');
        }
        else {
            $next_material = $material->next_material();

            $pager_material = unserialize(Session::instance()->get('znewPagerMaterial'));

            Request::instance()->headers['REDIRECT'] = '1';
                
            URL::site('course/index/'.$course->id.'/'.$next_material->id.'?module='.$pager_material[$next_material->id]['module'].'&page='.$pager_material[$next_material->id]['pager'].'&lesson='.$pager_material[$next_material->id]['pager']);
        }
    }
    public function action_check($course_id, $material_id, $question_id) {
        $is_correct = 0;
        
        $question =  Jelly::select('question', $question_id);
        
        $student_result = 0;
        $platform_result = 0;
        
        /**
         * 1 - jednokrotnego wyboru
         * 2 - wielokrotnego wyboru
         * 3 - Dopasuj pary
         * 4 - Zaznacz obszar
         * 5 - Prawda / falsz
         * 6 - Pytanie otwarte
         * 7 - Wypisz...
         */
        switch ($question->type) {
            case 1:
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->execute();
                
                if (input::get('odp')) {
                    $odp = input::get('odp');
                }
                else {
                    $odp = '';
                    for($i=1; $i<11; $i++) {
                        if(isset($_POST['odp'.$i]) && !empty($_POST['odp'.$i])) {
                            $odp.= '1';
                        }
                        else {
                            $odp.= '0';
                        }   
                    }
                }
                
                if ($odp == $answers->good) {
                    $is_correct = 1;
                }
            break;
            case 2:
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
                    $odp = input::get('odp');
                }
                else {
                    $odp = '';
                    for($i=1; $i<11; $i++) {
                        if(isset($_POST['odp'.$i]) && !empty($_POST['odp'.$i])) {
                            $odp.= '1';
                        }
                        else {
                            $odp.= '0';
                        }   
                    }
                }
                
                if ($question->one_is_good) {
                    $count_good = 0;
                    $count_bad = 0;
                    
                    if ($answers->good[0] == '1' && $odp[0] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[0] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[1] == '1' && $odp[1] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[1] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[2] == '1' && $odp[2] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[2] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[3] == '1' && $odp[3] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[3] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[4] == '1' && $odp[4] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[4] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[5] == '1' && $odp[5] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[5] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[6] == '1' && $odp[6] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[6] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[7] == '1' && $odp[7] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[7] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[8] == '1' && $odp[8] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[8] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if ($answers->good[9] == '1' && $odp[9] == '1') {
                        $count_good++;
                    }
                    else {
                        if ($odp[9] == '1') {
                            $count_bad++;
                        }
                    }
                    
                    if (!$count_bad) {
                        $is_correct = 1;
                    }
                }
                else {
                    if($odp == $answers->good) {
                        $is_correct = 1;
                    }
                }
            break;
            case 3:
                $answers = Jelly::select('question_matching')->where('question_id','=',$question->id)->execute()->as_array();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $ans_array_values = array();
                    
                    $is_correct = 1;
                    $rr_num = 0;
                    
                    for ($di = 0, $dn = count($answers); $di < $dn; $di ++) {
                        $answers[$di]['option_right_md5'] = md5($answers[$di]['option_right']);
                    }
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($answers as $right_row) {
                            if ($ans_array_one == $right_row['option_right_md5']) {
                                $ans_array_values[$ans_array_one] = $right_row['option_right'];
                                break;
                            }
                        }
                    }
                    
                    foreach ($answers as $right_row) {
                        if (trim($right_row['option_right_md5']) != trim($ans_array[$rr_num])) {
                            $is_correct = 0;
                        }
                        $rr_num ++;
                    }
                }
                else {
                    $is_correct = 0;
                }
            break;
            case 4:
                $answers = Jelly::select('question_hotspot')->where('question_id','=',$question->id)->limit(1)->execute();
                
                if (input::get('odp')) {
                    $ans_array = explode(',', input::get('odp'));
                }
                else {
                    $ans_array = explode(',', input::post('odp'));
                }
                                
				if ((count($ans_array) == 2) && ($ans_array[0] >= $answers->start_x) && ($ans_array[0] <= ($answers->start_x+$answers->width)) && ($ans_array[1] >= $answers->start_y) && ($ans_array[1] <= ($answers->start_y+$answers->height)) ) {
				    $is_correct = 1;
				}
            break;
            case 5:
                $answers = Jelly::select('question_boolean')->where('question_id','=',$question->id)->limit(1)->execute();
                
                if (isset($_GET['odp'])) {
                    if ($_GET['odp'] == $answers->good) {
                        $is_correct = 1;
                    }
                }
                else {
                    if (input::post('odp') == $answers->good) {
                        $is_correct = 1;
                    }
                }
            break;
            case 6:
                if (input::post('odp') && input::post('odp') <> 'undefined') {
                    $is_correct = 1;
                }
                else {
                    if (input::get('odp') && input::get('odp') <> 'undefined') {
                        $is_correct = 1;
                    }
                }
            break;
            case 7:
                $odp = null;
                
                $answers = Jelly::select('question_list')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $good_array = unserialize($answers->good);
                    
                    $count_good = 0;
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($good_array as $right_row) {
                            similar_text($ans_array_one, $right_row, $percent);
                            
                            if ($percent >= 50) {
                                $count_good++;
                            }
                        }
                    }
                    
                    if ($count_good >= $answers->answers) {
                        $is_correct = 1;
                    }
                    else {
                        $is_correct = 0;
                    }
                }
                else {
                    $is_correct = 0;
                }
            break;
            case 9:
                $answers = Jelly::select('question_memory')->where('question_id','=',$question->id)->limit(1)->execute();
                if (input::get('odp')) {
    				$odp = urldecode(input::get('odp'));
                    $ans_array = explode('```', $odp);
                    $good_array = unserialize($answers->good);
                    
                    $count_good = 0;
                    
                    foreach ($ans_array as $ans_array_one) {
                        foreach ($good_array as $right_row) {
                            similar_text($ans_array_one, $right_row, $percent);
                            
                            if ($percent >= 100) {
                                $count_good++;
                            }
                        }
                    }
                    
                    if ($count_good >= $answers->to_pass) {
                        $is_correct = 1;
                    }
                    else {
                        $is_correct = 0;
                    }
                    
                    $student_result = $count_good;
                    
                    $platform_stat = Jelly::select('material_test_stat')->where('question_id', '=', $question->id)->where('is_good', '=', '1')->order_by('additional_info', 'DESC')->limit(1)->execute();
                    
                    if ($platform_stat->loaded()) {
                        $platform_result = $platform_stat->additional_info;
                    }
                    else {
                        $platform_result = 'Brak danych';
                    }
                }
                else {
                    $is_correct = 0;
                }
            break;
		}
        
        $replaceData = array();
        $replaceData['[student_result]'] = $student_result;
        $replaceData['[platform_result]'] = $platform_result;
        
        $feedback_good = $question->feedback_good ? $question->feedback_good : __('Gratulacje. Prawidłowa odpowiedź');
        $feedback_wrong = $question->feedback_wrong ? $question->feedback_wrong : __('Odpowiedź błędna. Spróbuj jeszcze raz');
                        
        $feedback_good = str_replace(array_keys($replaceData), array_values($replaceData), $feedback_good);
        $feedback_wrong = str_replace(array_keys($replaceData), array_values($replaceData), $feedback_wrong);
                        

        if ($is_correct) {
            $message = array(
                'is_good' => $is_correct,
                'message' => $feedback_good
            );
            
            echo json_encode($message);
        }
        else {
            $message = array(
                'is_good' => $is_correct,
                'message' => $feedback_wrong
            );
            
            echo json_encode($message);
        }
        
        exit;
    }
}