<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'scorm/lms_scorm.class');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.lib');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.play');

class Controller_Scorm extends Relio_Controller_Website {
    public function action_list($course_id, $material_id) {
        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
        $lesson = Jelly::select('material_scorm')->by_material($material->id)->limit(1)->execute();
        $subscribe = Jelly::select('course_user')->filter(Session::instance()->get('auth_user')->id, $course->id)->limit(1)->execute();

        //opcje szkolenia
        $course_options = unserialize($course->options);
        
        //pobierz paginacje
        list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
        
        //pobierz załaczniki
        $attachments = Jelly::select('attachment')
            ->filter($material->id, 'materials', 1)
            ->cached(3600)
            ->order_by('posy','ASC')
            ->execute();
        
        //pobierz moderatorow
        $moderators = Jelly::select('course_moderator')->where('course_id','=',$course->id)->cached(3600)->execute();
        
        //sprawdz odnosnie tego materialu mamy juz jakis wpis w bazie
        //w przypadku scorm zaliczamy po przejsciu calej packi (?)
        $stat = Jelly::select('material_stat')
            ->where('material_id', '=', $material->id)
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('course_id', '=', $course->id)
            ->limit(1)
            ->execute();
            
        if (!$stat->loaded()) {
            $stat = Jelly::factory('material_stat');
            $stat->set(array(
                'user'        => Auth::instance()->get_user()->id,
                'course'      => $course->id,
                'material'    => $material->id,
                'trials'      => 1,
                'status'      => 0,
                'start_on'    => date('Y-m-d H:i:s'),
                'end_on'      => date('Y-m-d H:i:s'),
                'updated_on'  => date('Y-m-d H:i:s', time())
            ));
            $stat->save();
        }
        else {
            $stat->start_on = date('Y-m-d H:i:s');
            $stat->end_on = date('Y-m-d H:i:s');
            $stat->trials = ($stat->trials+1);
            $stat->updated_on = date('Y-m-d H:i:s', time());
            $stat->save();
        }
        
        $subscribe->update_progress();
        
        $scorm = null;
        jlms_checkscorm($id, $material, $scorm);
        
        if (!empty($scorm)) {
            $scoid = input::get('scoid');
            $mode = 'normal';
            $currentorg = input::get('currentorg');
            $newattempt = input::get('newattempt');
                        
            if ($scorm->popup) {
                //echo '<div style="text-align: center;">Aby rozpocząć szkolenie kliknij w poniższy link. Uwaga, szkolenie otworzy się w nowym oknie';
                //echo '<br /><strong><a href="index2.php?mod=scorm&task=player&id=' . $course_id . '&t=' . $lpath_id.'?KeepThis=true&TB_iframe=true&height=680&width=1024" class="thickbox" title="Szkolenie">Rozpocznij szkolenie</a></strong></div>';
            }
            else {
                ob_start();
                jlms_scorm_play_main( $scorm, $course, $material, $scoid, $mode, $currentorg, $newattempt );
                $scorm_play = ob_get_contents(); ob_end_clean();
            }
        }
        
        //wyswietl odpowiedni szablon
        if (Request::$is_ajax) {
            $content = View::factory('site/modules/scorm/ajax/list.tpl');
        }
        else {
            $content = View::factory('site/modules/scorm/list.tpl');
        }
        
        $this->content = $content
            ->bind('message', $message)
            ->bind('course', $course)
            ->bind('course_options', $course_options)
            ->bind('material', $material)
            ->bind('lesson', $lesson)
            ->bind('scorm', $scorm)
            ->bind('scorm_play', $scorm_play)
            ->bind('subscribe', $subscribe)
            ->bind('moderators', $moderators)
            ->bind('attachments', $attachments)
            ->bind('current_page', $current_page)
            ->bind('new_pager', $new_pager)
            ->bind('prev_page', $pager_prev_page)
      		->bind('next_page', $pager_next_page);
	}
    
    public function action_player($course_id, $material_id) {
    	$course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
    	$scorm = null;//new stdClass();
    	if ( $course_id && (jlms_checkscorm($id, $material, $scorm)) ) {
    		if (!empty($scorm)) {
    			// sleep one second. SCORM could send some requests on onCloasPage event. We need wait for these requests to be processed
    			#sleep(2);
    			
    			$scoid = input::get('scoid');
    			$mode = 'normal';
    			$currentorg = input::get('currentorg');
    			$newattempt = input::get('newattempt');
    					
    			//if ($scorm->popup) {
    				// SquezzeBox view - don't show Heading.
    				echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
    				echo '<html xmlns="http://www.w3.org/1999/xhtml" style="margin:0;padding:0"><head>';
    				$iso_site = 'charset=utf-8';
    				echo '<meta http-equiv="Content-Type" content="text/html; '.$iso_site.'" />';
                    echo '<base href="'.URL::base(false, 'http').'">';
    				echo '</head><body style="margin:0;padding:0">';
    				
    				jlms_scorm_play_main( $scorm, $course, $material, $scoid, $mode, $currentorg, $newattempt );
    				
    				echo '</body></html>';
    				die;
    			//}
    			//else {
    			//	echo "Załadowanie szkolenia nie powiodło się - ";
                //    exit;
    			//}
    		}
    		else {
    			echo __("Załadowanie szkolenia nie powiodło się - nie znaleziono scorma");
                exit;
    		}
    	}
    }
    
    public function action_datamodel($course_id, $material_id) {
        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
        $lesson = Jelly::select('material_scorm')->by_material($material->id)->limit(1)->execute();
        $subscribe = Jelly::select('course_user')->filter(Session::instance()->get('auth_user')->id, $course->id)->limit(1)->execute();


        $id = (input::get('id')) ? input::get('id') : input::post('id');
        if ($id) {
            $scorm = Jelly::select('scorm', $id);
            
            if ($scorm->loaded()) {
                $scoid = (input::get('scoid')) ? input::get('scoid') : input::post('scoid');
                $attempt = (input::get('attempt')) ? input::get('attempt') : input::post('attempt');
                
                if ($scoid) {
                    $result = true;
                    $request = null;
                    
                    // (DEN)
                    if (true) {
                        foreach ($_POST as $element => $val_post) {
                            $element = str_replace('__','.',$element);
                            // (DEN) (i'm insert 'get_magic_quotes_gpc'). 15.03.2007
                            $value = (get_magic_quotes_gpc()) ? mosStripslashes( $val_post ) : $val_post ;
                            if (substr($element,0,3) == 'cmi') {
                                $element = preg_replace('/N(\d+)/',".\$1",$element);
                                $result = scorm_insert_track(Auth::instance()->get_user()->id, $scorm->id, $scoid, $attempt, $element, $value) && $result;
                            }
                            
                            if (substr($element,0,15) == 'adl.nav.request') {
                                // SCORM 2004 Sequencing Request
                                require_once Kohana::find_file('vendor', 'scorm/datamodels/scorm_13lib');
                                require_once('n_scorm/datamodels/scorm_13lib.php');
                                
                                $search = array('@continue@', '@previous@', '@\{target=(\S+)\}choice@', '@exit@', '@exitAll@', '@abandon@', '@abandonAll@');
                                $replace = array('continue_', 'previous_', '\1', 'exit_', 'exitall_', 'abandon_', 'abandonall');
                                $action = preg_replace($search, $replace, $value);
                                
                                if ($action != $value) {
                                    require_once Kohana::find_file('vendor', 'scorm/datamodels/sequencinglib');
                                    
                                    // Evaluating navigation request
                                    $valid = scorm_seq_overall ($scoid, Auth::instance()->get_user()->id, $action);
                                    
                                    // Set valid request
                                    $search = array('@continue@', '@previous@', '@\{target=(\S+)\}choice@');
                                    $replace = array('true', 'true', 'true');
                                    $matched = preg_replace($search, $replace, $value);
                                    if ($matched == 'true') {
                                        $request = 'adl.nav.request_valid["'.$action.'"] = "'.$valid.'";';
                                    }
                                }
                            }
                        }
                        
                        //sprawdz odnosnie tego materialu mamy juz jakis wpis w bazie
                        //w przypadku lekcji zaliczamy odrazu po wejsciu w taki material
                        $score = scorm_grade_user($scorm, Auth::instance()->get_user()->id);
                        if ($score >= $scorm->maxgrade) {
                            $stat = Jelly::select('material_stat')
                                ->where('material_id', '=', $material_id)
                                ->where('user_id', '=', Auth::instance()->get_user()->id)
                                ->where('course_id', '=', $course_id)
                                ->limit(1)
                                ->execute();
                            
                            if ($stat->loaded()) {
                                $stat->trials = ($stat->trials+1);
                                $stat->status = 1;
                                $stat->updated_on = date('Y-m-d H:i:s', time());
                                $stat->save();
                            }
                            
                            $subscribe->update_progress();
                        }
        
    					/* 23 November 2007 (DEN) LMS resuming fix (for 'by the best attemp' tracking method */
    					/*
    					global $JLMS_CONFIG;
    					$course_params = $JLMS_CONFIG->get('course_params');
    					$params = new JLMSParameters($course_params);
    					if ($params->get('track_type',0) == 1) { //by the best attempt
    						if ($attempt > 1) {
    							$query = "SELECT * FROM #__lms_n_scorm_scoes_track WHERE userid = '$my->id' AND scormid = '$scorm->id' AND scoid = '$scoid' AND attempt = '".($attempt-1)."'";
    							$JLMS_DB->SetQuery($query);
    							$prev_tracks = $JLMS_DB->LoadObjectList();
    							foreach($prev_tracks as $prev_track) {
    								$query = "SELECT count(*) FROM #__lms_n_scorm_scoes_track WHERE userid = '$my->id' AND scormid = '$scorm->id' AND scoid = '$scoid' AND attempt = '$attempt' AND element = '$prev_track->element'";
    								$JLMS_DB->SetQuery($query);
    								$ssss = $JLMS_DB->LoadResult();
    								if (!$ssss) {
    									$track = new stdClass();
    							        $track->userid = $my->id;
    							        $track->scormid = $scorm->id;
    							        $track->scoid = $scoid;
    							        $track->attempt = $attempt;
    							        $track->element = $prev_track->element;
    							        $track->value = $prev_track->value;
    							        $track->timemodified = $prev_track->timemodified;
    							        $JLMS_DB->InsertObject('#__lms_n_scorm_scoes_track', $track, 'id');
    								}
    							}
    						}
    					}
    					*/
    					/* End of LMS resuming fix */
                    }
                    
                    if ($result) {
                        echo "true\n0";
                    }
                    else {
                        echo "false\n101";
                    }
                    
                    if ($request != null) {
                        echo "\n".$request;
                    }
                }
            }
        }
        exit();
    }
    
    public function action_api($course_id, $material_id) {
        $id = input::get('id');
        
        if ($id) {
            $scorm = Jelly::select('scorm', $id);
            if ($scorm->loaded()) {
                $scoid = input::get('scoid');
                $attempt = input::get('attempt');
                $mode = input::get('mode');
                
				$userdata = new stdClass();
				
                if ($usertrack=scorm_get_tracks($scoid, Auth::instance()->get_user()->id, $attempt)) {
                    if ((isset($usertrack->{'cmi.exit'}) && ($usertrack->{'cmi.exit'} != 'time-out')) || ($scorm->version != "SCORM_1.3")) {
                        foreach ($usertrack as $key => $value) {
                            $userdata->$key = addslashes($value);
                        }
                    }
                    else {
                        $userdata->status = '';
                        $userdata->score_raw = '';
                    }
                }
                else {
                    $userdata->status = '';
                    $userdata->score_raw = '';
                }
                    
                $userdata->student_id = addslashes(Auth::instance()->get_user()->id);
                $userdata->student_name = addslashes(Auth::instance()->get_user()->firstname.' '.Auth::instance()->get_user()->lastname);
                $userdata->mode = 'normal';
                
                if ($mode) {
                    $userdata->mode = $mode;
                }
                
                if ($userdata->mode == 'normal') {
                    $userdata->credit = 'credit';
                }
                else {
                    $userdata->credit = 'no-credit';
                }
                    
                if ($scodatas = scorm_get_sco($scoid, SCO_DATA)) {
                    foreach ($scodatas as $key => $value) {
                        $userdata->$key = $value;
                    }
                }
                else {
                    // (DEN)
                    //error('Sco not found');
                    echo 'SCO not found';
                }
                
                $userdata->course_id = $course_id;
                $userdata->material_id = $material_id;
                
                //$scorm->version = strtolower(clean_param($scorm->version, PARAM_SAFEDIR));   // Just to be safe
                $scorm->version = strtolower(eregi_replace('[^a-zA-Z0-9_-]', '', $scorm->version));
                
                require_once Kohana::find_file('vendor', 'scorm/lms_scorm.play');
                
                if (Kohana::find_file('vendor', 'scorm/datamodels/'.$scorm->version.'.js')) {
                    require_once Kohana::find_file('vendor', 'scorm/datamodels/'.$scorm->version.'.js');
                }
                else {
                    require_once Kohana::find_file('vendor', 'scorm/datamodels/scorm_12.js');
                }
                    
                // set the start time of this SCO
                scorm_insert_track(Auth::instance()->get_user()->id, $scorm->id, $scoid, $attempt, 'x.start.time', time());
                    
                echo 'var errorCode = "0";';
                echo 'function underscore(str) {';
                echo '    str = str.replace(/.N/g,".");';
                echo '    return str.replace(/\./g,"__");';
                echo '}';
            }
        }
        exit();
    }
    
    public function action_loadsco($course_id, $material_id) {
        $id = input::get('id');
        
        $delayseconds = 10;  // Delay time before sco launch, used to give time to browser to define API
        $delayseconds_nojs = 2; // if API were defined earlier than timer is passed - SCO will be launched
        
        if ($id) {
            $scorm = Jelly::select('scorm', $id);
            
            if ($scorm->loaded()) {
                $scoid = intval($_REQUEST['scoid']);
                if (!empty($scoid)) {
                    //
    				// Direct SCO request
    				//
    				if ($sco = scorm_get_sco($scoid)) { // (DEN) check if this $scoid from our SCORM !!!!
    					if ($sco->launch == '') {
    						// Search for the next launchable sco
                            $scoes = Jelly::select('scorm_scoe')
                                ->where('scorm', '=', $scorm->id)
                                ->where('launch', '<>', '')
                                ->where('id', '>', $sco->id)
                                ->order_by('id', 'ASC')
                                ->execute();
                                
    						if (!empty($scoes)) {
    							$sco = current($scoes);
    						}
    					}
    				}
			    }
    			//
    			// If no sco was found get the first of SCORM package
    			//
    			if (!isset($sco)) {
    			    $scoes = Jelly::select('scorm_scoe')
                        ->where('scorm', '=', $scorm->id)
                        ->where('launch', '<>', '')
                        ->order_by('id', 'ASC')
                        ->execute();
                        
    				$sco = current($scoes);
    			}
                
    			if (!empty($sco)) {
    				if ($sco->scormtype == 'asset') {
    					$attempt = scorm_get_last_attempt($scorm->id, Auth::instance()->get_user()->id);
    					$element = ($scorm->version == 'scorm_13' || $scorm->version == 'SCORM_1.3') ?'cmi.completion_status':'cmi.core.lesson_status';
    					$value = 'completed';
    					$result = scorm_insert_track(Auth::instance()->get_user()->id, $scorm->id, $sco->id, $attempt, $element, $value);
    				}
    			}

    			//
    			// Forge SCO URL
    			//
    			$connector = '';
    			$version = substr($scorm->version,0,4);
    			if ((isset($sco->parameters) && (!empty($sco->parameters))) || ($version == 'AICC')) {
    				if (stripos($sco->launch,'?') !== false) {
    					$connector = '&';
    				} else {
    					$connector = '?';
    				}
    				if ((isset($sco->parameters) && (!empty($sco->parameters))) && ($sco->parameters[0] == '?')) {
    					$sco->parameters = substr($sco->parameters,1);
    				}
    			}
    			
    			if ($version == 'AICC') {
    				if (isset($sco->parameters) && (!empty($sco->parameters))) {
    					$sco->parameters = '&'. $sco->parameters;
    				}
    				//$launcher = $sco->launch.$connector.'aicc_sid='.$my->id.'&aicc_url='.$CFG->wwwroot.'/mod/scorm/aicc.php'.$sco->parameters;
    				//$launcher = $sco->launch.$connector.'aicc_sid='.$my->id.'&aicc_url='.$mainframe->getCfg('live_site')."/index.php?option=$option&Itemid=$Itemid&task=aicc_task&course_id=$course_id".$sco->parameters;
    			} else {
    				if (isset($sco->parameters) && (!empty($sco->parameters))) {
    					$launcher = $sco->launch.$connector.$sco->parameters;
    				} else {
    					$launcher = $sco->launch;
    				}
    			}
			
                $scorm_ref = Jelly::select('scorm_package', $scorm->scorm_package);
                
    			$reference_folder = "upload/materials/scorm/" . $scorm_ref->folder_srv_name;

    			if (true) {
    				if (true) {
    					if (basename($reference_folder) == 'imsmanifest.xml') {
    						//$basedir = dirname($scorm->reference);
    						$basedir = dirname($reference_folder);
    					} else {
    						$basedir = $reference_folder;
    					}
    					
    					$result = URL::base(false, 'http').$reference_folder . '/' . $launcher;
                        
                        echo '<html>'."\n";
                        echo '<head>'."\n";
                        echo '<base href="'.URL::base(false, 'http').'">'."\n";
                        echo '<title>LoadSCO</title>'."\n";
                        echo '<meta name="keywords" content="'.$id.', '.$scorm->id.', '.$scorm->scorm_package.'"/>'."\n";
                        echo '<script type="text/javascript">'."\n";
                        echo '//<![CDATA['."\n";
                        echo 'setTimeout(\'document.location = "'.$result.'";\','.$delayseconds.'000);'."\n";
                        echo '//]]>'."\n";
                        echo '</script>'."\n";
                        echo '<noscript>'."\n";
                        echo '<meta http-equiv="refresh" content="'.$delayseconds.';url='.$result.'" />';
                        echo '</noscript>'."\n";
                        echo '</head>'."\n";
                        echo '<body>'."\n";
                        echo '<br /><br /><div style="text-align: center;"><img src="public/design/frontend/scorm/loading.gif" height="32" width="32" border="0" alt="loading" /></div>'."\n";
                        echo '</body>'."\n";
                        echo '</html>'."\n";
                    }
                }
            }
         }
         die;
    }
}