<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Videosync extends Relio_Controller_Website {
    public function action_list($course_id, $material_id) {

        $course = Jelly::select('course', $course_id);
        $material = Jelly::select('material', $material_id);
        
        $lesson = Jelly::select('material_videosync')->by_material($material->id)->limit(1)->execute();
        $subscribe = Jelly::select('course_user')
            ->filter(Auth::instance()->get_user()->id, $course->id)
            ->limit(1)
            ->execute();
        
        //opcje szkolenia
        $course_options = unserialize($course->options);
        
        //pobierz załaczniki
        $attachments = Jelly::select('attachment')
            ->filter($material->id, 'materials', 1)
            ->cached(3600)
            ->order_by('posy','ASC')
            ->execute();
        
        //pobierz moderatorow
        $moderators = Jelly::select('course_moderator')->where('course_id','=',$course->id)->cached(3600)->execute();
        
        //sprawdz odnosnie tego materialu mamy juz jakis wpis w bazie
        //w przypadku lekcji zaliczamy odrazu po wejsciu w taki material
        $stat = Jelly::select('material_stat')
            ->where('material_id', '=', $material->id)
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('course_id', '=', $course->id)
            ->limit(1)
            ->execute();
            
        if (!$stat->loaded()) {
            $stat = Jelly::factory('material_stat');
            $stat->set(array(
                'user'        => Auth::instance()->get_user()->id,
                'course'      => $course->id,
                'material'    => $material->id,
                'trials'      => 1,
                'status'      => 1,
                'start_on'    => date('Y-m-d H:i:s'),
                'end_on'      => date('Y-m-d H:i:s'),
                'updated_on'  => date('Y-m-d H:i:s', time())
            ));
            $stat->save();
        }
        else
        {
            $stat->start_on = date('Y-m-d H:i:s');
            $stat->end_on = date('Y-m-d H:i:s');
            $stat->trials = ($stat->trials+1);
            $stat->updated_on = date('Y-m-d H:i:s', time());
            $stat->save();
        }
        $subscribe->update_progress();
        
        //pobierz paginacje
        list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
        
        $message = message::get_once('frontend');
        
        //wyswietl odpowiedni szablon
        if (Request::$is_ajax) {
            $content = View::factory('site/modules/videosync/ajax/list.tpl');
        }
        else {
            $content = View::factory('site/modules/videosync/list.tpl');
        }
        
        $this->content = $content
            ->bind('message', $message)
            ->bind('course', $course)
            ->bind('course_options', $course_options)
            ->bind('material', $material)        
            ->bind('lesson', $lesson)
            ->bind('subscribe', $subscribe)
            ->bind('moderators', $moderators)
            ->bind('attachments', $attachments)
            ->bind('current_page', $current_page)
            ->bind('new_pager', $new_pager)
            ->bind('prev_page', $pager_prev_page)
      		->bind('next_page', $pager_next_page);
	}

    public function action_xml($course_id, $material_id) {
        $items = Jelly::select('material_videosync_slide')
            ->where('material_id', '=', $material_id)
            ->execute();

        echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
        echo '<slideshow>'."\n";
        echo "\t".'<slides>'."\n";
        foreach($items as $it) {
            echo "\t\t".'<slide>'."\n";
            echo "\t\t\t".'<url>/upload/materials/videosync/'.$it->icon.'</url>'."\n";
            echo "\t\t\t".'<time>'.Timecode::tcToSec(Timecode::parseInput($it->time)).'</time>'."\n";
            echo "\t\t".'</slide>'."\n";
        }
        echo "\t".'</slides>'."\n";
        echo '</slideshow>'."\n";

        exit;
    }
}