<?php
function scorm_add_time ($a, $b) {
    $aes = explode (':', $a);
    $bes = explode (':', $b);
    $aseconds = explode ('.', $aes[2]);
    $bseconds = explode ('.', $bes[2]);
    $change = 0;
    $acents = 0;
    
    if (1 < count ($aseconds)) {
        $acents = $aseconds[1];
    }

    $bcents = 0;
    if (1 < count ($bseconds)) {
        $bcents = $bseconds[1];
    }

    $cents = $acents + $bcents;
    $change = floor ($cents / 100);
    $cents = $cents - $change * 100;
    if (floor ($cents) < 10) {
        $cents = '0' . $cents;
    }

    $secs = $aseconds[0] + $bseconds[0] + $change;
    $change = floor ($secs / 60);
    $secs = $secs - $change * 60;
    if (floor ($secs) < 10) {
        $secs = '0' . $secs;
    }

    $mins = $aes[1] + $bes[1] + $change;
    $change = floor ($mins / 60);
    $mins = $mins - $change * 60;
    if ($mins < 10) {
        $mins = '0' . $mins;
    }

    $hours = $aes[0] + $bes[0] + $change;
    if ($hours < 10) {
        $hours = '0' . $hours;
    }

    if ($cents != '0') {
        return $hours . ':' . $mins . ':' . $secs . '.' . $cents;
    }
    
    return $hours . ':' . $mins . ':' . $secs;
}

function scorm_get_aicc_columns ($row, $mastername = 'system_id') {
    $tok = strtok(strtolower($row), '",');
    $result->columns = array ();
    $i = 0;
    while ($tok) {
        if ($tok != '') {
            $result->columns[] = $tok;
            if ($tok == $mastername) {
                $result->mastercol = $i;
            }
            
            ++$i;
        }
        
        $tok = strtok('",');
    }
    return $result;
}

function scorm_forge_cols_regexp ($columns, $remodule = '(".*")?,') {
    $regexp = '/^';
    foreach ($columns as $column) {
        $regexp .= $remodule;
    }

    $regexp = substr ($regexp, 0, 0 - 1) . '/';
    return $regexp;
}

function scorm_parse_aicc ($pkgdir, $scormid) {
    $version = 'AICC';
    $ids = array ();
    $courses = array ();
    $extaiccfiles = array ('crs', 'des', 'au', 'cst', 'ort', 'pre', 'cmp');
    if ($handle = opendir ($pkgdir)) {
        while ($file = readdir ($handle) !== false) {
            if ($file[0] != '.') {
                $ext = substr ($file, strrpos ($file, '.'));
                $extension = strtolower (substr ($ext, 1));
                if (in_array ($extension, $extaiccfiles)) {
                    $id = strtolower (basename ($file, $ext));
                    $ids[$id]->$extension = $file;
                    continue;
                }
                continue;
            }
        }
        
        closedir ($handle);
    }

    foreach ($ids as $courseid => $id) {
        if (isset ($id->crs)) {
            if (is_file ($pkgdir . '/' . $id->crs)) {
                $rows = file ($pkgdir . '/' . $id->crs);
                foreach ($rows as $row) {
                    if (preg_match ('' . '/^(.+)=(.+)$/', $row, $matches)) {
                        switch (strtolower (trim ($matches[1]))) {
                            case 'course_id':
                                $courses[$courseid]->id = trim ($matches[2]);
                            break;
                            case 'course_title':
                                $courses[$courseid]->title = trim ($matches[2]);
                            break;
                            case 'version':
                                $courses[$courseid]->version = 'AICC_' . trim ($matches[2]);
                            break;
                        }
                        
                        continue;
                    }
                }
            }
        }
        
        if (isset ($id->des)) {
            $rows = file ($pkgdir . '/' . $id->des);
            $columns = scorm_get_aicc_columns ($rows[0]);
            $regexp = scorm_forge_cols_regexp ($columns->columns);
            $i = 1;
            while ($i < count ($rows)) {
                if (preg_match ($regexp, $rows[$i], $matches)) {
                    $j = 0;
                    while ($j < count ($columns->columns)) {
                        $column = $columns->columns[$j];
                        $courses[$courseid]->elements[substr (trim ($matches[$columns->mastercol + 1]), 1, 0 - 1)]->$column = substr (trim ($matches[$j + 1]), 1, 0 - 1);
                        ++$j;
                    }
                }
                
                ++$i;
            }
        }
        
        if (isset ($id->au)) {
            $rows = file ($pkgdir . '/' . $id->au);
            $columns = scorm_get_aicc_columns ($rows[0]);
            $regexp = scorm_forge_cols_regexp ($columns->columns);
            $i = 1;
            while ($i < count ($rows)) {
                if (preg_match ($regexp, $rows[$i], $matches)) {
                    $j = 0;
                    while ($j < count ($columns->columns)) {
                        $column = $columns->columns[$j];
                        $courses[$courseid]->elements[substr (trim ($matches[$columns->mastercol + 1]), 1, 0 - 1)]->$column = substr (trim ($matches[$j + 1]), 1, 0 - 1);
                        ++$j;
                    }
                }
                
                ++$i;
            }
        }
        
        if (isset ($id->cst)) {
            $rows = file ($pkgdir . '/' . $id->cst);
            $columns = scorm_get_aicc_columns ($rows[0], 'block');
            $regexp = scorm_forge_cols_regexp ($columns->columns, '(.+)?,');
            $i = 1;
            while ($i < count ($rows)) {
                if (preg_match ($regexp, $rows[$i], $matches)) {
                    $j = 0;
                    while ($j < count ($columns->columns)) {
                        if ($j != $columns->mastercol) {
                            $courses[$courseid]->elements[substr (trim ($matches[$j + 1]), 1, 0 - 1)]->parent = substr (trim ($matches[$columns->mastercol + 1]), 1, 0 - 1);
                        }
                        
                        ++$j;
                    }
                }
                
                ++$i;
            }
        }
        
        if (isset ($id->ort)) {
            $rows = file ($pkgdir . '/' . $id->ort);
        }
        
        if (isset ($id->pre)) {
            $rows = file ($pkgdir . '/' . $id->pre);
            $columns = scorm_get_aicc_columns ($rows[0], 'structure_element');
            $regexp = scorm_forge_cols_regexp ($columns->columns, '(.+),');
            $i = 1;
            while ($i < count ($rows)) {
                if (preg_match ($regexp, $rows[$i], $matches)) {
                    $courses[$courseid]->elements[$columns->mastercol + 1]->prerequisites = substr (trim ($matches[1 - $columns->mastercol + 1]), 1, 0 - 1);
                }
                
                ++$i;
            }
        }
        
        if (isset ($id->cmp)) {
            $rows = file ($pkgdir . '/' . $id->cmp);
            continue;
        }
    }
    
    $oldscoes = Jelly::select('scorm_scoe')->where('scorm', '=', $scormid)->execute();

    $launch = 0;
    if (isset ($courses)) {
        foreach ($courses as $course) {
            unset ($sco);
            
            $sco->identifier = $course->id;
            $sco->scorm = $scormid;
            $sco->organization = '';
            $sco->title = $course->title;
            $sco->parent = '/';
            $sco->launch = '';
            $sco->scormtype = '';
            
            $tmp_sco = Jelly::select('scorm_scoe')
                ->where('scorm', '=', $scormid)
                ->where('identifier', '=', $sco->identifier)
                ->limit(1)
                ->execute();
                
            if ($tmp_sco->loaded()) {
                $tmp_sco->set(array(
                    'organization' => $sco->organization,
                    'title'        => $sco->title,
                    'parent'       => $sco->parent,
                    'launch'       => $sco->launch,
                    'scormtype'    => $sco->scormtype
                ));
                $tmp_sco->save();
                
                $id = $tmp_sco->id;
            }
            else {
                $tmp_new_sco = Jelly::factory('scorm_scoe');
                $tmp_new_sco->set(array(
                    'identifier' => $sco->identifier,
                    'scorm' => $sco->scorm,
                    'organization' => $sco->organization,
                    'title' => $sco->title,
                    'parent' => $sco->parent,
                    'launch' => $sco->launch,
                    'scormtype' => $sco->scormtype
                ));
                $tmp_new_sco->save();
                
                $id = $tmp_new_sco->id;
            }
            
            if ($launch == 0) {
                $launch = $id;
            }
            
            if (isset ($course->elements)) {
                foreach ($course->elements as $element) {
                    unset ($sco);
                    $sco->identifier = $element->system_id;
                    $sco->scorm = $scormid;
                    $sco->organization = $course->id;
                    $sco->title = $element->title;
                    if (strtolower ($element->parent) == 'root') {
                        $sco->parent = '/';
                    }
                    else {
                        $sco->parent = $element->parent;
                    }
                    
                    if (isset ($element->file_name)) {
                        $sco->launch = $element->file_name;
                        $sco->scormtype = 'sco';
                    }
                    else {
                        $element->file_name = '';
                        $sco->scormtype = '';
                    }
                    
                    if (!isset ($element->prerequisites)) {
                        $element->prerequisites = '';
                    }
                    
                    $sco->prerequisites = $element->prerequisites;
                    if (!isset ($element->max_time_allowed)) {
                        $element->max_time_allowed = '';
                    }
                    
                    $sco->maxtimeallowed = $element->max_time_allowed;
                    if (!isset ($element->time_limit_action)) {
                        $element->time_limit_action = '';
                    }
                    
                    $sco->timelimitaction = $element->time_limit_action;
                    if (!isset ($element->mastery_score)) {
                        $element->mastery_score = '';
                    }
                    
                    $sco->masteryscore = $element->mastery_score;
                    $sco->previous = 0;
                    $sco->next = 0;
                    if ($oldscoid = scorm_array_search ('identifier', $sco->identifier, $oldscoes)) {
                        $sco->id = $oldscoid;
                        $sco_tmp = new stdClass ();
                        $sco_tmp = $sco;
                        unset ($sco_tmp[prerequisites]);
                        unset ($sco_tmp[max_time_allowed]);
                        unset ($sco_tmp[time_limit_action]);
                        unset ($sco_tmp[mastery_score]);
                        unset ($sco_tmp[previous]);
                        unset ($sco_tmp[next]);
                        
                        $tmp_update_sco = Jelly::select('scorm_scoe', $sco_tmp->id);
                        $tmp_update_sco->set(array(
                            'identifier'   => $sco_tmp->identifier,
                            'scorm'        => $sco_tmp->scorm,
                            'organization' => $sco_tmp->organization,
                            'title'        => $sco_tmp->title,
                            'parent'       => $sco_tmp->parent,
                            'launch'       => $sco_tmp->launch,
                            'scormtype'    => $sco_tmp->scormtype
                        ));
                        $tmp_update_sco->save();
                        $id = $sco_tmp->id;
                        
                        unset ($oldscoes[$oldscoid]);
                    }
                    else {
                        $sco_tmp = new stdClass ();
                        $sco_tmp = $sco;
                        unset ($sco_tmp[prerequisites]);
                        unset ($sco_tmp[maxtimeallowed]);
                        unset ($sco_tmp[timelimitaction]);
                        unset ($sco_tmp[masteryscore]);
                        unset ($sco_tmp[previous]);
                        unset ($sco_tmp[next]);
                        
                        $tmp_new_sco = Jelly::factory('scorm_scoe');
                        $tmp_new_sco->set(array(
                            'identifier'   => $sco_tmp->identifier,
                            'scorm'        => $sco_tmp->scorm,
                            'organization' => $sco_tmp->organization,
                            'title'        => $sco_tmp->title,
                            'parent'       => $sco_tmp->parent,
                            'launch'       => $sco_tmp->launch,
                            'scormtype'    => $sco_tmp->scormtype
                        ));
                        $tmp_new_sco->save();
                        
                        $id = $tmp_new_sco->id;
                    }
                    
                    if ($launch == 0) {
                        $launch = $id;
                        continue;
                    }
                }
                continue;
            }
        }
    }
    
    if (!empty ($oldscoes)) {
        foreach ($oldscoes as $oldsco) {
            DB::delete('jos_lms_n_scorm_scoes')
                ->where('id', '=', $oldsco->id)
                ->execute();
                
            DB::delete('jos_lms_n_scorm_scoes_track')
                ->where('scoid', '=', $oldsco->id)
                ->execute();
        }
    }
    
    $update = Jelly::select('scorm', $scormid);
    $update->set(array(
        'version' => 'AICC',
    ));
    $update->save();
    
    return $launch;
}

  function scorm_get_toc ($user, $scorm, $liststyle, $currentorg = '', $scoid = '', $mode = 'normal', $attempt = '', $play = false)
  {
    global $JLMS_DB;
    $strexpand = 'expcoll';
    $modestr = '';
    if ($mode == 'browse')
    {
      $modestr = '&amp;mode=' . $mode;
    }

    $scormpixdir = _JOOMLMS_SCORM_PICS;
    $result = new stdClass ();
    $result->toc = '' . '<ul id=\'0\' class=\'' . $liststyle . '\'>
';
    $tocmenus = array ();
    $result->prerequisites = true;
    $incomplete = false;
    $organizationsql = '';
    if (!empty ($currentorg))
    {
      $query = '' . 'SELECT title FROM #__lms_n_scorm_scoes WHERE scorm = ' . $scorm->id . ' AND identifier = ' . $JLMS_DB->Quote ($currentorg);
      $JLMS_DB->SetQuery ($query);
      $organizationtitle = $JLMS_DB->LoadResult ();
      if ($organizationtitle)
      {
        $result->toc .= '' . '	<li>' . $organizationtitle . '</li>
';
        $tocmenus[] = $organizationtitle;
      }

      $organizationsql = '' . 'AND organization=\'' . $currentorg . '\'';
    }

    if (empty ($attempt))
    {
      $attempt = scorm_get_last_attempt ($scorm->id, $user->id);
    }

    $result->attemptleft = $scorm->maxattempt - $attempt;
    $query = '' . 'SELECT * FROM #__lms_n_scorm_scoes WHERE scorm=\'' . $scorm->id . '\' ' . $organizationsql . ' order by id ASC';
    $JLMS_DB->SetQuery ($query);
    $scoes = $JLMS_DB->LoadObjectList ();
    if (!empty ($scoes))
    {
      $usertracks = array ();
      foreach ($scoes as $sco)
      {
        if (!empty ($sco->launch))
        {
          if ($usertrack = scorm_get_tracks ($sco->id, $user->id, $attempt))
          {
            if ($usertrack->status == '')
            {
              $usertrack->status = 'notattempted';
            }

            $usertracks[$sco->identifier] = $usertrack;
            continue;
          }

          continue;
        }
      }

      $level = 0;
      $sublist = 1;
      $previd = 0;
      $nextid = 0;
      $findnext = false;
      $parents[$level] = '/';
      foreach ($scoes as $sco)
      {
        if ($parents[$level] != $sco->parent)
        {
          if ($newlevel = array_search ($sco->parent, $parents))
          {
            $i = 0;
            while ($i < $level - $newlevel)
            {
              $result->toc .= '		</ul></li>
';
              ++$i;
            }

            $level = $newlevel;
          }
          else
          {
            $i = $level;
            $closelist = '';
            while ((0 < $i AND $parents[$level] != $sco->parent))
            {
              $closelist .= '		</ul></li>
';
              --$i;
            }

            if (($i == 0 AND $sco->parent != $currentorg))
            {
              $style = '';
              if (isset ($_COOKIE['hide:SCORMitem' . $sco->id]))
              {
                $style = ' style="display: none;"';
              }

              $result->toc .= ('' . '	') . '	<li><ul id=\'' . $sublist . '\' class=\'' . $liststyle . '\'' . $style . '>
';
              ++$level;
            }
            else
            {
              $result->toc .= $closelist;
              $level = $i;
            }

            $parents[$level] = $sco->parent;
          }
        }

        $result->toc .= '		<li>';
        $nextsco = next ($scoes);
        if ((($nextsco !== false AND $sco->parent != $nextsco->parent) AND ($level == 0 OR (0 < $level AND $nextsco->parent == $sco->identifier))))
        {
          ++$sublist;
          $icon = 'minus';
          if (isset ($_COOKIE['hide:SCORMitem' . $nextsco->id]))
          {
            $icon = 'plus';
          }

          $result->toc .= '<a href="javascript:expandCollide(img' . $sublist . ',' . $sublist . ',' . $nextsco->id . ');"><img id="img' . $sublist . '" src="' . $scormpixdir . '/' . $icon . '.gif" alt="' . $strexpand . '" title="' . $strexpand . '"/></a>';
        }
        else
        {
          $result->toc .= '<img src="' . $scormpixdir . '/spacer.gif" />';
        }

        if (empty ($sco->title))
        {
          $sco->title = $sco->identifier;
        }

        if (!empty ($sco->launch))
        {
          $startbold = '';
          $endbold = '';
          $score = '';
          if ((empty ($scoid) AND $mode != 'normal'))
          {
            $scoid = $sco->id;
          }

          if (isset ($usertracks[$sco->identifier]))
          {
            $usertrack = $usertracks[$sco->identifier];
            $strstatus = $usertrack->status;
            if ($sco->scormtype == 'sco')
            {
              $statusicon .= '<img src="' . $scormpixdir . '/' . $usertrack->status . '.gif" alt="' . $strstatus . '" title="' . $strstatus . '" />';
            }
            else
            {
              $tmp_alt = 'assetlaunched';
              $statusicon = '<img src="' . $scormpixdir . '/assetc.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
            }

            if ((($usertrack->status == 'notattempted' OR $usertrack->status == 'incomplete') OR $usertrack->status == 'browsed'))
            {
              $incomplete = true;
              if (($play AND empty ($scoid)))
              {
                $scoid = $sco->id;
              }
            }

            if ($usertrack->score_raw != '')
            {
              $tmp_score_str = 'score';
              $score = '(' . $tmp_score_str . ':&nbsp;' . $usertrack->score_raw . ')';
            }

            $strsuspended = 'suspended';
            if ($usertrack->{'cmi.core.exit'} == 'suspend')
            {
              $statusicon = '<img src="' . $scormpixdir . '/suspend.gif" alt="' . $strstatus . ' - ' . $strsuspended . '" title="' . $strstatus . ' - ' . $strsuspended . '" />';
            }
          }
          else
          {
            if (($play AND empty ($scoid)))
            {
              $scoid = $sco->id;
            }

            if ($sco->scormtype == 'sco')
            {
              $tmp_alt = 'notattempted';
              $statusicon = '<img src="' . $scormpixdir . '/notattempted.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
              $incomplete = true;
            }
            else
            {
              $tmp_alt = 'asset';
              $statusicon = '<img src="' . $scormpixdir . '/asset.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
            }
          }

          if ($sco->id == $scoid)
          {
            $startbold = '<b>';
            $endbold = '</b>';
            $findnext = true;
            $shownext = $sco->next;
            $showprev = $sco->previous;
          }

          if (((($nextid == 0 AND 1 < scorm_count_launchable ($scorm->id, $currentorg)) AND $nextsco !== false) AND !$findnext))
          {
            if (!empty ($sco->launch))
            {
              $previd = $sco->id;
            }
          }

          if ((empty ($sco->prerequisites) OR scorm_eval_prerequisites ($sco->prerequisites, $usertracks)))
          {
            if ($sco->id == $scoid)
            {
              $result->prerequisites = true;
            }

            global $option;
            global $Itemid;
            $url = sefreltoabs ('' . 'index.php?option=' . $option . '&amp;Itemid=' . $Itemid . '&amp;task=player_scorm&amp;id=' . $scorm->id . '&amp;currentorg=' . $currentorg . $modestr . '&amp;scoid=' . $sco->id);
            $result->toc .= $statusicon . '&nbsp;' . $startbold . '<a href="' . $url . '">' . $sco->title . '</a>' . $score . $endbold . '</li>
';
            $tocmenus[$sco->id] = scorm_repeater ('&minus;', $level) . '&gt;' . $sco->title;
          }
          else
          {
            if ($sco->id == $scoid)
            {
              $result->prerequisites = false;
            }

            $result->toc .= '&nbsp;' . $sco->title . '</li>
';
          }
        }
        else
        {
          $result->toc .= '&nbsp;' . $sco->title . '</li>
';
        }

        if ((($nextsco !== false AND $nextid == 0) AND $findnext))
        {
          if (!empty ($nextsco->launch))
          {
            $nextid = $nextsco->id;
            continue;
          }

          continue;
        }
      }

      $i = 0;
      while ($i < $level)
      {
        $result->toc .= '		</ul></li>
';
        ++$i;
      }

      if ($play)
      {
        $query = '' . 'SELECT * FROM #__lms_n_scorm_scoes WHERE id = ' . $scoid;
        $JLMS_DB->SetQuery ($query);
        $JLMS_DB->LoadObject ($sco);
        $sco->previd = $previd;
        $sco->nextid = $nextid;
        $result->sco = $sco;
        $result->incomplete = $incomplete;
      }
      else
      {
        $result->incomplete = $incomplete;
      }
    }

    $result->toc .= '	</ul>
';
    if ($scorm->hidetoc == 0)
    {
      $result->toc .= '
          <script type="text/javascript">
          //<![CDATA[
              function expandCollide(which,list,item) {
                  var nn=document.ids?true:false
                  var w3c=document.getElementById?true:false
                  var beg=nn?"document.ids.":w3c?"document.getElementById(":"document.all.";
                  var mid=w3c?").style":".style";

                  if (eval(beg+list+mid+".display") != "none") {
                      which.src = "' . $scormpixdir . '/plus.gif";
                      eval(beg+list+mid+".display=\'none\';");
                      new cookie("hide:SCORMitem" + item, 1, 356, "/").set();
                  } else {
                      which.src = "' . $scormpixdir . '/minus.gif";
                      eval(beg+list+mid+".display=\'block\';");
                      new cookie("hide:SCORMitem" + item, 1, -1, "/").set();
                  }
              }
          //]]>
          </script>' . '
';
    }

    global $option;
    global $Itemid;
    $url = sefreltoabs ('' . 'index.php?option=' . $option . '&amp;Itemid=' . $Itemid . '&amp;task=player_scorm&amp;id=' . $scorm->id . '&amp;currentorg=' . $currentorg . $modestr . '&amp;scoid=');
    $result->tocmenu = '..........popup_form.......';
    return $result;
  }

?>