<div id="page-layout">
    <div id="page-content">
        <div id="page-content-wrapper">
            <div class="inner-page-title">
                <h2>{lang}Materiały{/lang}</h2>
                <span>{lang}Edycja{/lang}</span>
            </div>
            {if $message.message}
            <div class="response-msg {$message.message_type} ui-corner-all">
                <span>{lang}{$message.message_type_raw}{/lang}</span>
                {$message.message}
            </div>
            {/if}
            <div class="column-content-box">
                <div class="content-box content-box-header ui-corner-all">
                    {if $errors|default:""}
                    <div class="ui-state-default ui-corner-top ui-box-header">
                        <span class="ui-icon float-left ui-icon-notice"></span>
						{lang}Formularz zawiera błędy{/lang}
					</div>
                    <script type="text/javascript">
                        {foreach $errors as $e}
                        $.jnotify('{$e}', "error");
                        {/foreach}
                    </script>
                    {/if}
					<div class="content-box-wrapper">
                        <div id="tabs">
                            <ul>
                                <li>
                                    <a href="#main">{lang}Podstawowe informacje{/lang}</a>
                                </li>
                                <li>
                                    <a href="#questions">{lang}Pytania{/lang}</a>
                                </li>
                            </ul>
                            <div id="main">
                                <form action="" method="post" enctype="multipart/form-data" class="forms" id="signupForm" name="form" >
                                    <input type="hidden" value="0" name="total_trials" />
                                    <input type="hidden" value="" name="start_on" />
                                    <input type="hidden" value="" name="end_on" />
                                    <fieldset>
                                        <ul>
                                            <li>
                                                <label class="desc {if $errors.questions|default:""}error{/if}">
                                                    {lang}Ilość pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.questions|default:$item->questions}" class="field text short" name="questions" />
                                                    <br /><small>{lang}Jest to ilość pytań jaka powinna być wylosowana z dostępnej bazy pytań{/lang}</small>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.questions_to_pass|default:""}error{/if}">
                                                    {lang}Zalicza pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.questions_to_pass|default:$item->questions_to_pass}" class="field text short" name="questions_to_pass" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.time_on|default:""}error{/if}">
                                                    {lang}Czas{/lang} (min)
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.time_on|default:$item->time_on}" class="field text short" name="time_on" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.required_good|default:""}error{/if}">
                                                    {lang}Wymagaj udzielenia poprawnej odpowiedzi przed pokazaniem następnego pytania{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="required_good_1" value="1" class="field radio" name="required_good" {if $smarty.post.required_good|default:$item->required_good == '1'}checked="checked"{/if} />
                                                    <label for="required_good_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="required_good_0" value="0" class="field radio" name="required_good" {if $smarty.post.required_good|default:$item->required_good == '0'}checked="checked"{/if} />
                                                    <label for="required_good_0" class="choice">{lang}Nie{/lang}</label>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.random_questions|default:""}error{/if}">
                                                    {lang}Losowa kolejność pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="random_questions_1" value="1" class="field radio" name="random_questions" {if $smarty.post.random_questions|default:$item->random_questions == 1}checked="checked"{/if} />
                                                    <label for="random_questions_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="random_questions_0" value="0" class="field radio" name="random_questions" {if $smarty.post.random_questions|default:$item->random_questions == '0'}checked="checked"{/if} />
                                                    <label for="random_questions_0" class="choice">{lang}Nie{/lang}</label>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.block_category|default:""}error{/if}">
                                                    {lang}Blokowanie rozdziałow{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="block_category_1" value="1" class="field radio" name="block_category" {if $smarty.post.block_category|default:$item->block_category == 1}checked="checked"{/if} />
                                                    <label for="block_category_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="block_category_2" value="2" class="field radio" name="block_category" {if $smarty.post.block_category|default:$item->block_category == 2}checked="checked"{/if} />
                                                    <label for="block_category_2" class="choice">{lang}Nie{/lang}</label>
                                                    <br /><small>{lang}Czy rozdziały i materiały występujące po ćwiczeniu mają być zablokowane do czasu przejścia ćwiczenia?{/lang}</small>
                                                </div>
                                            </li>
                                            <li class="buttons">
                                                <input class="submit" type="submit" value="{lang}Zapisz{/lang}" />
                                            </li>
                                        </ul>
                                    </fieldset>
                                </form>
                            </div>
                            <div id="questions">
                                {if !$item->id}
                                <div class="response-msg notice ui-corner-all">
                                    <span>{lang}Uwaga{/lang}</span>
                                    {lang}Przed dodaniem pytań do ćwiczeń, musisz uzupełnić oraz zapisać podstawowe informacje o ćwiczeniu{/lang}
                                </div>
                                {else}
                                <form name="questionadd" class="pager-form" method="get" action="{helper function="url::site" param1="admin/material_exercise/add_question/`$item->id`"}"> 
                                    <a href="javascript:void(0);" onclick="javascript:document.forms['questionadd'].submit();" class="btn ui-state-default ui-corner-all">
                                        <span class="ui-icon ui-icon-circle-plus"></span>{lang}Dodaj pytanie typu{/lang}
                                    </a>
                                    <select name="type" class="select">
                                        <option value="1">{lang}Jednokrotnego wyboru{/lang}</option>
                                        <option value="2">{lang}Wielokrotnego wyboru{/lang}</option>
                                        <option value="3">{lang}Dopasuj pary{/lang}</option>
                                        <option value="4">{lang}Zaznacz obszar{/lang}</option>
                                        <option value="5">{lang}Prawda/Fałsz{/lang}</option>
                                        <option value="6">{lang}Pytanie otwarte{/lang}</option>
                                        <option value="7">{lang}Wymień ...{/lang}</option>
                                        <option value="9">{lang}Pytanie z pamięci{/lang}</option>
                                        <option value="10">Ustaw kolejność</option>
                                    </select>
                                </form>
                                <div class="clear"></div>
                                <div class="hastable">
                                    <form name="myform" class="pager-form" method="post" action="{helper function="url::site" param1="admin/material_exercise/checkbox/`$material->id`"}">             
                                        <table id="sort-table-3">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <input type="checkbox" value="check_none" onclick="javascript:check_all_box(this.form)" class="submit"/>
                                                    </th>
                                                    <th>                                                    
                                                        {lang}Pytanie{/lang}
                                                    </th>
                                                    <th>
                                                        {lang}Publikuj{/lang}
                                                    </th>
                                                    <th colspan="4">
                                                        {lang}Opcje{/lang}
                                                    </th>
                                                </tr> 
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <td colspan="10">
                                                        <img src="public/design/backend/images/arrow_ltr.png" />&nbsp;
                                                        <select class="select" name="action" onchange="this.form.submit();">
                                                            <option value="0">-- {lang}wybierz{/lang} --</option>
                                                            <option value="delete">{lang}Usuń{/lang}</option>
                                                            <option value="publish">{lang}Publikuj{/lang}</option>
                                                            <option value="unpublish">{lang}Nie publikuj{/lang}</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                            <tbody> 
                                                {foreach from=$questions name=it item=it}
                                                <tr>
                                                    <td class="center">
                                                        <input type="checkbox" value="{$it->id}" name="list[]" class="checkbox"/>
                                                    </td>
                                                    <td>{$it->name}</td>
                                                    <td style="text-align: center;">
                                                        {if $it->active == 1}
                                                        <a href="{helper function="url::site" param1="admin/material_exercise/status_question/`$it->id`/0"}" title="{lang}Publikuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/tick.png" />
                                                        </a>
                                                        {else}
                                                        <a href="{helper function="url::site" param1="admin/material_exercise/status_question/`$it->id`/1"}" title="{lang}Nie publikuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/cross.png" />
                                                        </a>
                                                        {/if}
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <a href="{helper function="url::site" param1="admin/material_exercise/edit_question/`$it->id`"}?type={$it->type}" title="{lang}Edytuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/edit.png" />
                                                        </a>
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <a href="javascript:void(0);" onclick="javascript:confirm_action('{helper function="url::site" param1="admin/material_exercise/delete_question/`$it->id`"}'); return false" title="{lang}Usuń{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/delete.png" />
                                                        </a>
                                                    </td>
                                                </tr>
                                                {foreachelse}
                                                <tr>
                                                    <td colspan="10">
                                                        <div style="text-align: center; font-weight: bold;">
                                                            {lang}Brak danych do wyświetlenia{/lang}
                                                        </div>
                                                    </td>
                                                </tr>
                                                {/foreach}
                                            </tbody>
                                        </table>
                                    </form>
                                    {/if}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="clear"></div>
            <div id="sidebar">
                <div class="sidebar-content">
                    <a id="close_sidebar" class="btn ui-state-default full-link ui-corner-all" href="#drill">
                        <span class="ui-icon ui-icon-circle-arrow-e"></span>
                        {lang}Zamknij{/lang}
                    </a>
                    <a id="open_sidebar" class="btn tooltip ui-state-default full-link icon-only ui-corner-all" title="{lang}Otwórz{/lang}" href="#">
                        <span class="ui-icon ui-icon-circle-arrow-w"></span>
                    </a>
                    <div class="hide_sidebar">
                        <div class="portlet ui-widget ui-widget-content ui-helper-clearfix ui-corner-all">
                            <div class="portlet-header ui-widget-header">{lang}Baza szkoleń{/lang}</div>
                            <div class="portlet-content">
                                <ul class="side-menu layout-options">
                                    <li>
                                        <a href="{helper function="url::site" param1="admin/base/index/`$category_id`"}">{lang}Lista materiałów{/lang}</a>
                                    </li>
                                    <li>
                                        <a href="{helper function="url::site" param1="admin/base"}">{lang}Lista szkoleń{/lang}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>
{literal}
<script type="text/javascript">
$(document).ready(function() {
    $('#tabs').tabs();
});
</script>
{/literal}