<div id="page-layout">
    <div id="page-content">
        <div id="page-content-wrapper">
            <div class="inner-page-title">
                <h2>Uczniowie</h2>
            </div>
            {if $message.message}
            <div class="response-msg {$message.message_type} ui-corner-all">
                <span>{$message.message_type_raw}</span>
                {$message.message}
            </div>
            {/if}
            <div class="response-msg notice ui-corner-all">
                <span>Uwaga</span>
                Przed importem upewnij się, że wgrywasz poprawny plik. <a href="{URL::site("upload/example/import/import_users.xlsx")}">Zobacz przykładowy plik importu</a>. Sprawdź dokładnie czy formularz jest wypełniony w poprawny sposób
            </div>
            <div class="clear"></div>
            <div class="response-msg info ui-corner-all">
                <span>Informacja</span>
                <b>Informacje dotyczące pliku importu:</b><br /><br />
                - Kodowanie pliku w UTF-8<br />
                - Nie należy usuwać kolumn opisujących<br />
                - Wymaganymi polami są: Imię, Nazwisko, E-mail, Hasło, Grupa<br />
                <br /><br />
                - W polu "grupy" wpisać można:<br /><br />
                <ul>
                    {foreach from=$groups name=g item=g key=kij}
                    <li>{$g->id} dla {$g->description}</li>
                    {/foreach}
                </ul>
            </div>
            <div class="column-content-box">
                <div class="content-box content-box-header ui-corner-all">
                    {if $errors}
                    <div class="ui-state-default ui-corner-top ui-box-header">
                        <span class="ui-icon float-left ui-icon-notice"></span>
						Formularz zawiera błędy
					</div>
                    <script type="text/javascript">
                        {foreach from=$errors name=e item=e key=kij}
                        $.jnotify('{$e}', "error");
                        {/foreach}
                    </script>
                    {/if}
					<div class="content-box-wrapper">
                        <form action="" method="post" enctype="multipart/form-data" class="forms" id="signupForm" name="form" >
                            <input type="hidden" name="is_post" value="1" />
                            {if !$smarty.post|default:""}
                            <fieldset>
                                <ul>
                                    <li>
                                        <label class="desc {if $errors.file|default:""}error{/if}">
                                            Plik do importu
                                        </label>
                                        <div>
                                            <a href="javascript:void(0);" class="browse-by-ftp" data-file-holder="hidFileID">Dodaj przez FTP'a</a><br /><br />
                                            <input type="file" name="movie_upload" id="movie_upload" />
                                            <input type="hidden" name="hidFileID" id="hidFileID" value="" />
                                        </div>
                                    </li>
                                    <li class="buttons">
                                        <input class="submit" type="submit" value="Zapisz" />
                                    </li>
                                </ul>
                            </fieldset>
                            {else}
                                {if $errors|default:""}
                                <div class="response-msg error ui-corner-all">
                                    <span>Błąd</span>
                                    Plik zawiera błędy które należy poprawić przed importem
                                </div>
                                <fieldset>
                                    <ul>
                                        <li class="buttons">
                                            <input class="submit" type="button" value="Wgraj plik ponownie" onclick="javascript:window.location.href='{URL::site("admin/users/import")}';" />
                                        </li>
                                    </ul>
                                </fieldset>
                                {else}
                                <div class="response-msg success ui-corner-all">
                                    <span>Gratulacje</span>
                                    Dane w pliku są poprawne, możesz przejść do drugiego kroku
                                </div>
                                <fieldset>
                                    <ul>
                                        <li class="buttons">
                                            <input class="submit" type="button" value="Zapisz dane" onclick="javascript:window.location.href='{URL::site("admin/users/import2")}/{base64_encode($smarty.post.hidFileID)}';" />                                            
                                            <input class="submit" type="button" value="Wgraj plik ponownie" onclick="javascript:window.location.href='{URL::site("admin/users/import")}';" />
                                        </li>
                                    </ul>
                                </fieldset>
                                {/if}
                            {/if}
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="clear"></div>
            <div id="sidebar">
                <div class="sidebar-content">
                    <a id="close_sidebar" class="btn ui-state-default full-link ui-corner-all" href="#drill">
                        <span class="ui-icon ui-icon-circle-arrow-e"></span>
                        Zamknij
                    </a>
                    <a id="open_sidebar" class="btn tooltip ui-state-default full-link icon-only ui-corner-all" title="Otwórz" href="#">
                        <span class="ui-icon ui-icon-circle-arrow-w"></span>
                    </a>
                    <div class="hide_sidebar">
                        <div class="portlet ui-widget ui-widget-content ui-helper-clearfix ui-corner-all">
                            {include file="admin/students/menu.tpl"}
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    //upload movie
    $('#movie_upload').uploadify({
        'swf'      : '{helper function="url::site" param1="public/flash/uploadify.swf"}',
        'uploader' : '{helper function="url::site" param1="uploadify.php"}',
        'formData' : {
            'directory' : 'upload/import/'
        },
        'auto'     : true,
        'fileSizeLimit' : '1GB',
        'fileTypeDesc' : 'Pliki excel',
        'fileTypeExts' : '*.xls;*.xlsx;*.csv;*.ods',
        'multi'    : false,
        'uploadLimit' : 1,
        'removeCompleted' : false,
        'buttonText' : 'WYBIERZ PLIK',
        'onUploadSuccess' : function(file, data, response) {
            $('#hidFileID').val(data);
            //alert('Plik ' + file.name + ' został wgrany poprawnie, odpowiedź serwera - ' + response + ':' + data);
        }
    });
});
</script>