var JSSettings = function(){

	var REGEX_KEY = "<([a-zA-Z0-9_]+)>";

	var routes = {"minion":{"uri":"minion(\/<action>)(\/<task>)","defaults":{"controller":"minion","action":"execute"}},"smarty":{"uri":"smarty(\/<controller>)","defaults":{"controller":"smartydemo","action":"index"}},"imagefly":{"uri":"imagefly\/<params>\/<imagepath>","defaults":{"controller":"imagefly"}},"jssettings":{"uri":"media\/js\/jssettings.js","defaults":{"controller":"jssettings","action":"script"}},"module\/articles\/read":{"uri":"module\/articles\/<category>\/<slug>","defaults":{"controller":"articles","action":"read","category":null,"slug":null}},"module\/articles":{"uri":"module\/articles\/<category>","defaults":{"controller":"articles","action":"list","category":null}},"admin":{"uri":"(<lang>\/)admin(\/<controller>(\/<action>(\/<id>(\/<stuff>(\/<stuff2>(\/<stuff3>(\/<stuff4>)))))))","defaults":{"controller":"welcome","action":"index","directory":"admin","id":null,"stuff":null,"stuff2":null,"stuff3":null,"stuff4":null}},"page":{"uri":"page(\/<permalink>)","defaults":{"controller":"page","action":"index","permalink":""}},"error":{"uri":"error\/<action>(\/<message>)","defaults":{"controller":"error_handler"}},"category":{"uri":"c<id>(\/<page>)\/<slug>(\/<order_how>\/<order_type>(\/<licencee>))","defaults":{"controller":"category","action":"index","id":null,"slug":null,"order_how":null,"order_type":null,"licencee":null}},"file\/download":{"uri":"dm\/<id>","defaults":{"controller":"file","action":"download"}},"file\/mirrors":{"uri":"v\/<id>","defaults":{"controller":"file","action":"mirrors"}},"file\/reviews":{"uri":"<id>\/<slug>\/reviews","defaults":{"controller":"file","action":"reviews"}},"file\/track":{"uri":"<id>\/<slug>\/track","defaults":{"controller":"file","action":"track"}},"file":{"uri":"<id>\/<slug>","defaults":{"controller":"file","action":"index"}},"default":{"uri":"(<controller>(\/<action>(\/<id>(\/<stuff>(\/<stuff2>(\/<stuff3>(\/<stuff4>)))))))","defaults":{"controller":"index","action":"index"}}};
	var config = [];
	var properties = {"kohana":{"base_url":"\/","index_file":""},"request":{"protocol":""}};

	// Useful for me to clone objects
	var clone = function(obj){
		if(obj == null || typeof(obj) != 'object')
			return obj;

		var temp = new obj.constructor();
		for(var key in obj)
			temp[key] = clone(obj[key]);

		return temp;
	}

	return {
		/**
		 * The getter methods should return clones of the values to protect
		 * the properties from being altered... I hope
		 */
		property: {
			"get": function(name) {
				if (properties[name] == undefined)
					throw("Invalid property specified: " + name);

				return clone(properties[name]);
			}
		},
		config: {
			"get": function(name) {
				if (config[name] == undefined)
					throw("Invalid config specified: " + name);

				return clone(config[name]);
			}
		},
		url: {
			/**
			 * Gets the base URL to the application. To include the current protocol,
			 * use TRUE. To specify a protocol, provide the protocol as a string.
			 *
			 * @param   boolean         add index file
			 * @param   boolean|string  add protocol and domain
			 * @return  string
			 */
			base: function(index, protocol) {
				var kohana = JSSettings.property.get("kohana");

				if (protocol == undefined)
				{
					protocol = true;
				}

				if (protocol === true) {
					// Use the current protocol
					protocol = JSSettings.property.get("request").protocol;
				}

				// Start with the configured base URL
				
				base_url = kohana.base_url;

				if (index === true && kohana.index_file !== "") {
					// Add the index file to the URL
					base_url = base_url + kohana.index_file + "/";
				}

				if (typeof protocol === "string") {
					// See if this was a full url
					var check = base_url.indexOf("://");
					if (check !== -1) {
						var section = base_url.substring(check + 3);
						// Remove everything but the path from the URL
						base_url = section.substring(section.indexOf("/"));
					}

					// Add the protocol and domain to the base URL
					base_url = protocol + "://" + location.host + base_url;
				}

				return base_url;
			},
			site: function(uri, protocol) {
				return JSSettings.url.base(true, protocol) + uri;
			}
		},
		route: {
			"get": function(name) {
				if (routes[name] == undefined)
					throw("Invalid route specified: " + name);

				return clone(routes[name]);
			},
			"uri": function(route, params){

				var route = JSSettings.route.get(route);

				if (params != undefined){
					// merge the parameters into defaults for this route
					for (attribute in params){
						route.defaults[attribute] = params[attribute];
					}
				}

				if (route.uri.indexOf("<") === -1 && route.uri.indexOf("(") === -1){
					// This is a static route, no need to replace anything
					return route.uri;
				}

				do {
					var matches = route.uri.match(/\([^()]+\)/g);

					if (matches == null) {
						break;
					}

					// Search for the matched value
					var search = matches[0];

					// Remove the parenthesis from the match as the replace
					var replace = search.substring(1, search.length - 1);
					
					do {
						var regexp = new RegExp(REGEX_KEY, "g");
						var match = regexp.exec(replace);

						if (match == null) {
							break;
						}

						var key = match[0];
						var param = match[1];

						if (route.defaults[param]) {
							// Replace the key with the parameter value
							replace = replace.replace(key, route.defaults[param]);
						} else {
							// This group has missing parameters
							replace = '';
							break;
						}

					} while (match != null)

					// Replace the group in the URI
					route.uri = route.uri.replace(search, replace);

				} while (matches != null);

				do {
					var match = regexp.exec(route.uri);
					
					if (match == null)
					{
						break;
					}

					var key = match[0];
					var param = match[1];

					if (route.defaults[param] == null) {
						// Ungrouped parameters are required
						throw("Required route parameter not passed: " + param);
					}
					
					route.uri = route.uri.replace(key, route.defaults[param]);
				} while (match != null);

				return route.uri;
			},
			"url": function(name, params, protocol) {
				return JSSettings.url.site(JSSettings.route.uri(name, params), protocol)
			}
		}
	}
}();

// ex: alert(JSSettings.route.url('default', {"controller": "main", "action": "index", "id": "5"}));
