<?php defined('SYSPATH') or die ('No direct script access.');
/**
 * Jelly Auth User Model
 * @package Jelly Auth
 * @author	Israel Canasa
 */
class Model_Auth_User extends Jelly_Model
{
	public static function initialize(Jelly_Meta $meta)
    {
		$meta->name_key('username')
			->fields(array(
			'id' => new Field_Primary,
			'username' => new Field_String(array(
				'unique' => TRUE
			)),
			'password' => new Field_Password(array(
				'hash_with' => array(Auth::instance(), 'hash_password')
			)),
			'password_confirm' => new Field_Password(array(
				'in_db' => FALSE,
				'callbacks' => array(
					'matches' => array('Model_Auth_User', '_check_password_matches')
				)
			)),
            'firstname' => Jelly::field('string'),
            'lastname' => Jelly::field('string'),
            'city' => Jelly::field('string'),
            'address' => Jelly::field('string'),
            'home' => Jelly::field('string'),
            'flat' => Jelly::field('string'),
            'postcode' => Jelly::field('string'),
            'province' => new Field_Integer,
            'phone1' => Jelly::field('string'),
            'phone2' => Jelly::field('string'),
            'icon' => Jelly::field('string'),
			'subject' => Jelly::field('string'),
            'is_first' => Jelly::field('integer', array(
                'default' => 1
            )),
			'email' => new Field_Email(array(
				'unique' => TRUE,
			)),
			'logins' => new Field_Integer(array(
				'default' => 0
			)),
            'registered' => new Field_String(array(
                'default' => time()
            )),
			'last_login' => new Field_String,
            'active' => new Field_Integer(array(
                'default' => 0
            )),
			'tokens' => new Field_HasMany(array(
				'foreign' => 'user_token'
			)),
			'roles' => new Field_ManyToMany,
            'user_groups' => new Field_ManyToMany,
            'course' => new Field_ManyToMany(array(
                'foreign' => 'user',
                'through' => array(
                    'modle' => 'course_teachers',
                    'columns' => array('user_id', 'course_id')
                )
            )),
            'courses' => new Field_HasMany(array(
                'foreign' => 'course_user',
                'column' => 'user_id',
            )),
            'comment' => new Field_HasMany,
            'messages' => new Field_HasMany,
            'course_moderators' => new Field_ManyToMany(array(
                'foreign' => 'course',
                'through' => array(
                    'model'   => 'course_moderators',
                    'columns' => array('user_id', 'course_id'),
                )
            )),
            'certificate_history' => new Field_HasMany,
            'school' => Jelly::field('belongsto', array(
                'null' => TRUE
            )),
            'class' => Jelly::field('belongsto', array(
                'foreign' => 'school_class',
                'column' => 'class_id',
                'null' => TRUE
            ))
		));
    }

    /**
    * Pobierz informacje o slajdzie na ktorym zakonczono
    */
    public function finish_material($coure_id) {
    	$item = Jelly::select('material_stat')
    		->where('user_id', '=', $this->id)
    		->where('course_id', '=', $course_id)
    		->order_by('id','DESC')
    		->limit(1)
    		->execute();

    	return $item;
    }
    
    public static function is_email_uniq(Validate $array, $field) {
        $check  = Jelly::select('user')->where('email','=',$array[$field])->limit(1)->execute();
        
        if ($check->loaded()) {
            $array->error($field, 'not_uniq');
        }
    }
    
    public static function is_username_uniq(Validate $array, $field) {
        $check  = Jelly::select('user')->where('username','=',$array[$field])->limit(1)->execute();
        
        if ($check->loaded()) {
            $array->error($field, 'not_uniq');
        }
    }
    
    public static function email_change(Validate $array, $field) {
		$exists = (bool) DB::select(array('COUNT("*")', 'total_count'))
            ->from('users')
		    ->where('email', '=', $array[$field])
			->where('id', '!=', $array['id'])
			->execute()
			->get('total_count');
 
		if ($exists) {
			$array->error($field, 'not_uniq', array($array[$field]));
        }
	}
    
    public static function username_change(Validate $array, $field) {
		$exists = (bool) DB::select(array('COUNT("*")', 'total_count'))
            ->from('users')
		    ->where('username', '=', $array[$field])
			->where('id', '!=', $array['id'])
			->execute()
			->get('total_count');
 
		if ($exists) {
			$array->error($field, 'not_uniq', array($array[$field]));
        }
	}
    
    public function is_subscribed($course_id = null) {
        $counter = Jelly::select('course_user')->filter($this->id, $course_id)->count();
        
        return $counter;
    }
    
    public function course_status($course_id = null) {
        $subscribe = Jelly::select('course_user')->filter($this->id, $course_id)->limit(1)->execute();
                
        return $subscribe;
    }
    
    public function count_subscribes() {
        $counter = Jelly::select('course_user')->filter($this->id)->count();
        
        return $counter;
    }
    
    
    
	/**
	 * Validate callback wrapper for checking password match
	 * @param Validate $array
	 * @param string   $field
	 * @return void
	 */
	public static function _check_password_matches(Validate $array, $field)
	{
		$auth = Auth::instance();
		
		if ($array['password'] !== $array[$field])
		{
			// Re-use the error messge from the 'matches' rule in Validate
			$array->error($field, 'matches', array('param1' => 'password'));
		}
	}
	
	/**
	 * Check if user has a particular role
	 * @param mixed $role 	Role to test for, can be Model_Role object, string role name of integer role id
	 * @return bool			Whether or not the user has the requested role
	 */
	public function has_role($role)
	{
		// Check what sort of argument we have been passed
		if ($role instanceof Model_Role)
		{
			$key = 'id';
			$val = $role->id;
		}
		elseif (is_string($role))
		{
			$key = 'name';
			$val = $role;
		}
		else
		{
			$key = 'id';
			$val = (int) $role;
		}

		foreach ($this->roles as $user_role)
		{	
			if ($user_role->{$key} === $val)
			{
				return TRUE;
			}
		}
		
		return FALSE;
	}
	
} // End Model_Auth_User