<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor/mpdf', 'mpdf');

class Controller_Admin_Certificates extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('certificates', 'list');

        $this->template->content = View::factory('admin/certificates/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('certificate');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        if (input::get('limit')) {
            $limit = input::get('limit');
        }
        else {
            $limit = 10;
        }

        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('certificates', 'add');

        $this->template->content = View::factory('smarty:admin/certificates/add')
            ->bind('errors', $errors)
            ->bind('users', $users);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array(20));
            
            if ($post->check())
            {
                $item = Jelly::factory('certificate');
                $item->name = Security::xss_clean(input::post('name'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                Tracker::track(__('Dodano certyfikat ID: ').$item->id);

                message::good(__('Dodanie pzebiegło pomyślnie'), 'admin/certificates'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/certificates/form');
            }
        }
    }

    public function action_edit() {
        parent::$_acl->check('certificates', 'edit');

        $this->template->content = View::factory('smarty:admin/certificates/edit')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('certificate', (int)$this->request->param('id'));

        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array(20));
            
            if ($post->check())
            {                
                $item->name = Security::xss_clean(input::post('name'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                Tracker::track(__('Edycja certyfikatu ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/certificates'.URL::query());
            }
            else {
                $errors = $post->errors('backend/certificates/form');
            }
        }
    }
    
    public function action_preview() {
        //reszta generowania
        $item = Jelly::select('certificate', $this->request->param('id'));            
        
        $replaceData = array();
        $replaceData['[course_name]'] = 'Testowe szkolenie';
        $replaceData['[course_description]'] = 'Testowy opis szkolenia';
        $replaceData['[date_begin]'] = date('Y-m-d', time());
        $replaceData['[date_end]'] = date('Y-m-d', time());
        $replaceData['[display_name]'] = 'Kursant Testowy';
        $replaceData['[date_enroll]'] = date('Y-m-d', time());
        $replaceData['[date_complete]'] = date('Y-m-d', time());
        $replaceData['[total_time]'] = '1 dzień 2 godz 3 min';
        $replaceData['[today]'] = date('d/m', time());
        $replaceData['[year]'] = date('Y', time());                        
                        
        $content = str_replace(array_keys($replaceData), array_values($replaceData), $item->content);
        
        $content = View::factory('smarty:site/certificate/schema')
            ->bind('content', $content)
            ->bind('icon', $item->icon)
            ->render();
        
        $mpdf=new mPDF('UTF-8', 'A4', 10, 'arial'); 
        
        $mpdf->mirrorMargins = 1;	// Use different Odd/Even headers and footers and mirror margins
        
        $mpdf->defaultheaderfontsize = 10;	/* in pts */
        $mpdf->defaultheaderfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultheaderline = 0; 	/* 1 to include line below header/above footer */
        
        $mpdf->defaultfooterfontsize = 12;	/* in pts */
        $mpdf->defaultfooterfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultfooterline = 0; 	/* 1 to include line below header/above footer */
                
        $mpdf->WriteHTML($content);
        $mpdf->Output('certyfikat.pdf', 'D');
        
        exit;
    }

    public function action_delete() {
        parent::$_acl->check('certificates', 'delete');

        $item = Jelly::select('certificate', $this->request->param('id'));

        if ($item->loaded()) {
            Tracker::track(__('Usunięto certyfikat ID: ').$item->id);
            
            $item->delete();

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/certificates'.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania certyfikatu'), 'admin');
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('certificates', 'delete');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('certificate', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto certyfikat ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                    break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/certificates'.URL::query());
        }
    }
}
