<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Circles extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('circles', 'list');
        
        $this->template->content = View::factory('admin/circles/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('circle');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'symbol' => URL::query(array('sort' => 'symbol', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'symbol':
                $builder->order_by('symbol', $order_how);
                $current_sort = array('type' => 'symbol', 'how' => $order_how);
            break;            
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('circles', 'add');
        
        $this->template->content = View::factory('admin/circles/add.tpl')
            ->bind('errors', $errors);        
            
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('symbol', 'not_empty')
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('circle');
                $item->symbol = Security::xss_clean(input::post('symbol'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Dodano koło naukowe ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/circles');
            }
            else
            {
                $errors = $post->errors('backend/circles/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('circles', 'edit');
        
        $this->template->content = View::factory('admin/circles/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('circle', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('symbol', 'not_empty')
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->symbol = Security::xss_clean(input::post('symbol'));
                $item->save();

                Tracker::track('Edycja koła naukowego ID: '.$item->id);

                message::good('Edycja przebiegła pomyślnie', 'admin/circles');
            }
            else
            {
                $errors = $post->errors('backend/circles/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('circles', 'delete');
        
        $item = Jelly::select('circle', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->delete();

            Tracker::track('Usunięto koło naukowe ID: ' . $this->request->param('id'));

            message::good('Zlecenie zostało usunięte pomyślnie', 'admin/circles');
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania zlecenia', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/circles'.URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        parent::$_acl->check('circles', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('circle')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto koło naukowe ID: '.$it->id);
                
                $it->delete();
            }
        }
    }
}