<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Course_Groups extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('courses_groups', 'list');

        $this->template->content = View::factory('admin/courses/groups/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $builder = Jelly::select('course_group');

        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'     => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'status'   => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        if (input::get('limit')) {
            $limit = input::get('limit');  
        }
        else {
            $limit = 10;  
        }

        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add() {
        parent::$_acl->check('courses_groups', 'add');

        $this->template->content = View::factory('smarty:admin/courses/groups/add')
            ->bind('errors', $errors)
            ->bind('categories', $categories);
        
        $categories = Jelly::select('course_category')->execute();
        
        if ($_POST) {
           $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');

            if ($post->check()) {
                $item = Jelly::factory('course_group');
                $item->preparePosy();
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track(__('Dodano grupe szkoleń ID: ').$item->id);

                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/course_groups');
            }
            else {
                $errors = $post->errors('backend/course/group/form');
            }
        }
    }

    public function action_edit() {
        parent::$_acl->check('courses_groups', 'edit');

        $this->template->content = View::factory('smarty:admin/courses/groups/edit')
            ->bind('errors', $errors)
            ->bind('item', $item);
            
        $item = Jelly::select('course_group', $this->request->param('id'));
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');

            if ($post->check()) {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();
                
                Tracker::track(__('Edycja grupy szkoleń ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/course_groups'.URL::query());
            }
            else {
                $errors = $post->errors('backend/course/group/form');
            }
        }
    }

    public function action_up() {
        parent::$_acl->check('courses_groups', 'edit');

        $item = Jelly::select('course_group', $this->request->param('id'));
        if ($item->loaded()) {
            $item->positionUp();

            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/course_groups'.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }

    public function action_down() {
        parent::$_acl->check('courses_groups', 'edit');

        $item = Jelly::select('course_group', $this->request->param('id'));
        if ($item->loaded()) {
            $item->positionDown();

            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/course_groups'.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }

    public function action_status() {
        parent::$_acl->check('courses_groups', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('course_group', $this->request->param('id'));
            if ($item->loaded()) {                
                Tracker::track('Zmiana statusu grupy szkoleń ID: '.$item->id);
                
                $item->active = $this->request->param('stuff');
                $item->save();

                message::good(__('Status został zmieniony pomyślnie'), 'admin/course_groups'.URL::query());
            }
            else {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_delete() {
        parent::$_acl->check('courses_groups', 'delete');

        $item = Jelly::select('course_group', $this->request->param('id'));

        if ($item->loaded()) {
            Tracker::track(__('Usunięto grupe szkoleń ID: ').$item->id);
            
            $item->delete();

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/course_groups'.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin'.URL::query());
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('courses_groups', 'delete');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_group', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto grupe szkoleń ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('course_groups', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_group', $value);
                            if ($item->loaded()) {
                                Tracker::track('Zmiana statusu grupy szkoleń ID: '.$item->id);
                                
                                $item->active = 1;
                                $item->save();
                            }
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('course_groups', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_group', $value);
                            if ($item->loaded()) {
                                Tracker::track('Zmiana statusu grupy szkoleń ID: '.$item->id);
                                
                                $item->active = 0;
                                $item->save();
                            }
                        }
                    }
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/course_groups'.URL::query());
        }
    }
}
