<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Course_Pages extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/courses/pages/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $tree);
        
        $message = message::get_once();
            
        $item_id = $this->request->param('id');
        
        $root = Jelly::factory('course_page')->root($item_id);
        $tree = $root->descendants(false, 'ASC');
    }
    
    public function action_add()
    {
        $this->template->content = View::factory('admin/courses/pages/add.tpl')
            ->bind('errors', $errors)
            ->bind('tree', $tree);
        
        $item_id = $this->request->param('id');
        
        $root = Jelly::factory('course_page')->root($item_id);
        $tree = $root->descendants(false, 'ASC');
                
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('course_page');
                if (input::post('category') == 0)
                {
                    $root2 = $item->root($item_id);
                    if (!$root2->loaded())
                    {
                        $page2 = Jelly::factory('course_page');
                        $page2->parent_id = 0;
                        $page2->name = 'ROOT';
                        $page2->insert_as_new_root($item_id);
                        $page2->save();
                    }
                    
                    $root = Jelly::factory('course_page')->root($item_id);
                    $item->parent_id = 0;
                    $item->insert_as_last_child($root);
                }
                else
                {
                    $item->parent_id = input::post('category');
                    $item->insert_as_last_child(input::post('category'));
                }          
                
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->slug = $item->mod_url(URL::prepare_url(input::post('name')));
                $item->save();
                
                //zalaczniki
                $attachments = explode(',', input::post('attachments_id'));
                for ($i = 0; $i <= sizeof($attachments); $i++) {
                    if (isset($attachments[$i]))
                    {
                        $attachment = Jelly::select('attachment')
                            ->where('slug', '=', $attachments[$i])
                            ->limit(1)
                            ->execute();
                            
                        if ($attachment->loaded())
                        {
                            $attachment->obj_id = $item->id;
                            $attachment->save();
                        }
                    }
                }
                                
                Tracker::track(__('Dodano kategorie w bibliotece ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/course_pages/index/'.$item->scope);
            }
            else
            {
                $errors = $post->errors('backend/course/pages/form');
            }            
        }
     }

     public function action_edit()
     {
        $this->template->content = View::factory('admin/courses/pages/edit.tpl')
            ->bind('errors', $errors)
            ->bind('root', $root)
            ->bind('tree', $tree)
            ->bind('item', $item)
            ->bind('content', $content);
        
        $item = Jelly::select('course_page', $this->request->param('id'));
        
        $root = Jelly::factory('course_page')->root($item->scope);
        $tree = $root->descendants(false, 'ASC');
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->slug = $item->mod_url(URL::prepare_url(input::post('name')));
                $item->save();
                
                if ($item->parent->id != (INT)input::post('category'))
                {
                    $item->parent_id = input::post('category');
                    $item->move_to_first_child(input::post('category'));
                    $item->reload();
                    $item->save();
                }
                                
                Tracker::track(__('Dodano kategorie w bibliotece ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/course_pages/index/'.$item->scope);
            }
            else
            {
                $errors = $post->errors('backend/course/pages/form');
            }            
        }
     }
     
     public function action_up()
     {
        $item = Jelly::select('course_page', $this->request->param('id'));
        if ($item->loaded()) 
        {
            $item->move_up();
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/course_pages/index/'.$item->scope);
        }
        else
        {
            message::error('Wystąpił błąd podczas zmiany pozycji', 'admin');
        }
     }
     
     public function action_down()
     {
        $item = Jelly::select('course_page', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->move_down();
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/course_pages/index/'.$item->scope);
        }
        else
        {
            message::error('Wystąpił błąd podczas zmiany pozycji', 'admin');
        }
     }

     public function action_delete()
     {
        $item = Jelly::select('course_page', $this->request->param('id'));        
        if ($item->loaded())
        {
            Tracker::track(__('Usunięto kategorii ze struktury strony ID: ').$item->id);
            
            $item_id = $item->scope;
            
            $item->delete_obj();
            
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/course_pages/index/'.$item_id);
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
     }

     public function action_checkbox()
     {
        if ($_POST)
        {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('pages', 'delete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_page', $value);
                            if ($item->loaded())
                            {
                                $item->delete_obj();                                
                            }
                        }
                    }
                break;
            }
            
            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/course_pages/index/'.$this->request->param('id'));
        }
     }
}
