<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Categories extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/forum/categories/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items);

        $message = message::get_once();

        $items = Jelly::select('forum_category')->execute();
    }

    public function action_add()
    {
        $this->template->content = View::factory('admin/forum/categories/add.tpl')
            ->bind('errors', $errors);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('forum_category');
                $item->preparePosy();
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->posy = 1;
                $item->save();

                Tracker::track('Dodano kategorie forum ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/forum_categories');
            }
            else
            {
                $errors = $post->errors('backend/forum/categories/form');
            }
        }
    }

    public function action_edit()
    {
        $this->template->content = View::factory('admin/forum/categories/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('forum_category', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->name = input::post('name');
                $item->content = input::post('content');
                $item->save();

                Tracker::track('Edycja kategorii forum ID: ' . $this->request->param('id'));

                message::good('Edycja przebiegła pomyślnie', 'admin/forum_categories');
            }
            else
            {
                $errors = $post->errors('backend/forum/categories/form');
            }
        }
    }

    public function action_status()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_category', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu kategorii forum ID: '.$this->request->param('id'));

                message::good('Status został zmieniony pomyślnie', 'admin/forum_categories');
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin');
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_up()
    {
        $item = Jelly::select('forum_category', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->positionUp();
            
            Tracker::track('Zmieniono pozycje kategorii forum ID: ' . $this->request->param('id'));
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas ustawiania pozycji', 'admin');
        }
    }
     
    public function action_down()
    {
        $item = Jelly::select('forum_category', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->positionDown();
            
            Tracker::track('Zmieniono pozycje kategorii forum ID: '.$this->request->param('id'));
            
            message::good('Pozycja została zmieniona pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas ustawiania pozycji', 'admin');
        }
    }

    public function action_delete()
    {
        $item = Jelly::select('forum_category', $this->request->param('id'));
        if ($item->loaded())
        {   
            Tracker::track('Usunięto kategorie for ID: '.$item->id);
            
            $item->delete();

            message::good('Usunięcie przebiegło pomyślnie', 'admin/forum_categories');
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin');
        }
    }
}