<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Moderators extends Relio_Controller_Admin {
    public function action_index() {
        ////parent::$_acl->check('courses_groups', 'add');

        $this->template->content = View::factory('smarty:admin/forum/moderators/list')
            ->bind('errors', $errors)
            ->bind('items', $items)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort)
            ->bind('forum_id', $forum_id)
            ->bind('checked_moderators', $checked_moderators)
            ->bind('limit0', $limit0)
            ->bind('limit10', $limit10)
            ->bind('limit25', $limit25)
            ->bind('limit50', $limit50)
            ->bind('limit100', $limit100);
            
        $forum_id = $this->request->param('id');
        
        $limit0 = URL::query(array('limit' => 0));
        $limit10 = URL::query(array('limit' => 10));
        $limit25 = URL::query(array('limit' => 25));
        $limit50 = URL::query(array('limit' => 50));
        $limit100 = URL::query(array('limit' => 100));
        
        $builder = Jelly::select('user')->filter(input::get('q'));
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname'   => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'   => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'email' => URL::query(array('sort' => 'email', 'how' => $order_direction)),
            'role'   => URL::query(array('sort' => 'role', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'email':
                $builder->order_by('email', $order_how);
                $current_sort = array('type' => 'email', 'how' => $order_how);
            break;
            case 'role':
                $builder->join('roles', 'LEFT')
                    ->on('roles.id', '=', 'roles_users.role_id')
                    ->order_by('roles.description', $order_how);
                    
                $current_sort = array('type' => 'role', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $items = $builder->execute();
        
        $checked_moderators = array();
        $moderators = Jelly::select('forum_mod')->where('forum_id','=',$this->request->param('id'))->execute();
        foreach($moderators as $mod) {
            $checked_moderators[] = $mod->user->id;
        }
        
        if ($_POST) {
            try {
                DB::delete('forum_mods')->where('forum_id','=',$this->request->param('id'))->execute();
                
                foreach (input::post('list') as $user) {
                    if (!empty($user)) {
                        $item = Jelly::factory('forum_mod');
                        $item->user = $user;
                        $item->forum = $this->request->param('id');
                        $item->save();
                    }
                }
                
                Tracker::track('Dodano moderatora do forum ID: '.$this->request->param('id'));

                message::good('Moderator został dodany pomyślnie', 'admin/forum_categories');
            }
            catch (Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }
}