<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Groups extends Relio_Controller_Admin {
    protected $disallow = array('4', '3', '2', '1');
    
	public function action_index()
    {
	    parent::$_acl->check('groups', 'list');
		
        $this->template->content = View::factory('smarty:admin/users/groups/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);
        
        $message = message::get_once();

        $builder = Jelly::select('role')->where('name','<>','login');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('description', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            default:
            break;
        }
                
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
	}
    
    public function action_add()
    {
        parent::$_acl->check('groups', 'add');
        
        $this->template->content = View::factory('smarty:admin/users/groups/add')
            ->bind('errors', $errors)
            ->bind('resources', $resources);
        
        $resources = parent::$_acl->listResourcesWithActions();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('description', 'not_empty');

            if ($post->check())
            {
                $item = Jelly::factory('role');
                $item->name = Security::xss_clean(input::post('name'));
                $item->description = Security::xss_clean(input::post('description'));
                $item->save();
                
                foreach ((array)input::post('perm') as $key => $value) {
                    foreach($value as $vkey => $vvalue) {
                        parent::$_acl->addPermission($item->id, $key, $vkey);
                    }
                }
                
                Tracker::track(__('Dodano grupe ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/groups');
            }
            else
            {
                $errors = $post->errors('backend/groups/form');
            }
        }
    }
    
    public function action_edit()
    {
        parent::$_acl->check('groups', 'edit');
                
        $this->template->content = View::factory('smarty:admin/users/groups/edit')
            ->bind('errors', $errors)
            ->bind('allowed', $allowed)
            ->bind('resources', $resources)
            ->bind('item', $item);
            
        $allowed = array();
        foreach (parent::$_acl->listResourcesByGroup($this->request->param('id')) as $key => $r) {
            $allowed[$r['resource']][$r['permission']] = parent::$_acl->isUserAllowed($r['resource'], $r['permission']) ? 1 : 0;
        }
        
        $resources = parent::$_acl->listResourcesWithActions();
        
        $item = Jelly::select('role', $this->request->param('id'));  
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('description', 'not_empty');
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->description = Security::xss_clean(input::post('description'));
                $item->save();
                
                parent::$_acl->clearPermissionByGroup($item->id);
                foreach ((array)input::post('perm') as $key => $value) {
                    foreach($value as $vkey => $vvalue) {
                        parent::$_acl->addPermission($item->id, $key, $vkey);
                    }
                }
                
                Tracker::track(__('Edycja grupy ID: ').$item->id);
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/groups'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/groups/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('groups', 'delete');
        
        $item = Jelly::select('role', $this->request->param('id'));
                
        if ($item->loaded()) {
            if (in_array($this->request->param('id'), $this->disallow))
            {                
                message::error(__('Nie możesz usuwać głównych grup w systemie'), 'admin');
            }
            else
            {
                Tracker::track(__('Usunięto grupe ID: ').$item->id);
                
                $item->delete();
                
                message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/groups'.URL::query());
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('groups', 'delete');
                    
                    if (is_array(input::post('list')))
                    {
                        foreach(input::post('list') as $key => $value) {
                            if (!in_array($value, $this->disallow))
                            {
                                $item = Jelly::select('role', $value);
                                if ($item->loaded())
                                {
                                    Tracker::track(__('Usunięto grupe ID: ').$item->id);
                                        
                                    $item->delete();
                                }
                            }
                        }
                    }
                break;
                default:
                break;
            }
            
            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/groups'.URL::query());             
        }
    }
}