<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'pclzip/pcltrace.lib');
require_once Kohana::find_file('vendor', 'pclzip/pclzip-trace.lib');

class Controller_Admin_Material_Videosync extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('materials', 'edit');
        
        $this->template->content = View::factory('smarty:admin/materials/videosync/edit')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('lesson', $lesson)
            ->bind('slides', $slides)
            ->bind('parent_id', $parent_id);
    
        $item = Jelly::select('material', $this->request->param('id'));
        
        $lesson = Jelly::select('material_videosync')->by_material($item->id)->limit(1)->execute();

        $slides = Jelly::select('material_videosync_slide')
            ->where('material_id', '=', $item->id)
            ->execute()
            ->as_array();
        
        $parent_id = $item->category->first_parent_id;
                
        if ($_POST) {
            try {
                //video
                if (input::post('movie_action') == '3') {
                    if (input::post('hidFileID')) {
                        $moviefilename = trim(input::post('hidFileID'), '/');

                        if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies'))) {
                            $fileid = substr(md5(basename($moviefilename)), 0, 10);
                            $target = $fileid.'.jpg';

                            $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/materials/movie/'.$target, '00:00:10', '640x360');
                            $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);

                            $timer = $vinfo['duration'];
                        }
                        else {
                            $timer = null;
                        }
                   }
                   else {
                        $moviefilename = '';
                        $timer = null;
                   }
                }
                elseif (input::post('movie_action') == '1') {
                    $moviefilename = input::post('tmpMovie');
                    $timer = $lesson->timer;
                }
                elseif (input::post('movie_action') == '2') {
                    $moviefilename = '';
                    $timer = null;
                }
                else {
                    $moviefilename = '';
                    $timer = null;
                }
                
                $lesson->movie = $moviefilename;
                $lesson->movie_duration = $timer;
                $lesson->material = $item->id;
                $lesson->set($_POST);
                $lesson->save();
                
                //usun obecne slajdy
                DB::delete('material_videosync_slides')
                    ->where('material_id', '=', $item->id)
                    ->execute();

                $i = 0;
                foreach((array)input::post('slide') as $slides) {
                    $file = array(
                        'name'     => $_FILES['slide']['name'][$i]['file'],
                        'tmp_name' => $_FILES['slide']['tmp_name'][$i]['file'],
                        'type'     => $_FILES['slide']['type'][$i]['file'],
                        'error'    => $_FILES['slide']['error'][$i]['file'],
                        'size'     => $_FILES['slide']['size'][$i]['file']
                    );

                    switch($slides['image_action']) {
                        case '1':
                            $filename = $slides['tmpIcon'];
                        break;
                        case '2':
                            $filename = Upload::save($file, null, DOCROOT.'upload/materials/videosync');
                        break;
                        default:
                            $filename = '';
                        break;
                    }                    
                    
                    if (!empty($slides['time']) && !empty($filename)) {
                        $slide = Jelly::factory('material_videosync_slide');
                        $slide->material = $item->id;
                        $slide->time = $slides['time'];
                        $slide->icon = basename($filename);
                        $slide->save();
                    }

                    $i++;
                }
                
                /**
                 * Załączniki
                 */
                $attachments = explode(',', input::post('attachments_id'));
                for ($i = 0; $i <= sizeof($attachments); $i++) {
                    if (isset($attachments[$i])) {
                        $attachment = Jelly::select('attachment')->where('slug','=',$attachments[$i])->limit(1)->execute();
                        if ($attachment->loaded()) {
                            $attachment->obj_id = $item->id;
                            $attachment->save();
                        }
                    }
                }
                
                Tracker::track(__('Edycja materiału w bazie szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/base/index/'.$item->category->first_parent_id);
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors();
            }
        }
    }
    
    public function action_preview() {
        $lesson = Jelly::select('material_videosync', Request::instance()->param('id'));
		
        echo View::factory('smarty:admin/materials/videosync/preview')
            ->bind('lesson', $lesson)
            ->render();
        
        exit;
    }
}