<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Schools_Classes extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('schools_classes', 'list');
        
        $this->template->content = View::factory('admin/schools/classes/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $item_id = $this->request->param('id');

        $builder = Jelly::select('school_class')
            ->with('school')
            ->where('school_id', '=', $item_id);
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->where('_school:school.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;          
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('schools_classes', 'add');
        
        $this->template->content = View::factory('admin/schools/classes/add.tpl')
            ->bind('errors', $errors);
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('school_class');
                $item->school = $this->request->param('id');
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Dodano klase ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/schools_classes/index/'.$item->school->id);
            }
            else
            {
                $errors = $post->errors('backend/schools/classes/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('schools_classes', 'edit');
        
        $this->template->content = View::factory('admin/schools/classes/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('school_class', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Edycja klasy ID: '.$item->id);

                message::good('Edycja przebiegła pomyślnie', 'admin/schools_classes/index/'.$item->school->id);
            }
            else
            {
                $errors = $post->errors('backend/schools/classes/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('schools_classes', 'delete');
        
        $item = Jelly::select('school_class', $this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track('Usunięto klase ID: ' . $this->request->param('id'));
            
            $item_id = $item->school->id;
            
            $item->delete();

            message::good('Zlecenie zostało usunięte pomyślnie', 'admin/schools_classes/index/'.$item_id);
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania zlecenia', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/schools_classes/index/'.$this->request->param('id').URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        parent::$_acl->check('schools_classes', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('school_class')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto klase ID: '.$it->id);
                
                $it->delete();
            }
        }
    }
}